/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.mvc;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Addition;
import org.noear.solon.annotation.After;
import org.noear.solon.annotation.Before;
import org.noear.solon.annotation.Mapping;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.handle.Action;
import org.noear.solon.core.handle.ActionLoader;
import org.noear.solon.core.handle.Handler;
import org.noear.solon.core.handle.HandlerAide;
import org.noear.solon.core.handle.HandlerSlots;
import org.noear.solon.core.handle.MethodType;
import org.noear.solon.core.handle.MethodTypeUtil;
import org.noear.solon.core.handle.Render;
import org.noear.solon.core.mvc.ActionDefault;
import org.noear.solon.core.util.ClassUtil;
import org.noear.solon.core.util.ConsumerEx;
import org.noear.solon.core.util.LogUtil;

public class ActionLoaderDefault
extends HandlerAide
implements ActionLoader {
    protected BeanWrap bw;
    protected Render bRender;
    protected Mapping bMapping;
    protected String bPath;
    protected boolean bRemoting;
    protected boolean allowMapping;

    public ActionLoaderDefault(BeanWrap wrap) {
        this.bMapping = wrap.clz().getAnnotation(Mapping.class);
        if (this.bMapping == null) {
            this.initDo(wrap, null, wrap.remoting(), null, true);
        } else {
            String bPath = Utils.annoAlias(this.bMapping.value(), this.bMapping.path());
            this.initDo(wrap, bPath, wrap.remoting(), null, true);
        }
    }

    public ActionLoaderDefault(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        this.initDo(wrap, mapping, remoting, render, allowMapping);
    }

    protected void initDo(BeanWrap wrap, String mapping, boolean remoting, Render render, boolean allowMapping) {
        if (render == null && wrap.raw() instanceof Render) {
            render = (Render)wrap.raw();
        }
        this.bw = wrap;
        this.bRender = render;
        this.allowMapping = allowMapping;
        if (mapping != null) {
            this.bPath = mapping;
        }
        this.bRemoting = remoting;
    }

    @Override
    public String mapping() {
        return this.bPath;
    }

    @Override
    public void load(HandlerSlots slots) {
        this.load(this.bRemoting, slots);
    }

    protected void load(boolean all, HandlerSlots slots) {
        if (Handler.class.isAssignableFrom(this.bw.clz())) {
            this.loadHandlerDo(slots);
        } else {
            this.loadActions(slots, all || this.bRemoting);
        }
    }

    protected void loadHandlerDo(HandlerSlots slots) {
        if (this.bMapping == null) {
            throw new IllegalStateException(this.bw.clz().getName() + " No @Mapping!");
        }
        Handler handler = (Handler)this.bw.raw();
        Set<MethodType> v0 = Solon.app().factoryManager().mvcFactory().findMethodTypes(new HashSet<MethodType>(), t -> this.bw.annotationGet(t) != null);
        if (v0.size() == 0) {
            v0 = new HashSet<MethodType>(Arrays.asList(this.bMapping.method()));
        }
        slots.add(this.bMapping, v0, handler);
    }

    protected void loadActions(HandlerSlots slots, boolean all) {
        if (this.bPath == null) {
            this.bPath = "";
        }
        HashSet<MethodType> b_limitMethodSet = new HashSet<MethodType>();
        HashSet<MethodType> b_addinMethodSet = new HashSet<MethodType>();
        Solon.app().factoryManager().mvcFactory().findMethodTypes(b_limitMethodSet, t -> this.bw.clz().getAnnotation(t) != null);
        this.loadControllerAide(b_addinMethodSet);
        if (b_limitMethodSet.size() == 0 && this.bMapping != null) {
            for (MethodType b_mt : this.bMapping.method()) {
                if (b_mt == MethodType.ALL) continue;
                b_limitMethodSet.add(b_mt);
            }
        }
        for (Method method : ClassUtil.findPublicMethods(this.bw.clz())) {
            this.loadActionItem(slots, all, method, b_limitMethodSet, b_addinMethodSet);
        }
    }

    protected void loadActionItem(HandlerSlots slots, boolean all, Method method, Set<MethodType> b_limitMethodSet, Set<MethodType> b_addinMethodSet) {
        String m_path;
        Mapping m_map = method.getAnnotation(Mapping.class);
        if (m_map == null) {
            if (!Modifier.isPublic(method.getModifiers())) {
                return;
            }
        } else if (!Modifier.isPublic(method.getModifiers())) {
            LogUtil.global().warn("This mapping method is not public: " + method.getDeclaringClass().getName() + ":" + method.getName());
        }
        HashSet<MethodType> m_limitMethodSet = new HashSet<MethodType>(b_limitMethodSet);
        HashSet<MethodType> m_addinMethodSet = new HashSet<MethodType>(b_addinMethodSet);
        Solon.app().factoryManager().mvcFactory().findMethodTypes(m_limitMethodSet, t -> method.getAnnotation(t) != null);
        if (m_map != null) {
            m_path = Utils.annoAlias(m_map.value(), m_map.path());
            if (m_limitMethodSet.size() == 0) {
                m_limitMethodSet.addAll(Arrays.asList(m_map.method()));
            }
        } else {
            m_path = method.getName();
            if (m_limitMethodSet.size() == 0) {
                if (this.bMapping == null) {
                    m_limitMethodSet.add(MethodType.HTTP);
                } else {
                    m_limitMethodSet.addAll(Arrays.asList(this.bMapping.method()));
                }
            }
        }
        if (m_map != null || all) {
            String newPath = this.postActionPath(this.bw, this.bPath, method, m_path);
            Action action = this.createAction(this.bw, method, m_map, newPath, this.bRemoting);
            this.loadActionAide(method, action, m_addinMethodSet);
            if (m_limitMethodSet.size() > 0 && !m_limitMethodSet.contains((Object)MethodType.HTTP) && !m_limitMethodSet.contains((Object)MethodType.ALL)) {
                m_limitMethodSet.addAll(m_addinMethodSet);
            }
            for (MethodType m1 : m_limitMethodSet) {
                slots.add(newPath, m1, (Handler)action);
            }
        }
    }

    protected void loadControllerAide(Set<MethodType> addinMethodSet) {
        for (Annotation anno : this.bw.clz().getAnnotations()) {
            if (anno instanceof Before) {
                this.addDo(((Before)anno).value(), b -> this.before((Handler)this.bw.context().getBeanOrNew(b)));
                continue;
            }
            if (anno instanceof After) {
                this.addDo(((After)anno).value(), f -> this.after((Handler)this.bw.context().getBeanOrNew(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    this.addDo(((Before)anno2).value(), b -> this.before((Handler)this.bw.context().getBeanOrNew(b)));
                    continue;
                }
                if (anno2 instanceof After) {
                    this.addDo(((After)anno2).value(), f -> this.after((Handler)this.bw.context().getBeanOrNew(f)));
                    continue;
                }
                if (!(anno2 instanceof Addition)) continue;
                Addition additionAnno = (Addition)anno2;
                for (Class<? extends Annotation> annoClz : additionAnno.value()) {
                    MethodType methodType = MethodTypeUtil.valueOf(annoClz.getSimpleName().toUpperCase());
                    if (methodType == MethodType.UNKNOWN) continue;
                    addinMethodSet.add(methodType);
                }
            }
        }
    }

    protected void loadActionAide(Method method, Action action, Set<MethodType> addinMethodSet) {
        for (Annotation anno : method.getAnnotations()) {
            if (anno instanceof Before) {
                this.addDo(((Before)anno).value(), b -> action.before((Handler)this.bw.context().getBeanOrNew(b)));
                continue;
            }
            if (anno instanceof After) {
                this.addDo(((After)anno).value(), f -> action.after((Handler)this.bw.context().getBeanOrNew(f)));
                continue;
            }
            for (Annotation anno2 : anno.annotationType().getAnnotations()) {
                if (anno2 instanceof Before) {
                    this.addDo(((Before)anno2).value(), b -> action.before((Handler)this.bw.context().getBeanOrNew(b)));
                    continue;
                }
                if (anno2 instanceof After) {
                    this.addDo(((After)anno2).value(), f -> action.after((Handler)this.bw.context().getBeanOrNew(f)));
                    continue;
                }
                if (!(anno2 instanceof Addition)) continue;
                Addition additionAnno = (Addition)anno2;
                for (Class<? extends Annotation> annoClz : additionAnno.value()) {
                    MethodType methodType = MethodTypeUtil.valueOf(annoClz.getSimpleName().toUpperCase());
                    if (methodType == MethodType.UNKNOWN) continue;
                    addinMethodSet.add(methodType);
                }
            }
        }
    }

    protected String postActionPath(BeanWrap bw, String bPath, Method method, String mPath) {
        return Solon.app().factoryManager().mvcFactory().postActionPath(bw, bPath, method, mPath);
    }

    protected Action createAction(BeanWrap bw, Method method, Mapping mp, String path, boolean remoting) {
        if (this.allowMapping) {
            return new ActionDefault(bw, this, method, mp, path, remoting, this.bRender);
        }
        return new ActionDefault(bw, this, method, null, path, remoting, this.bRender);
    }

    protected <T> void addDo(T[] ary, ConsumerEx<T> fun) {
        if (ary != null) {
            for (T t : ary) {
                try {
                    fun.accept(t);
                }
                catch (RuntimeException ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new RuntimeException(ex);
                }
            }
        }
    }
}

