/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.noear.solon.Solon;
import org.noear.solon.SolonApp;
import org.noear.solon.Utils;
import org.noear.solon.annotation.Around;
import org.noear.solon.annotation.Inject;
import org.noear.solon.core.AppClassLoader;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.BeanBuilder;
import org.noear.solon.core.BeanExtractor;
import org.noear.solon.core.BeanInjector;
import org.noear.solon.core.BeanWrap;
import org.noear.solon.core.Lifecycle;
import org.noear.solon.core.Props;
import org.noear.solon.core.PropsConverter;
import org.noear.solon.core.VarHolder;
import org.noear.solon.core.aspect.Interceptor;
import org.noear.solon.core.aspect.InterceptorEntity;
import org.noear.solon.core.exception.InjectionException;
import org.noear.solon.core.runtime.AotCollector;
import org.noear.solon.core.util.ConvertUtil;
import org.noear.solon.core.util.RankEntity;
import org.noear.solon.core.util.ResourceUtil;
import org.noear.solon.core.util.TypeMap;

public abstract class BeanContainer {
    private final SolonApp app;
    private final Props props;
    private final ClassLoader classLoader;
    private Map<Class<?>, Object> attachs = new ConcurrentHashMap();
    private final AotCollector aot = new AotCollector();
    protected final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private final Map<Class<?>, BeanWrap> beanWrapsOfType = new HashMap();
    private final Map<String, BeanWrap> beanWrapsOfName = new HashMap<String, BeanWrap>();
    private final Set<BeanWrap> beanWrapSet = new HashSet<BeanWrap>();
    protected final Map<Class<?>, TypeMap<BeanBuilder<?>>> beanBuilders = new HashMap();
    protected final Map<Class<?>, TypeMap<BeanInjector<?>>> beanInjectors = new HashMap();
    protected final Map<Class<?>, BeanExtractor<?>> beanExtractors = new HashMap();
    protected final Map<Class<?>, InterceptorEntity> beanInterceptors = new HashMap();
    private final Map<Object, Set<Consumer<BeanWrap>>> beanHashSubscribersOfName = new HashMap<Object, Set<Consumer<BeanWrap>>>();
    private final Map<Object, Set<Consumer<BeanWrap>>> beanHashSubscribersOfType = new HashMap<Object, Set<Consumer<BeanWrap>>>();
    private final List<RankEntity<Consumer<BeanWrap>>> beanBaseSubscribersOfType = new ArrayList<RankEntity<Consumer<BeanWrap>>>();

    public BeanContainer(SolonApp app, ClassLoader classLoader, Props props) {
        this.app = app;
        this.classLoader = classLoader;
        this.props = props;
    }

    public SolonApp app() {
        return this.app;
    }

    public Props cfg() {
        if (this.props == null) {
            return Solon.cfg();
        }
        return this.props;
    }

    public AotCollector aot() {
        return this.aot;
    }

    public <T> T attachGet(Class<T> clz) {
        return (T)this.attachs.get(clz);
    }

    public <T> void attachSet(Class<T> clz, T val) {
        this.attachs.put(clz, val);
    }

    public <T> T attachOf(Class<T> clz, Supplier<T> supplier) {
        return (T)this.attachs.computeIfAbsent(clz, k -> {
            Object tmp = supplier.get();
            this.wrapAndPut((Class<?>)k, tmp);
            return tmp;
        });
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            return AppClassLoader.global();
        }
        return this.classLoader;
    }

    public void clear() {
        this.beanWrapsOfType.clear();
        this.beanWrapsOfName.clear();
        this.beanWrapSet.clear();
        this.attachs.clear();
        this.aot.clear();
    }

    public void copyTo(BeanContainer container) {
        this.beanBuilders.forEach((k, v) -> container.beanBuilders.putIfAbsent((Class<?>)k, (TypeMap<BeanBuilder<?>>)v));
        this.beanInjectors.forEach((k, v) -> container.beanInjectors.putIfAbsent((Class<?>)k, (TypeMap<BeanInjector<?>>)v));
        this.beanInterceptors.forEach((k, v) -> container.beanInterceptors.putIfAbsent((Class<?>)k, (InterceptorEntity)v));
        this.beanExtractors.forEach((k, v) -> container.beanExtractors.putIfAbsent((Class<?>)k, (BeanExtractor<?>)v));
    }

    public <T extends Annotation> void beanBuilderAdd(Class<T> annoClz, BeanBuilder<T> builder) {
        TypeMap tmp = this.beanBuilders.computeIfAbsent(annoClz, k -> new TypeMap());
        tmp.def(builder);
    }

    public <T extends Annotation> void beanBuilderAdd(Class<T> annoClz, Class<?> targetClz, BeanBuilder<T> builder) {
        TypeMap tmp = this.beanBuilders.computeIfAbsent(annoClz, k -> new TypeMap());
        tmp.put(targetClz, builder);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> annoClz, BeanInjector<T> injector) {
        TypeMap tmp = this.beanInjectors.computeIfAbsent(annoClz, k -> new TypeMap());
        tmp.def(injector);
    }

    public <T extends Annotation> void beanInjectorAdd(Class<T> annoClz, Class<?> targetClz, BeanInjector<T> injector) {
        TypeMap tmp = this.beanInjectors.computeIfAbsent(annoClz, k -> new TypeMap());
        tmp.put(targetClz, injector);
    }

    public <T extends Annotation> void beanExtractorAdd(Class<T> annoClz, BeanExtractor<T> extractor) {
        this.beanExtractors.put(annoClz, extractor);
    }

    public boolean beanExtractorHas(Class<? extends Annotation> annoClz) {
        return this.beanExtractors.containsKey(annoClz);
    }

    public <T extends Annotation> void beanInterceptorAdd(Class<T> annoClz, Interceptor interceptor, int index) {
        this.beanInterceptors.put(annoClz, new InterceptorEntity(index, interceptor));
    }

    public <T extends Annotation> void beanInterceptorAdd(Class<T> annoClz, Interceptor interceptor) {
        this.beanInterceptorAdd(annoClz, interceptor, 0);
    }

    public <T extends Annotation> InterceptorEntity beanInterceptorGet(Class<T> annoClz) {
        return this.beanInterceptors.get(annoClz);
    }

    public boolean beanInterceptorHas(AnnotatedElement ae) {
        for (Annotation a : ae.getAnnotations()) {
            if (!this.beanInterceptorHas(a)) continue;
            return true;
        }
        return false;
    }

    public boolean beanInterceptorHas(Annotation a) {
        return this.beanInterceptors.containsKey(a.annotationType()) || a.annotationType().isAnnotationPresent(Around.class) || a.annotationType().equals(Around.class);
    }

    private Map<Object, Set<Consumer<BeanWrap>>> getBeanHashSubscribers(Object nameOrType) {
        if (nameOrType instanceof String) {
            return this.beanHashSubscribersOfName;
        }
        return this.beanHashSubscribersOfType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beanHashSubscribe(Object nameOrType, Consumer<BeanWrap> callback) {
        if (nameOrType != null) {
            this.SYNC_LOCK.lock();
            try {
                Set tmp = this.getBeanHashSubscribers(nameOrType).computeIfAbsent(nameOrType, k -> new LinkedHashSet());
                tmp.add(callback);
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    protected void beanBaseSubscribe(Consumer<BeanWrap> callback, int index) {
        this.SYNC_LOCK.lock();
        try {
            this.beanBaseSubscribersOfType.add(new RankEntity<Consumer<BeanWrap>>(callback, index));
            if (index < 0) {
                Collections.sort(this.beanBaseSubscribersOfType);
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beanHashPublish(Object nameOrType, BeanWrap wrap) {
        if (wrap.raw() == null) {
            return;
        }
        this.SYNC_LOCK.lock();
        try {
            Set<Consumer<BeanWrap>> tmp = this.getBeanHashSubscribers(nameOrType).get(nameOrType);
            if (tmp != null) {
                for (Consumer<BeanWrap> s1 : tmp) {
                    s1.accept(wrap);
                }
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beanBasePublish(BeanWrap wrap) {
        this.SYNC_LOCK.lock();
        try {
            for (RankEntity<Consumer<BeanWrap>> s1 : this.beanBaseSubscribersOfType) {
                ((Consumer)s1.target).accept(wrap);
            }
        }
        finally {
            this.SYNC_LOCK.unlock();
        }
    }

    public void beanPublish(BeanWrap wrap) {
        this.beanBasePublish(wrap);
    }

    @Deprecated
    public void wrapPublish(BeanWrap wrap) {
        this.beanBasePublish(wrap);
    }

    public void removeWrap(String name) {
        if (Utils.isNotEmpty(name)) {
            this.SYNC_LOCK.lock();
            try {
                BeanWrap bw = this.beanWrapsOfName.remove(name);
                if (bw != null) {
                    this.beanWrapSet.remove(bw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void removeWrap(Class<?> type) {
        if (type != null) {
            this.SYNC_LOCK.lock();
            try {
                BeanWrap bw = this.beanWrapsOfType.remove(type);
                if (bw != null) {
                    this.beanWrapSet.remove(bw);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void putWrap(String name, BeanWrap wrap) {
        if (Utils.isNotEmpty(name) && wrap.raw() != null) {
            this.SYNC_LOCK.lock();
            try {
                if (!this.beanWrapsOfName.containsKey(name)) {
                    this.beanWrapsOfName.put(name, wrap);
                    this.beanWrapSet.add(wrap);
                    this.beanHashPublish(name, wrap);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public void putWrap(Class<?> type, BeanWrap wrap) {
        if (type != null && wrap.raw() != null) {
            this.SYNC_LOCK.lock();
            try {
                if (!this.beanWrapsOfType.containsKey(type)) {
                    this.beanWrapsOfType.put(type, wrap);
                    this.beanWrapSet.add(wrap);
                    this.beanHashPublish(type, wrap);
                }
            }
            finally {
                this.SYNC_LOCK.unlock();
            }
        }
    }

    public boolean hasWrap(Object nameOrType) {
        return this.getWrap(nameOrType) != null;
    }

    public BeanWrap getWrap(Object nameOrType) {
        if (nameOrType instanceof String) {
            return this.beanWrapsOfName.get(nameOrType);
        }
        return this.beanWrapsOfType.get(nameOrType);
    }

    public List<BeanWrap> getWrapsOfType(Class<?> baseType) {
        return this.beanFind((BeanWrap bw) -> baseType.isAssignableFrom(bw.rawClz()));
    }

    public void getWrapAsync(Object nameOrType, Consumer<BeanWrap> callback) {
        BeanWrap bw = this.getWrap(nameOrType);
        if (bw == null || bw.raw() == null) {
            this.beanHashSubscribe(nameOrType, callback);
        } else {
            callback.accept(bw);
        }
    }

    public void subWrapsOfType(Class<?> baseType, Consumer<BeanWrap> callback) {
        this.subWrapsOfType(baseType, callback, 0);
    }

    public void subWrapsOfType(Class<?> baseType, Consumer<BeanWrap> callback, int index) {
        this.subWrapsOfType(baseType, null, callback, index);
    }

    public void subWrapsOfType(Class<?> baseType, ParameterizedType genericType, Consumer<BeanWrap> callback) {
        this.subWrapsOfType(baseType, genericType, callback, 0);
    }

    public void subWrapsOfType(Class<?> baseType, ParameterizedType genericType, Consumer<BeanWrap> callback, int index) {
        this.beanForeach((BeanWrap bw) -> {
            if (baseType.isAssignableFrom(bw.rawClz()) && bw.isNullOrGenericFrom(genericType)) {
                callback.accept((BeanWrap)bw);
            }
        });
        this.beanBaseSubscribe(bw -> {
            if (baseType.isAssignableFrom(bw.rawClz()) && bw.isNullOrGenericFrom(genericType)) {
                callback.accept((BeanWrap)bw);
            }
        }, index);
    }

    public <T> T getBean(String name) {
        BeanWrap bw = this.getWrap(name);
        return bw == null ? null : (T)bw.get();
    }

    public <T> T getBean(Class<T> type) {
        BeanWrap bw = this.getWrap(type);
        return bw == null ? null : (T)bw.get();
    }

    public <T> T getBeanOrDefault(Object nameOrType, T def) {
        BeanWrap bw = this.getWrap(nameOrType);
        return bw == null ? def : bw.get();
    }

    public <T> List<T> getBeansOfType(Class<T> baseType) {
        return this.getBeansOfType(baseType, null);
    }

    public <T> List<T> getBeansOfType(Class<T> baseType, ParameterizedType genericType) {
        List<BeanWrap> beanWraps = this.beanFind((BeanWrap bw) -> baseType.isAssignableFrom(bw.rawClz()) && bw.isNullOrGenericFrom(genericType));
        ArrayList beans = new ArrayList();
        for (BeanWrap bw2 : beanWraps) {
            beans.add(bw2.get());
        }
        return beans;
    }

    public <T> Map<String, T> getBeansMapOfType(Class<T> baseType) {
        return this.getBeansMapOfType(baseType, null);
    }

    public <T> Map<String, T> getBeansMapOfType(Class<T> baseType, ParameterizedType genericType) {
        HashMap beanMap = new HashMap();
        this.beanForeach((BeanWrap bw) -> {
            if (baseType.isAssignableFrom(bw.rawClz()) && bw.isNullOrGenericFrom(genericType) && Utils.isNotEmpty(bw.name())) {
                beanMap.put(bw.name(), bw.get());
            }
        });
        return beanMap;
    }

    public <T> T getBeanOrNew(Class<T> type) {
        return this.wrapAndPut(type).get();
    }

    public <T> void getBeanAsync(String name, Consumer<T> callback) {
        this.getWrapAsync(name, bw -> callback.accept(bw.get()));
    }

    public <T> void getBeanAsync(Class<T> type, Consumer<T> callback) {
        this.getWrapAsync(type, bw -> callback.accept(bw.get()));
    }

    public <T> void subBeansOfType(Class<T> baseType, Consumer<T> callback) {
        this.subBeansOfType(baseType, null, callback);
    }

    public <T> void subBeansOfType(Class<T> baseType, ParameterizedType genericType, Consumer<T> callback) {
        this.subWrapsOfType(baseType, genericType, bw -> callback.accept(bw.get()));
    }

    public BeanWrap wrap(Class<?> type) {
        return this.wrap(type, null);
    }

    public BeanWrap wrap(Class<?> type, Object bean) {
        return this.wrap(type, bean, false);
    }

    public BeanWrap wrap(Class<?> type, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(type);
        if (wrap == null) {
            wrap = this.wrapCreate(type, bean, null, typed);
        }
        return wrap;
    }

    public BeanWrap wrap(String name, Object bean) {
        return this.wrap(name, bean, false);
    }

    public BeanWrap wrap(String name, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(name);
        if (wrap == null) {
            wrap = this.wrapCreate(bean.getClass(), bean, name, typed);
        }
        return wrap;
    }

    public BeanWrap wrap(String name, Class<?> clz) {
        return this.wrap(name, clz, false);
    }

    public BeanWrap wrap(String name, Class<?> clz, boolean typed) {
        BeanWrap wrap = this.getWrap(name);
        if (wrap == null) {
            wrap = this.wrapCreate(clz, null, name, typed);
        }
        return wrap;
    }

    public BeanWrap wrapAndPut(Class<?> type) {
        return this.wrapAndPut(type, null);
    }

    public BeanWrap wrapAndPut(Class<?> type, Object bean) {
        return this.wrapAndPut(type, bean, false);
    }

    public BeanWrap wrapAndPut(Class<?> type, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(type);
        if (wrap == null) {
            wrap = this.wrapCreate(type, bean, null, typed);
            this.putWrap(type, wrap);
        }
        return wrap;
    }

    public BeanWrap wrapAndPut(String name, Object bean) {
        return this.wrapAndPut(name, bean, false);
    }

    public BeanWrap wrapAndPut(String name, Object bean, boolean typed) {
        BeanWrap wrap = this.getWrap(name);
        if (wrap == null) {
            wrap = this.wrapCreate(bean.getClass(), bean, name, typed);
            this.putWrap(name, wrap);
            if (typed) {
                this.putWrap(bean.getClass(), wrap);
            }
        }
        return wrap;
    }

    protected abstract BeanWrap wrapCreate(Class<?> var1, Object var2, String var3, boolean var4);

    public void beanRegister(BeanWrap bw, String name, boolean typed) {
        if (Utils.isNotEmpty(name)) {
            this.putWrap(name, bw);
            if (!typed) {
                this.beanBindingSupT(bw.rawClz(), bw);
                if (!bw.rawClz().equals(bw.clz())) {
                    this.beanBindingSupT(bw.clz(), bw);
                }
                return;
            }
        }
        this.putWrap(bw.rawClz(), bw);
        this.putWrap(bw.rawClz().getName(), bw);
        this.beanRegisterSupI(bw.rawClz(), bw);
        if (!bw.rawClz().equals(bw.clz())) {
            this.putWrap(bw.clz(), bw);
            this.putWrap(bw.clz().getName(), bw);
            this.beanRegisterSupI(bw.clz(), bw);
        }
    }

    protected void beanRegisterSupI(Class<?> clz, BeanWrap bw) {
        Type[] list2;
        Class<?>[] list;
        for (Class<?> c : list = clz.getInterfaces()) {
            if (c.getName().startsWith("java.")) continue;
            this.putWrap(c, bw);
        }
        for (Type t : list2 = clz.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            this.putWrap(t.getTypeName(), bw);
            bw.genericList().add((ParameterizedType)t);
        }
    }

    protected void beanBindingSupT(Class<?> clz, BeanWrap bw) {
        Type[] list2;
        for (Type t : list2 = clz.getGenericInterfaces()) {
            if (!(t instanceof ParameterizedType)) continue;
            bw.genericList().add((ParameterizedType)t);
        }
    }

    public void beanInject(VarHolder vh, String name) {
        this.beanInject(vh, name, false, false);
    }

    protected void beanInject(VarHolder vh, String name, boolean required, boolean autoRefreshed) {
        try {
            vh.required(required);
            this.beanInjectDo(vh, name, required, autoRefreshed);
        }
        catch (InjectionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new InjectionException("Injection failed: " + vh.getFullName(), e);
        }
    }

    private void beanInjectDo(VarHolder vh, String name, boolean required, boolean autoRefreshed) {
        if (Utils.isEmpty(name)) {
            if (vh.getType() == null) {
                if (required) {
                    throw new InjectionException("Unrecognized type\uff0cinjection failed: " + vh.getFullName());
                }
                return;
            }
            if (AppContext.class.isAssignableFrom(vh.getType())) {
                vh.setValue(this);
                return;
            }
            if (SolonApp.class.isAssignableFrom(vh.getType())) {
                vh.setValue(this.app());
                return;
            }
            if (vh.getGenericType() != null) {
                this.getWrapAsync(vh.getGenericType().getTypeName(), bw -> vh.setValue(bw.get()));
            } else {
                this.getWrapAsync(vh.getType(), bw -> vh.setValue(bw.get()));
            }
        } else if (name.startsWith("${classpath:")) {
            String url = name.substring(12, name.length() - 1);
            Properties val2 = Utils.loadProperties(ResourceUtil.getResource(this.getClassLoader(), url));
            if (val2 == null) {
                if (required) {
                    throw new IllegalStateException(name + "  failed to load!");
                }
            } else if (Properties.class == vh.getType()) {
                vh.setValue(val2);
            } else if (Map.class == vh.getType()) {
                HashMap val22 = new HashMap();
                val2.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                    if (k instanceof String && v instanceof String) {
                        val22.put((String)k, (String)v);
                    }
                }));
                vh.setValue(val22);
            } else {
                Object val23 = PropsConverter.global().convert(val2, null, vh.getType(), vh.getGenericType());
                vh.setValue(val23);
                this.aot().registerEntityType(vh.getType(), vh.getGenericType());
            }
        } else if (name.startsWith("${")) {
            String name2 = this.findConfigKey(name);
            this.beanInjectConfig(vh, name2, required);
            if (autoRefreshed && vh.isField()) {
                int defIdx = name2.indexOf(":");
                if (defIdx > 0) {
                    name2 = name2.substring(0, defIdx).trim();
                }
                String name3 = name2;
                this.cfg().onChange((key, val) -> {
                    if (key.startsWith(name3)) {
                        this.beanInjectConfig(vh, name3, required);
                    }
                });
            }
        } else {
            this.getWrapAsync(name, bw -> {
                if (BeanWrap.class.isAssignableFrom(vh.getType())) {
                    vh.setValue(bw);
                } else {
                    vh.setValue(bw.get());
                }
            });
        }
    }

    protected void beanFillProperties(Object obj, Inject typeInj) {
        if (typeInj != null && Utils.isNotEmpty(typeInj.value())) {
            String name = typeInj.value();
            if (name.startsWith("${classpath:")) {
                String url = name.substring(12, name.length() - 1);
                Properties val2 = Utils.loadProperties(ResourceUtil.getResource(this.getClassLoader(), url));
                if (val2 == null) {
                    if (typeInj.required()) {
                        throw new IllegalStateException(name + "  failed to load!");
                    }
                } else {
                    Utils.injectProperties(obj, val2);
                }
            } else if (typeInj.value().startsWith("${")) {
                String name2 = this.findConfigKey(name);
                this.beanFillPropertiesDo(name, obj, this.cfg().getProp(name2), typeInj.required());
                if (typeInj.autoRefreshed()) {
                    this.cfg().onChange((key, val) -> {
                        if (key.startsWith(name2)) {
                            this.beanFillPropertiesDo(name, obj, this.cfg().getProp(name2), typeInj.required());
                        }
                    });
                }
            }
        }
    }

    private void beanFillPropertiesDo(String name, Object obj, Properties val, boolean required) {
        if (required && val.size() == 0) {
            throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + obj.getClass().getName());
        }
        Utils.injectProperties(obj, val);
    }

    protected String findConfigKey(String name) {
        String name2 = name.substring(2, name.length() - 1).trim();
        int index = name2.indexOf(58);
        if (index > 0) {
            String rawName = name2.substring(0, index);
            String nextName = name2.substring(index + 1);
            if (nextName.startsWith("${") && !this.cfg().containsKey(rawName)) {
                return this.findConfigKey(nextName);
            }
        }
        return name2;
    }

    private void beanInjectConfig(VarHolder vh, String name, boolean required) {
        if (Properties.class == vh.getType() || Props.class == vh.getType()) {
            Props val = this.cfg().getProp(name);
            if (required && val.size() == 0) {
                throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + vh.getFullName());
            }
            vh.setValue(val);
        } else {
            String val = this.cfg().getByExpr(name);
            if (val == null) {
                val = System.getenv(name);
            }
            if (val == null) {
                Class<?> pt = vh.getType();
                if (pt.getName().startsWith("java.lang.") || pt.isPrimitive()) {
                    if (required) {
                        throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + vh.getFullName());
                    }
                    vh.setValue(null);
                } else {
                    Props val0 = this.cfg().getProp(name);
                    if (((Properties)val0).size() > 0) {
                        Object val2 = PropsConverter.global().convert(val0, null, pt, vh.getGenericType());
                        vh.setValue(val2);
                        this.aot().registerEntityType(vh.getType(), vh.getGenericType());
                    } else {
                        if (required) {
                            throw new InjectionException("Missing required property: '" + name + "', config injection failed: " + vh.getFullName());
                        }
                        vh.setValue(null);
                    }
                }
            } else {
                Object val2 = ConvertUtil.to(vh.getType(), vh.getGenericType(), val);
                vh.setValue(val2);
                this.aot().registerEntityType(vh.getType(), vh.getGenericType());
            }
        }
    }

    public abstract void lifecycle(Lifecycle var1);

    public abstract void lifecycle(int var1, Lifecycle var2);

    public abstract void lifecycle(int var1, int var2, Lifecycle var3);

    public void beanForeach(BiConsumer<String, BeanWrap> action) {
        this.beanWrapsOfName.forEach(action);
    }

    public void beanForeach(Consumer<BeanWrap> action) {
        Object[] array;
        for (Object bw : array = this.beanWrapSet.toArray()) {
            action.accept((BeanWrap)bw);
        }
    }

    public List<BeanWrap> beanFind(BiPredicate<String, BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((String k, BeanWrap v) -> {
            if (condition.test((String)k, (BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        if (list.size() > 0) {
            list.sort(Comparator.comparingInt(bw -> bw.index()));
        }
        return list;
    }

    public List<BeanWrap> beanFind(Predicate<BeanWrap> condition) {
        ArrayList<BeanWrap> list = new ArrayList<BeanWrap>();
        this.beanForeach((BeanWrap v) -> {
            if (condition.test((BeanWrap)v)) {
                list.add((BeanWrap)v);
            }
        });
        if (list.size() > 0) {
            list.sort(Comparator.comparingInt(bw -> bw.index()));
        }
        return list;
    }

    protected void beanStop0() {
        for (BeanWrap bw : this.beanWrapSet) {
            if (!(bw.raw() instanceof Closeable)) continue;
            try {
                ((Closeable)bw.raw()).close();
            }
            catch (Throwable throwable) {}
        }
    }
}

