/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core;

import java.util.function.BiFunction;
import org.noear.solon.core.LoadBalance;
import org.noear.solon.core.MvcFactory;
import org.noear.solon.core.util.ClassUtil;

public final class FactoryManager {
    private static final FactoryManager global = new FactoryManager();
    private BiFunction<Class<?>, Boolean, ThreadLocal> threadLocalFactory = (applyFor, inheritance0) -> {
        if (inheritance0.booleanValue()) {
            return new InheritableThreadLocal();
        }
        return new ThreadLocal();
    };
    protected LoadBalance.Factory loadBalanceFactory = (g, s) -> null;
    private MvcFactory mvcFactory = (MvcFactory)ClassUtil.tryInstance("org.noear.solon.core.mvc.MvcFactoryDefault");

    public static FactoryManager getGlobal() {
        return global;
    }

    public <T> void threadLocalFactory(BiFunction<Class<?>, Boolean, ThreadLocal> factory) {
        if (factory != null) {
            this.threadLocalFactory = factory;
        }
    }

    public <T> ThreadLocal<T> newThreadLocal(Class<?> applyFor, boolean inheritance0) {
        return this.threadLocalFactory.apply(applyFor, inheritance0);
    }

    public void loadBalanceFactory(LoadBalance.Factory factory) {
        if (factory != null) {
            this.loadBalanceFactory = factory;
        }
    }

    public LoadBalance newLoadBalance(String group, String service) {
        return this.loadBalanceFactory.create(group, service);
    }

    public boolean hasMvcFactory() {
        return this.mvcFactory != null;
    }

    public MvcFactory mvcFactory() {
        if (this.mvcFactory == null) {
            throw new IllegalStateException("The 'solon-mvc' plugin is missing");
        }
        return this.mvcFactory;
    }

    public void mvcFactory(MvcFactory factory) {
        if (factory != null) {
            this.mvcFactory = factory;
        }
    }
}

