/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PathMatcher {
    private static boolean _caseSensitive = true;
    private static final Map<String, PathMatcher> _cached = new ConcurrentHashMap<String, PathMatcher>();
    private Pattern pattern;
    private Pattern patternNoStart;
    private int depth;

    public static void setCaseSensitive(boolean caseSensitive) {
        _caseSensitive = caseSensitive;
    }

    public static boolean isCaseSensitive() {
        return _caseSensitive;
    }

    public static PathMatcher get(String expr) {
        return PathMatcher.get(expr, true);
    }

    public static PathMatcher get(String expr, boolean addStarts) {
        if (addStarts && !expr.startsWith("/")) {
            expr = "/" + expr;
        }
        return _cached.computeIfAbsent(expr, k -> new PathMatcher((String)k, _caseSensitive));
    }

    public PathMatcher(String expr, boolean caseSensitive) {
        if (caseSensitive) {
            this.pattern = Pattern.compile(PathMatcher.exprCompile(expr, true));
            if (expr.contains("{")) {
                this.patternNoStart = Pattern.compile(PathMatcher.exprCompile(expr, false));
            }
        } else {
            this.pattern = Pattern.compile(PathMatcher.exprCompile(expr, true), 2);
            if (expr.contains("{")) {
                this.patternNoStart = Pattern.compile(PathMatcher.exprCompile(expr, false), 2);
            }
        }
        String[] exprFragments = expr.split("/");
        for (int i = 0; i < exprFragments.length && PathMatcher.depthIndexOf(exprFragments[i]) < 0; ++i) {
            ++this.depth;
        }
    }

    private static int depthIndexOf(String str) {
        for (int j = 0; j < str.length(); ++j) {
            char c = str.charAt(j);
            if (c != '{' && c != '*') continue;
            return j;
        }
        return -1;
    }

    public int depth() {
        return this.depth;
    }

    public Matcher matcher(String uri) {
        if (this.patternNoStart != null) {
            return this.patternNoStart.matcher(uri);
        }
        return this.pattern.matcher(uri);
    }

    public boolean matches(String uri) {
        return this.pattern.matcher(uri).find();
    }

    protected static String exprCompile(String expr, boolean fixedStart) {
        String p = expr;
        p = p.replace(".", "\\.");
        p = p.replace("$", "\\$");
        p = p.replace("**", ".[]");
        if ((p = p.replace("*", "[^/]*")).indexOf("{") >= 0) {
            if (p.indexOf("_}") > 0) {
                p = p.replaceAll("\\{[^\\}]+?\\_\\}", "(.+)");
            }
            p = p.replaceAll("\\{[^\\}]+?\\}", "([^/]+)");
        }
        p = p.replace(".[]", ".*");
        if (fixedStart) {
            return "^" + p + "$";
        }
        return p + "$";
    }
}

