/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water;

import java.util.Timer;
import java.util.TimerTask;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudClient;
import org.noear.solon.cloud.CloudManager;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.annotation.EventLevel;
import org.noear.solon.cloud.extend.water.integration.http.HandlerCheck;
import org.noear.solon.cloud.extend.water.integration.http.HandlerJob;
import org.noear.solon.cloud.extend.water.integration.http.HandlerReceive;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStatus;
import org.noear.solon.cloud.extend.water.integration.http.HandlerStop;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerCacheUpdate;
import org.noear.solon.cloud.extend.water.integration.msg.HandlerConfigUpdate;
import org.noear.solon.cloud.extend.water.service.CloudConfigServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudDiscoveryServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudEventServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudI18nServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudJobServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudListServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudLockServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudLogServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudMetricServiceWaterImpl;
import org.noear.solon.cloud.extend.water.service.CloudTraceServiceWaterImpl;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.model.Instance;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.service.CloudDiscoveryService;
import org.noear.solon.cloud.service.CloudEventServicePlus;
import org.noear.solon.cloud.service.CloudI18nService;
import org.noear.solon.cloud.service.CloudJobService;
import org.noear.solon.cloud.service.CloudListService;
import org.noear.solon.cloud.service.CloudLockService;
import org.noear.solon.cloud.service.CloudLogService;
import org.noear.solon.cloud.service.CloudMetricService;
import org.noear.solon.cloud.service.CloudTraceService;
import org.noear.solon.core.AppContext;
import org.noear.solon.core.Plugin;
import org.noear.solon.core.bean.LifecycleBean;
import org.noear.solon.core.handle.Handler;
import org.noear.water.WaterAddress;
import org.noear.water.WaterClient;
import org.noear.water.WaterSetting;

public class XPluginImp
implements Plugin {
    private Timer clientTimer = new Timer();
    private CloudProps cloudProps;
    private boolean inited = false;

    public XPluginImp() {
        if (!this.initDo(Solon.context())) {
            return;
        }
        CloudTraceServiceWaterImpl traceServiceImp = new CloudTraceServiceWaterImpl();
        WaterClient.localHostSet((String)Instance.local().address());
        WaterClient.localServiceSet((String)Instance.local().service());
        WaterSetting.water_trace_id_supplier(() -> ((CloudTraceServiceWaterImpl)traceServiceImp).getTraceId());
        if (this.cloudProps.getLogEnable()) {
            CloudManager.register((CloudLogService)new CloudLogServiceWaterImpl(this.cloudProps));
        }
        if (this.cloudProps.getTraceEnable()) {
            CloudManager.register((CloudTraceService)traceServiceImp);
        }
    }

    private boolean initDo(AppContext context) {
        String logDefault;
        if (this.cloudProps == null) {
            this.cloudProps = new CloudProps(context, "water");
        }
        if (this.inited) {
            return true;
        }
        if (Utils.isEmpty((String)this.cloudProps.getServer())) {
            return false;
        }
        String server = this.cloudProps.getServer();
        String configServer = this.cloudProps.getConfigServer();
        String discoveryServer = this.cloudProps.getDiscoveryServer();
        String eventServer = this.cloudProps.getEventServer();
        String logServer = this.cloudProps.getLogServer();
        CloudProps.LOG_DEFAULT_LOGGER = logDefault = this.cloudProps.getLogDefault();
        System.setProperty("water.host", server);
        if (Utils.isNotEmpty((String)logDefault)) {
            System.setProperty("water.logger", logDefault);
        }
        if (!server.equals(configServer)) {
            WaterAddress.setCfgApiUrl((String)configServer);
        }
        if (!server.equals(discoveryServer)) {
            WaterAddress.setRegApiUrl((String)discoveryServer);
        }
        if (!server.equals(eventServer)) {
            WaterAddress.setMsgApiUrl((String)eventServer);
        }
        if (!server.equals(logServer)) {
            WaterAddress.setLogApiUrl((String)logServer);
        }
        this.inited = true;
        return true;
    }

    public void start(AppContext context) throws Throwable {
        long interval;
        if (!this.initDo(context)) {
            return;
        }
        CloudDiscoveryServiceWaterImpl discoveryServiceImp = null;
        CloudConfigServiceWaterImpl configServiceImp = null;
        CloudEventServiceWaterImpl eventServiceImp = new CloudEventServiceWaterImpl(this.cloudProps);
        CloudI18nServiceWaterImpl i18nServiceImp = null;
        if (this.cloudProps.getMetricEnable()) {
            CloudManager.register((CloudMetricService)new CloudMetricServiceWaterImpl());
        }
        if (this.cloudProps.getConfigEnable()) {
            configServiceImp = new CloudConfigServiceWaterImpl(this.cloudProps);
            CloudManager.register((CloudConfigService)configServiceImp);
            if (Solon.cfg().isFilesMode() && configServiceImp.getRefreshInterval() > 0L) {
                interval = configServiceImp.getRefreshInterval();
                this.clientTimer.schedule((TimerTask)configServiceImp, interval, interval);
            }
            CloudClient.configLoad((String)this.cloudProps.getConfigLoad());
        }
        if (this.cloudProps.getI18nEnable()) {
            i18nServiceImp = new CloudI18nServiceWaterImpl(this.cloudProps);
            CloudManager.register((CloudI18nService)i18nServiceImp);
        }
        if (this.cloudProps.getDiscoveryEnable()) {
            discoveryServiceImp = new CloudDiscoveryServiceWaterImpl(this.cloudProps);
            CloudManager.register((CloudDiscoveryService)discoveryServiceImp);
            if (Solon.cfg().isFilesMode() && discoveryServiceImp.getRefreshInterval() > 0L) {
                interval = discoveryServiceImp.getRefreshInterval();
                this.clientTimer.schedule((TimerTask)discoveryServiceImp, interval, interval);
            }
        }
        if (this.cloudProps.getEventEnable()) {
            String receive = this.getEventReceive();
            if (receive != null && receive.startsWith("@") && CloudClient.config() != null) {
                Config cfg = CloudClient.config().pull(Solon.cfg().appGroup(), receive.substring(1));
                if (cfg == null || Utils.isEmpty((String)cfg.value())) {
                    throw new IllegalArgumentException("Configuration " + receive + " does not exist");
                }
                this.setEventReceive(cfg.value());
            }
            CloudManager.register((CloudEventServicePlus)eventServiceImp);
            if (discoveryServiceImp != null || i18nServiceImp != null) {
                eventServiceImp.attention(EventLevel.instance, "", "", "water.cache.update", "", 0, new HandlerCacheUpdate(discoveryServiceImp, i18nServiceImp));
            }
            if (configServiceImp != null) {
                eventServiceImp.attention(EventLevel.instance, "", "", "water.config.update", "", 0, new HandlerConfigUpdate(configServiceImp));
            }
            context.lifecycle(-94, (LifecycleBean)eventServiceImp);
        }
        if (this.cloudProps.getLockEnable()) {
            CloudManager.register((CloudLockService)new CloudLockServiceWaterImpl());
        }
        if (this.cloudProps.getListEnable()) {
            CloudManager.register((CloudListService)new CloudListServiceWaterImpl());
        }
        if (this.cloudProps.getJobEnable()) {
            CloudManager.register((CloudJobService)CloudJobServiceWaterImpl.instance);
            context.lifecycle(-94, (LifecycleBean)CloudJobServiceWaterImpl.instance);
        }
        if (this.cloudProps.getJobEnable()) {
            Solon.app().http("/_run/job/", (Handler)new HandlerJob());
        }
        Solon.app().http("/_run/check/", (Handler)new HandlerCheck());
        Solon.app().http("/_run/status/", (Handler)new HandlerStatus());
        Solon.app().http("/_run/stop/", (Handler)new HandlerStop());
        Solon.app().http("/_run/msg", (Handler)new HandlerReceive(eventServiceImp));
    }

    public void prestop() throws Throwable {
        if (this.clientTimer != null) {
            this.clientTimer.cancel();
        }
    }

    public String getEventReceive() {
        return this.cloudProps.getValue("event.receive");
    }

    public void setEventReceive(String value) {
        this.cloudProps.setValue("event.receive", value);
    }
}

