/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.cloud.extend.water.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.function.Consumer;
import org.noear.solon.Solon;
import org.noear.solon.Utils;
import org.noear.solon.cloud.CloudConfigHandler;
import org.noear.solon.cloud.CloudProps;
import org.noear.solon.cloud.model.Config;
import org.noear.solon.cloud.service.CloudConfigObserverEntity;
import org.noear.solon.cloud.service.CloudConfigService;
import org.noear.solon.cloud.utils.IntervalUtils;
import org.noear.water.WaterClient;
import org.noear.water.model.ConfigM;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudConfigServiceWaterImpl
extends TimerTask
implements CloudConfigService {
    static final Logger log = LoggerFactory.getLogger(CloudConfigServiceWaterImpl.class);
    private final String DEFAULT_GROUP = "DEFAULT_GROUP";
    private long refreshInterval;
    private Map<String, Config> configMap = new HashMap<String, Config>();
    private List<CloudConfigObserverEntity> observerList = new ArrayList<CloudConfigObserverEntity>();

    public CloudConfigServiceWaterImpl(CloudProps cloudProps) {
        this.refreshInterval = IntervalUtils.getInterval((String)cloudProps.getConfigRefreshInterval("5s"));
    }

    public long getRefreshInterval() {
        return this.refreshInterval;
    }

    @Override
    public void run() {
        try {
            this.run0();
        }
        catch (Throwable e) {
            log.warn(e.getMessage(), e);
        }
    }

    private void run0() {
        if (Solon.cfg().isFilesMode()) {
            LinkedHashSet<String> loadGroups = new LinkedHashSet<String>();
            try {
                for (CloudConfigObserverEntity entity : this.observerList) {
                    if (!loadGroups.contains(entity.group)) {
                        loadGroups.add(entity.group);
                        WaterClient.Config.reload(entity.group);
                    }
                    ConfigM cfg = WaterClient.Config.get(entity.group, entity.key);
                    this.onUpdateDo(entity.group, entity.key, cfg, cfg2 -> entity.handle(cfg2));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public Config pull(String group, String key) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        ConfigM cfg = WaterClient.Config.get(group, key);
        String cfgKey = group + "/" + key;
        Config config = this.configMap.get(cfgKey);
        if (config == null) {
            config = new Config(group, key, cfg.value, cfg.lastModified);
            this.configMap.put(cfgKey, config);
        } else if (cfg.lastModified > config.version()) {
            config.updateValue(cfg.value, cfg.lastModified);
        }
        return config;
    }

    public boolean push(String group, String key, String value) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        try {
            WaterClient.Config.set(group, key, value);
            return true;
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean remove(String group, String key) {
        return false;
    }

    public void attention(String group, String key, CloudConfigHandler observer) {
        if (Utils.isEmpty((String)group) && Utils.isEmpty((String)(group = Solon.cfg().appGroup()))) {
            group = "DEFAULT_GROUP";
        }
        CloudConfigObserverEntity entity = new CloudConfigObserverEntity(group, key, observer);
        this.observerList.add(entity);
    }

    public void onUpdate(String group, String key) {
        if (Utils.isEmpty((String)group)) {
            return;
        }
        WaterClient.Config.reload(group);
        ConfigM cfg = WaterClient.Config.get(group, key);
        this.onUpdateDo(group, key, cfg, cfg2 -> {
            for (CloudConfigObserverEntity entity : this.observerList) {
                if (!group.equals(entity.group) || !key.equals(entity.key)) continue;
                entity.handle(cfg2);
            }
        });
    }

    private void onUpdateDo(String group, String key, ConfigM cfg, Consumer<Config> consumer) {
        String cfgKey = group + "/" + key;
        Config config = this.configMap.get(cfgKey);
        if (config == null) {
            config = new Config(group, key, cfg.value, cfg.lastModified);
        } else if (config.version() < cfg.lastModified) {
            config.updateValue(cfg.value, cfg.lastModified);
        } else {
            return;
        }
        consumer.accept(config);
    }
}

