/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.model;

import java.util.HashMap;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.noear.snack.ONode;
import org.noear.water.model.ConfigM;
import org.noear.water.model.PropertiesM;

public class ConfigSetM {
    private String _tag = null;
    private ConfigM _empty = new ConfigM();
    private HashMap<String, ConfigM> _map = new HashMap();
    private Properties _propSet;

    public ConfigSetM(String tag) {
        this._tag = tag;
    }

    public ConfigM get(String key) {
        return this._map.getOrDefault(key, this._empty);
    }

    public boolean has(String key) {
        return this._map.containsKey(key);
    }

    public void set(String key, String value) {
        this._map.put(key, new ConfigM(key, value, 0L));
    }

    public void forEach(BiConsumer<String, ConfigM> action) {
        this._map.forEach(action);
    }

    public void load(ONode node) {
        int code = node.get("code").getInt();
        if (code == 1 || code == 200) {
            node.get("data").forEach((k, v) -> {
                ConfigM val = new ConfigM(v.get("key").getString(), v.get("value").getString(), v.get("lastModified").getLong());
                this._map.put((String)k, val);
            });
        } else {
            System.err.println(node.toJson());
        }
    }

    public Properties getPropSet() {
        if (this._propSet == null) {
            this._propSet = new Properties();
            this._map.forEach((? super K k, ? super V v) -> {
                if (v.value != null) {
                    String keyTmp = null;
                    keyTmp = k.startsWith("@") ? k.substring(1) : this._tag + "." + k;
                    String key = keyTmp;
                    this.putTo(key, (ConfigM)v, this._propSet);
                }
            });
        }
        return this._propSet;
    }

    public void sync() {
        this._map.forEach((? super K k, ? super V v) -> {
            if (v != null && k.startsWith("@@")) {
                String key = k.substring(2);
                this.putTo(key, (ConfigM)v, System.getProperties());
            }
        });
    }

    private void putTo(String key, ConfigM val, Properties target) {
        if (val.value.indexOf("=") < 0) {
            target.setProperty(key, val.value);
        } else {
            PropertiesM prop = val.getProp();
            prop.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k1, v1) -> {
                if (v1 != null) {
                    String v2 = v1.toString();
                    if (v2.startsWith("${") && v2.endsWith("}")) {
                        v2 = prop.getProperty(v2.substring(2, v2.length() - 1));
                    }
                    target.setProperty(key + "." + k1, v2);
                }
            }));
        }
    }
}

