/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.track;

import java.util.Map;
import org.noear.redisx.RedisClient;
import org.noear.water.track.TrackEvent;
import org.noear.water.track.TrackEventBuffer;
import org.noear.water.track.TrackUtils;

public class TrackBuffer
extends TrackEventBuffer {
    private static final TrackBuffer singleton = new TrackBuffer();
    private RedisClient _redisX;

    public static TrackBuffer singleton() {
        return singleton;
    }

    private TrackBuffer() {
    }

    public void bind(RedisClient redisX) {
        this._redisX = redisX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush(Map<String, TrackEvent> mainSet, Map<String, TrackEvent> serviceSet, Map<String, TrackEvent> fromSet) throws Throwable {
        if (this._redisX == null) {
            return;
        }
        TrackBuffer trackBuffer = this;
        synchronized (trackBuffer) {
            if (this._redisX != null) {
                this._redisX.open(ru -> {
                    try {
                        for (Map.Entry kv : mainSet.entrySet()) {
                            TrackUtils.trackAll(ru, (String)kv.getKey(), (TrackEvent)kv.getValue());
                        }
                        for (Map.Entry kv : serviceSet.entrySet()) {
                            TrackUtils.trackAll(ru, (String)kv.getKey(), (TrackEvent)kv.getValue());
                        }
                        for (Map.Entry kv : fromSet.entrySet()) {
                            TrackUtils.trackAll(ru, (String)kv.getKey(), (TrackEvent)kv.getValue());
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                });
            }
            mainSet.clear();
            serviceSet.clear();
            fromSet.clear();
        }
    }
}

