/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.util.Properties;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.cache.LocalCache;
import org.noear.wood.cache.SecondCache;
import org.noear.wood.cache.memcached.MemCache;
import org.noear.wood.cache.redis.RedisCache;

public final class CacheUtils {
    public static ICacheServiceEx getCh2(Properties prop, String keyHeader, int defSeconds) {
        LocalCache cache1 = new LocalCache(defSeconds);
        ICacheServiceEx cache2 = CacheUtils.getCh(prop, keyHeader, defSeconds);
        return new SecondCache((ICacheServiceEx)cache1, cache2);
    }

    public static ICacheServiceEx getCh(Properties prop, String keyHeader, int defSeconds) {
        String driverType = prop.getProperty("driverType");
        if ("local".equals(driverType)) {
            return new LocalCache();
        }
        if ("redis".equals(driverType)) {
            return new RedisCache(prop, keyHeader, defSeconds);
        }
        return new MemCache(prop, keyHeader, defSeconds);
    }

    public static ICacheServiceEx getCh(Properties prop) {
        String driverType = prop.getProperty("driverType");
        if ("local".equals(driverType)) {
            return new LocalCache();
        }
        if ("redis".equals(prop.getProperty("driverType"))) {
            return new RedisCache(prop);
        }
        return new MemCache(prop);
    }
}

