/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;

public class ConvertUtil {
    private static final SimpleDateFormat DATE_DEF_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public static Object to(Class<?> type, String val) throws ClassCastException {
        if (String.class == type) {
            return val;
        }
        if (val.length() == 0) {
            return null;
        }
        Object rst = ConvertUtil.tryTo(type, val);
        if (rst != null) {
            return rst;
        }
        if (Date.class == type) {
            try {
                return DATE_DEF_FORMAT.parse(val);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Throwable ex) {
                throw new RuntimeException(ex);
            }
        }
        throw new ClassCastException("\u4e0d\u652f\u6301\u7c7b\u578b:" + type.getName());
    }

    public static Object tryTo(Class<?> type, String val) {
        if (Short.class == type || type == Short.TYPE) {
            return Short.parseShort(val);
        }
        if (Integer.class == type || type == Integer.TYPE) {
            return Integer.parseInt(val);
        }
        if (Long.class == type || type == Long.TYPE) {
            return Long.parseLong(val);
        }
        if (Double.class == type || type == Double.TYPE) {
            return Double.parseDouble(val);
        }
        if (Float.class == type || type == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(val));
        }
        if (Boolean.class == type || type == Boolean.TYPE) {
            return Boolean.parseBoolean(val);
        }
        if (LocalDate.class == type) {
            return LocalDate.parse(val);
        }
        if (LocalTime.class == type) {
            return LocalTime.parse(val);
        }
        if (LocalDateTime.class == type) {
            return LocalDateTime.parse(val);
        }
        if (BigDecimal.class == type) {
            return new BigDecimal(val);
        }
        if (BigInteger.class == type) {
            return new BigInteger(val);
        }
        if (type.isEnum()) {
            return Enum.valueOf(type, val);
        }
        return null;
    }

    private static boolean is(Class<?> s, Class<?> t) {
        return s.isAssignableFrom(t);
    }
}

