/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class Datetime
implements Serializable,
Cloneable,
Comparable<Datetime> {
    private Date _datetime;
    private Calendar _calendar = null;

    public Datetime() {
        this.setFulltime(new Date());
    }

    public Datetime(Date date) {
        this.setFulltime(date);
    }

    public Datetime(long milliseconds) {
        this.setFulltime(new Date(milliseconds));
    }

    public Datetime setFulltime(Date date) {
        this._datetime = date;
        this._calendar = Calendar.getInstance();
        this._calendar.setTime(date);
        return this;
    }

    public Date getFulltime() {
        return this._datetime;
    }

    public static Datetime Now() {
        return new Datetime(new Date());
    }

    public Datetime addYear(int year) {
        return this.doAdd(1, year);
    }

    public Datetime addMonth(int month) {
        return this.doAdd(2, month);
    }

    public Datetime addDay(int day) {
        return this.doAdd(5, day);
    }

    public Datetime addHour(int hour) {
        return this.doAdd(11, hour);
    }

    public Datetime addMinute(int minute) {
        return this.doAdd(12, minute);
    }

    public Datetime addSecond(int second) {
        return this.doAdd(13, second);
    }

    public Datetime addMillisecond(int millisecond) {
        return this.doAdd(14, millisecond);
    }

    private Datetime doAdd(int field, int value) {
        this._calendar.add(field, value);
        this._datetime = this._calendar.getTime();
        return this;
    }

    public Datetime setYear(int year) {
        return this.doSet(1, year);
    }

    public Datetime setMonth(int month) {
        return this.doSet(2, month);
    }

    public Datetime setDay(int day) {
        return this.doSet(5, day);
    }

    public Datetime setHour(int hour) {
        return this.doSet(11, hour);
    }

    public Datetime setMinute(int minute) {
        return this.doSet(12, minute);
    }

    public Datetime setSecond(int second) {
        return this.doSet(13, second);
    }

    public Datetime setMillisecond(int millisecond) {
        return this.doSet(14, millisecond);
    }

    private Datetime doSet(int field, int value) {
        this._calendar.set(field, value);
        this._datetime = this._calendar.getTime();
        return this;
    }

    public int getYear() {
        return this._calendar.get(1);
    }

    public int getMonth() {
        return this._calendar.get(2);
    }

    public int getDays() {
        return this._calendar.get(5);
    }

    public int getHours() {
        return this._calendar.get(11);
    }

    public int getMinutes() {
        return this._calendar.get(12);
    }

    public int getSeconds() {
        return this._calendar.get(13);
    }

    public long getMilliseconds() {
        return this._calendar.get(14);
    }

    public long getAllDays() {
        return this.getAllHours() / 24L;
    }

    public long getAllHours() {
        return this.getAllMinutes() / 60L;
    }

    public long getAllMinutes() {
        return this.getAllSeconds() / 60L;
    }

    public long getAllSeconds() {
        return this.getTicks() / 1000L;
    }

    public long getAllMilliseconds() {
        return this.getTicks();
    }

    public long getTicks() {
        return this._datetime.getTime();
    }

    public int getDate() {
        return Integer.parseInt(this.toString("yyyyMMdd"));
    }

    public String toString() {
        return this.toString("yyyy-MM-dd HH:mm:ss");
    }

    public String toGmtString() {
        return this.toString("EEE, dd MMM yyyy HH:mm:ss 'GMT'", Locale.US, TimeZone.getTimeZone("GMT"));
    }

    public String toString(String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        return df.format(this._datetime);
    }

    public String toString(String format, Locale locale, TimeZone timeZone) {
        SimpleDateFormat df = null;
        df = locale == null ? new SimpleDateFormat(format) : new SimpleDateFormat(format, locale);
        if (timeZone != null) {
            df.setTimeZone(timeZone);
        }
        return df.format(this._datetime);
    }

    public static String format(Date date, String format) {
        return new Datetime(date).toString(format);
    }

    public static Datetime parse(String datetime, String format) throws ParseException {
        SimpleDateFormat df = new SimpleDateFormat(format);
        Date date = df.parse(datetime);
        return new Datetime(date);
    }

    public static Datetime parseEx(String datetime, List<String> formats) throws Exception {
        String f;
        Date date = null;
        Iterator<String> iterator = formats.iterator();
        while (iterator.hasNext() && (date = Datetime.do_parse(datetime, f = iterator.next())) == null) {
        }
        if (date == null) {
            throw new Exception("Unparseable date: \"" + datetime + "\"");
        }
        return new Datetime(date);
    }

    private static Date do_parse(String source, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        ParsePosition pos = new ParsePosition(0);
        Date result = ((DateFormat)df).parse(source, pos);
        if (pos.getIndex() == 0) {
            return null;
        }
        return result;
    }

    public static Datetime tryParse(String datetime, String format) {
        SimpleDateFormat df = new SimpleDateFormat(format);
        try {
            Date date = df.parse(datetime);
            return new Datetime(date);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public int compareTo(Datetime anotherDatetime) {
        long anotherTime;
        long thisTime = this.getTicks();
        return thisTime < (anotherTime = anotherDatetime.getTicks()) ? -1 : (thisTime == anotherTime ? 0 : 1);
    }
}

