/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.noear.water.utils.TaskUtils;

public abstract class EventPipeline<Event>
implements TaskUtils.ITask {
    private long interval = 500L;
    private long interval_min = 100L;
    private int packetSize = 150;
    private int packetSize_min = 150;
    Queue<Event> queueLocal = new LinkedBlockingQueue<Event>();

    public EventPipeline() {
        TaskUtils.run(this);
    }

    public EventPipeline(long interval, int packetSize) {
        this.setInterval(interval);
        this.setPacketSize(packetSize);
        TaskUtils.run(this);
    }

    protected abstract void handle(List<Event> var1);

    public void add(Event event) {
        try {
            this.queueLocal.add(event);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addAll(Collection<Event> events) {
        try {
            this.queueLocal.addAll(events);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        if (interval >= this.interval_min) {
            this.interval = interval;
        }
    }

    public void setPacketSize(int packetSize) {
        if (packetSize >= this.packetSize_min) {
            this.packetSize = packetSize;
        }
    }

    @Override
    public void exec() throws Exception {
        while (true) {
            ArrayList list = new ArrayList(this.packetSize);
            this.collectDo(list);
            if (list.size() <= 0) break;
            this.handle(list);
        }
    }

    private void collectDo(List<Event> list) {
        Event event;
        int count = 0;
        while ((event = this.queueLocal.poll()) != null) {
            list.add(event);
            if (++count != this.packetSize) continue;
            break;
        }
    }
}

