/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Dispatcher;
import okhttp3.FormBody;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.noear.water.utils.HttpInterceptor;
import org.noear.water.utils.HttpResultException;
import org.noear.water.utils.HttpTimeout;

public class HttpUtils {
    private static final Supplier<Dispatcher> httpClientDispatcher = () -> {
        Dispatcher temp = new Dispatcher();
        temp.setMaxRequests(20000);
        temp.setMaxRequestsPerHost(10000);
        return temp;
    };
    private static final OkHttpClient httpClient = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(60L, TimeUnit.SECONDS).dispatcher(httpClientDispatcher.get()).addInterceptor((Interceptor)HttpInterceptor.instance).build();
    private OkHttpClient _client;
    private String _url;
    private Charset _charset;
    private Map<String, String> _cookies;
    private RequestBody _body;
    private List<KeyValue> _form;
    private boolean _multipart = false;
    private MultipartBody.Builder _part_builer;
    private Request.Builder _builder;
    private Act3Ex<Boolean, Response, Exception> _callback;
    private boolean _callAsync;

    public static HttpUtils http(String url) {
        return new HttpUtils(url, httpClient);
    }

    public static HttpUtils http(String url, OkHttpClient client) {
        return new HttpUtils(url, client);
    }

    public static HttpUtils shortHttp(String url) {
        return new HttpUtils(url, httpClient).asShortHttp();
    }

    public static HttpUtils longHttp(String url) {
        return new HttpUtils(url, httpClient).asLongHttp();
    }

    public HttpUtils(String url, OkHttpClient client) {
        this._client = client == null ? httpClient : client;
        if (!url.contains("://")) {
            throw new IllegalArgumentException("No url scheme 'http' or 'https' found: " + url);
        }
        this._url = url;
        this._builder = new Request.Builder().url(url);
    }

    public HttpUtils asShortHttp() {
        return this.timeout(10, 10, 60);
    }

    public HttpUtils asLongHttp() {
        return this.timeout(30, 300, 300);
    }

    public HttpUtils timeout(int timeoutSeconds) {
        if (timeoutSeconds > 0) {
            this._builder.tag(HttpTimeout.class, (Object)new HttpTimeout(timeoutSeconds));
        }
        return this;
    }

    public HttpUtils timeout(int connectTimeoutSeconds, int writeTimeoutSeconds, int readTimeoutSeconds) {
        if (connectTimeoutSeconds > 0) {
            this._builder.tag(HttpTimeout.class, (Object)new HttpTimeout(connectTimeoutSeconds, writeTimeoutSeconds, readTimeoutSeconds));
        }
        return this;
    }

    public HttpUtils multipart(boolean multipart) {
        this._multipart = multipart;
        return this;
    }

    public HttpUtils userAgent(String ua) {
        this._builder.header("User-Agent", ua);
        return this;
    }

    public HttpUtils charset(String charset) {
        this._charset = Charset.forName(charset);
        return this;
    }

    public HttpUtils headers(Map<String, String> headers) {
        if (headers != null) {
            headers.forEach((k, v) -> this._builder.header(k, v));
        }
        return this;
    }

    public HttpUtils header(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this._builder.header(name, value);
        return this;
    }

    public HttpUtils headerAdd(String name, String value) {
        if (name == null || value == null) {
            return this;
        }
        this._builder.addHeader(name, value);
        return this;
    }

    public HttpUtils data(Map data) {
        if (data != null) {
            this.tryInitForm();
            data.forEach((k, v) -> {
                if (k != null && v != null) {
                    this._form.add(new KeyValue(k.toString(), v.toString()));
                }
            });
        }
        return this;
    }

    public HttpUtils data(String key, String value) {
        if (key == null || value == null) {
            return this;
        }
        this.tryInitForm();
        this._form.add(new KeyValue(key, value));
        return this;
    }

    public HttpUtils data(String key, String filename, InputStream inputStream, String contentType) {
        if (key == null || inputStream == null) {
            return this;
        }
        this.multipart(true);
        this.tryInitPartBuilder(MultipartBody.FORM);
        this._part_builer.addFormDataPart(key, filename, (RequestBody)new StreamBody(contentType, inputStream));
        return this;
    }

    public HttpUtils bodyTxt(String txt) {
        return this.bodyTxt(txt, null);
    }

    public HttpUtils bodyTxt(String txt, String contentType) {
        if (txt == null) {
            return this;
        }
        this._body = contentType == null ? FormBody.create(null, (String)txt) : FormBody.create((MediaType)MediaType.parse((String)contentType), (String)txt);
        return this;
    }

    public HttpUtils bodyJson(String txt) {
        return this.bodyTxt(txt, "application/json");
    }

    public HttpUtils bodyRaw(byte[] bytes) {
        return this.bodyRaw(bytes, null);
    }

    public HttpUtils bodyRaw(byte[] bytes, String contentType) {
        return this.bodyRaw(new ByteArrayInputStream(bytes), contentType);
    }

    public HttpUtils bodyRaw(InputStream raw) {
        return this.bodyRaw(raw, null);
    }

    public HttpUtils bodyRaw(InputStream raw, String contentType) {
        if (raw == null) {
            return this;
        }
        this._body = new StreamBody(contentType, raw);
        return this;
    }

    public HttpUtils cookies(Map cookies) {
        if (cookies != null) {
            this.tryInitCookies();
            cookies.forEach((k, v) -> this._cookies.put(k.toString(), v.toString()));
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execCallback(Response resp, Exception err) {
        try {
            if (this._callback == null) {
                return;
            }
            if (resp != null) {
                this._callback.run(resp.isSuccessful(), resp, err);
            } else {
                this._callback.run(false, null, err);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        finally {
            if (resp != null) {
                resp.close();
            }
        }
    }

    private Response execDo(String mothod) throws IOException {
        if (this._multipart) {
            this.tryInitPartBuilder(MultipartBody.FORM);
            if (this._form != null) {
                this._form.forEach(kv -> this._part_builer.addFormDataPart(kv.key, kv.value));
            }
            try {
                this._body = this._part_builer.build();
            }
            catch (IllegalStateException illegalStateException) {}
        } else if (this._form != null) {
            Object fb = new FormBody.Builder(this._charset);
            this._form.forEach(arg_0 -> HttpUtils.lambda$execDo$5((FormBody.Builder)fb, arg_0));
            this._body = fb.build();
        }
        if (this._cookies != null) {
            this._builder.header("Cookie", HttpUtils.getRequestCookieString(this._cookies));
        }
        switch (mothod.toUpperCase()) {
            case "GET": {
                this._builder.method("GET", null);
                break;
            }
            case "POST": {
                this._builder.method("POST", this._body);
                break;
            }
            case "PUT": {
                this._builder.method("PUT", this._body);
                break;
            }
            case "DELETE": {
                this._builder.method("DELETE", this._body);
                break;
            }
            case "PATCH": {
                this._builder.method("PATCH", this._body);
                break;
            }
            case "HEAD": {
                this._builder.method("HEAD", null);
                break;
            }
            case "OPTIONS": {
                this._builder.method("OPTIONS", null);
                break;
            }
            case "TRACE": {
                this._builder.method("TRACE", null);
                break;
            }
            default: {
                throw new IllegalArgumentException("This method is not supported");
            }
        }
        if (this._callAsync) {
            this._client.newCall(this._builder.build()).enqueue(new Callback(){

                public void onFailure(Call call, IOException e) {
                    e.printStackTrace();
                    HttpUtils.this.execCallback(null, e);
                    call.cancel();
                }

                public void onResponse(Call call, Response response) throws IOException {
                    HttpUtils.this.execCallback(response, null);
                    call.cancel();
                }
            });
            return null;
        }
        Call call = this._client.newCall(this._builder.build());
        return call.execute();
    }

    public Response exec(String mothod) throws IOException {
        try {
            return this.execDo(mothod);
        }
        catch (IOException e) {
            throw new IOException(this._url + ", request failed", e);
        }
    }

    public String execAsBody(String mothod) throws IOException {
        Response tmp = this.exec(mothod);
        int code = tmp.code();
        String text = tmp.body().string();
        if (code >= 200 && code < 400) {
            return text;
        }
        throw new HttpResultException("HTTP Error " + code + ": " + text);
    }

    public int execAsCode(String mothod) throws IOException {
        return this.exec(mothod).code();
    }

    @Deprecated
    public String exec2(String mothod) throws IOException {
        return this.execAsBody(mothod);
    }

    @Deprecated
    public int exec3(String mothod) throws IOException {
        return this.execAsCode(mothod);
    }

    public String get() throws IOException {
        return this.execAsBody("GET");
    }

    public String post() throws IOException {
        return this.execAsBody("POST");
    }

    public void postAsync() throws IOException {
        this.postAsync(null);
    }

    public void postAsync(Act3Ex<Boolean, Response, Exception> callback) throws IOException {
        this._callback = callback;
        this._callAsync = true;
        this.exec("POST");
    }

    public void headAsync(Act3Ex<Boolean, Response, Exception> callback) throws IOException {
        this._callback = callback;
        this._callAsync = true;
        this.exec("HEAD");
    }

    public String put() throws IOException {
        return this.execAsBody("PUT");
    }

    public String patch() throws IOException {
        return this.execAsBody("PATCH");
    }

    public String delete() throws IOException {
        return this.execAsBody("DELETE");
    }

    public int head() throws IOException {
        return this.execAsCode("HEAD");
    }

    private static String getRequestCookieString(Map<String, String> cookies) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> kv : cookies.entrySet()) {
            sb.append(kv.getKey()).append('=').append(kv.getValue());
            if (!first) {
                sb.append("; ");
                continue;
            }
            first = false;
        }
        return sb.toString();
    }

    private void tryInitPartBuilder(MediaType type) {
        if (this._part_builer == null) {
            this._part_builer = new MultipartBody.Builder().setType(type);
        }
    }

    private void tryInitForm() {
        if (this._form == null) {
            this._form = new ArrayList<KeyValue>();
        }
    }

    private void tryInitCookies() {
        if (this._cookies == null) {
            this._cookies = new HashMap<String, String>();
        }
    }

    private static /* synthetic */ void lambda$execDo$5(FormBody.Builder fb, KeyValue kv) {
        fb.add(kv.key, kv.value);
    }

    @FunctionalInterface
    public static interface Act3Ex<T1, T2, T3> {
        public void run(T1 var1, T2 var2, T3 var3) throws Exception;
    }

    public static class KeyValue {
        String key;
        String value;

        public KeyValue(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class StreamBody
    extends RequestBody {
        private MediaType _contentType = null;
        private InputStream _inputStream = null;

        public StreamBody(String contentType, InputStream inputStream) {
            if (contentType != null) {
                this._contentType = MediaType.parse((String)contentType);
            }
            this._inputStream = inputStream;
        }

        public MediaType contentType() {
            return this._contentType;
        }

        public long contentLength() throws IOException {
            return this._inputStream.available();
        }

        public void writeTo(BufferedSink sink) throws IOException {
            Source source = null;
            try {
                source = Okio.source((InputStream)this._inputStream);
                sink.writeAll(source);
            }
            finally {
                Util.closeQuietly((Closeable)source);
            }
        }
    }
}

