/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.noear.snack.ONode;
import org.noear.water.utils.Base64Utils;
import org.noear.water.utils.HttpUtils;

public class JPushUtils {
    private static final String apiUrl = "https://api.jpush.cn/v3/push";
    private final String appKey;
    private final String masterSecret;

    public JPushUtils(String appKey, String masterSecret) {
        this.appKey = appKey;
        this.masterSecret = masterSecret;
    }

    public String push(Collection<String> alias, String text, ONode data) throws IOException {
        String message = data.toJson();
        String author = Base64Utils.encode(this.appKey + ":" + this.masterSecret);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        headers.put("Authorization", "Basic " + author);
        return HttpUtils.shortHttp(apiUrl).headers(headers).bodyTxt(message, "application/json").post();
    }
}

