/*
 * Decompiled with CFR 0.152.
 */
package org.noear.water.utils;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.util.Enumeration;

public class LocalUtils {
    private static String localIp;

    public static String getLocalAddr(int port) {
        return LocalUtils.getLocalIp() + ":" + port;
    }

    public static String getLocalIp() {
        if (localIp == null) {
            InetAddress address = LocalUtils.findFirstNonLoopbackAddress();
            localIp = address.getHostAddress();
        }
        return localIp;
    }

    private static InetAddress findFirstNonLoopbackAddress() {
        InetAddress result = null;
        try {
            int lowest = Integer.MAX_VALUE;
            Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
            while (nics.hasMoreElements()) {
                NetworkInterface ifc = nics.nextElement();
                if (!ifc.isUp()) continue;
                if (ifc.getIndex() < lowest || result == null) {
                    lowest = ifc.getIndex();
                } else if (result != null) continue;
                Enumeration<InetAddress> addrs = ifc.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    InetAddress address = addrs.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    result = address;
                }
            }
        }
        catch (IOException ex) {
            System.err.println("Cannot get first non-loopback address" + ex.getStackTrace());
        }
        if (result != null) {
            return result;
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

