/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.noear.weed.BaseEntityWrap;
import org.noear.weed.BaseMapper;
import org.noear.weed.DataItem;
import org.noear.weed.DbContext;
import org.noear.weed.DbTableQuery;
import org.noear.weed.IPage;
import org.noear.weed.MapperWhereQ;
import org.noear.weed.ext.Act1;
import org.noear.weed.ext.Act2;
import org.noear.weed.impl.IPageImpl;
import org.noear.weed.utils.RunUtils;
import org.noear.weed.utils.StringUtils;
import org.noear.weed.wrap.Property;
import org.noear.weed.wrap.PropertyWrap;

public class BaseMapperWrap<T>
implements BaseMapper<T> {
    private DbContext _db;
    private BaseEntityWrap _table;
    private String _tabelName;
    private Class<?> _entityType;

    protected Class<?> entityType() {
        return this._entityType;
    }

    public BaseMapperWrap(DbContext db, Class<?> entityType, String tableName) {
        this._db = db;
        this._entityType = entityType;
        this._table = BaseEntityWrap.get(this);
        this._tabelName = StringUtils.isEmpty(tableName) ? this._table.tableName : tableName;
    }

    public BaseMapperWrap(DbContext db, BaseMapper<T> baseMapper) {
        this._db = db;
        this._table = BaseEntityWrap.get(baseMapper);
        this._tabelName = this._table.tableName;
    }

    private DbContext db() {
        return this._db;
    }

    private String tableName() {
        return this._tabelName;
    }

    private String pk() {
        return this._table.pkName;
    }

    private Class<?> entityClz() {
        return this._table.entityClz;
    }

    @Override
    public Long insert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr().insert(data));
    }

    @Override
    public void insertList(List<T> list) {
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T d : list) {
            list2.add(new DataItem().setEntityIf(d, (k, v) -> true));
        }
        RunUtils.call(() -> this.getQr().insertList(list2));
    }

    @Override
    public Integer deleteById(Object id) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).delete());
    }

    @Override
    public Integer deleteByIds(Iterable idList) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.pk(), idList)).delete());
    }

    @Override
    public Integer deleteByMap(Map<String, Object> columnMap) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).delete());
    }

    @Override
    public Integer delete(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).delete());
    }

    @Override
    public Integer updateById(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        Object id = data.get(this.pk());
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).update(data));
    }

    @Override
    public Integer update(T entity, boolean excludeNull, Act1<MapperWhereQ> c) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr(c).update(data));
    }

    @Override
    public int[] updateList(List<T> list, Act2<T, DataItem> dataBuilder, Property<T, ?> ... conditionFields) {
        if (conditionFields.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        StringBuilder buf = new StringBuilder();
        for (Property<T, ?> p : conditionFields) {
            buf.append(PropertyWrap.get(p).name).append(",");
        }
        buf.setLength(buf.length() - 1);
        return RunUtils.call(() -> this.getQr().updateList(list, dataBuilder, buf.toString()));
    }

    @Override
    public Long upsert(T entity, boolean excludeNull) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        Object id = data.get(this.pk());
        if (id == null) {
            return RunUtils.call(() -> this.getQr().insert(data));
        }
        return RunUtils.call(() -> this.getQr().upsertBy(data, this.pk()));
    }

    @Override
    public Long upsertBy(T entity, boolean excludeNull, String conditionFields) {
        DataItem data = new DataItem();
        if (excludeNull) {
            data.setEntityIf(entity, (k, v) -> v != null);
        } else {
            data.setEntity(entity);
        }
        return RunUtils.call(() -> this.getQr().upsertBy(data, conditionFields));
    }

    @Override
    public boolean existsById(Object id) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereEq(this.pk(), id)).selectExists());
    }

    @Override
    public boolean exists(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectExists());
    }

    @Override
    public T selectById(Object id) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEq(this.pk(), id)).limit(1)).selectItem("*", clz));
    }

    @Override
    public List<T> selectByIds(Iterable idList) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereIn(this.pk(), idList)).selectList("*", clz));
    }

    @Override
    public List<T> selectByMap(Map<String, Object> columnMap) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr().whereMap(columnMap)).selectList("*", clz));
    }

    @Override
    public T selectItem(T entity) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> ((DbTableQuery)((DbTableQuery)this.getQr().whereEntity(entity)).limit(1)).selectItem("*", clz));
    }

    @Override
    public T selectItem(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return (T)RunUtils.call(() -> this.getQr(c).selectItem("*", clz));
    }

    @Override
    public Object selectValue(String column, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectValue(column));
    }

    @Override
    public Map<String, Object> selectMap(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectMap("*"));
    }

    @Override
    public Long selectCount(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).count());
    }

    @Override
    public List<T> selectList(Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> this.getQr(c).selectList("*", clz));
    }

    @Override
    public List<Map<String, Object>> selectMapList(Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectMapList("*"));
    }

    @Override
    public List<Object> selectArray(String column, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> this.getQr(c).selectArray(column));
    }

    @Override
    public List<T> selectList(int start, int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectList("*", clz));
    }

    @Override
    public List<Map<String, Object>> selectMapList(int start, int size, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
    }

    @Override
    public List<Object> selectArray(String column, int start, int size, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectArray(column));
    }

    @Override
    public IPage<T> selectPage(int start, int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        List list = RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectList("*", clz));
        long total = RunUtils.call(() -> this.getQr(c).selectCount());
        IPageImpl page = new IPageImpl(list, total);
        return page;
    }

    @Override
    public IPage<Map<String, Object>> selectMapPage(int start, int size, Act1<MapperWhereQ> c) {
        List list = RunUtils.call(() -> ((DbTableQuery)this.getQr(c).limit(start, size)).selectMapList("*"));
        long total = RunUtils.call(() -> this.getQr(c).selectCount());
        IPageImpl<Map<String, Object>> page = new IPageImpl<Map<String, Object>>(list, total);
        return page;
    }

    @Override
    public List<T> selectTop(int size, Act1<MapperWhereQ> c) {
        Class<?> clz = this.entityClz();
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).selectList("*", clz));
    }

    @Override
    public List<Map<String, Object>> selectMapTop(int size, Act1<MapperWhereQ> c) {
        return RunUtils.call(() -> ((DbTableQuery)this.getQr(c).top(size)).selectMapList("*"));
    }

    private DbTableQuery getQr() {
        return this.db().table(this.tableName());
    }

    private DbTableQuery getQr(Act1<MapperWhereQ> c) {
        DbTableQuery qr = this.db().table(this.tableName());
        if (c != null) {
            c.run(new MapperWhereQ(qr));
        }
        return qr;
    }
}

