/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.noear.weed.DataItem;
import org.noear.weed.IBinder;
import org.noear.weed.WeedConfig;
import org.noear.weed.wrap.ClassWrap;

public class DataList
implements Serializable,
Iterable<DataItem> {
    ArrayList<DataItem> _rows = new ArrayList();

    public List<DataItem> getRows() {
        return this._rows;
    }

    public DataItem getRow(int index) {
        return this.getRows().get(index);
    }

    public void addRow(DataItem row) {
        this._rows.add(row);
    }

    public int getRowCount() {
        return this._rows.size();
    }

    public void clear() {
        this._rows.clear();
    }

    public DataItem getLastRow() {
        if (this.getRowCount() > 0) {
            return this._rows.get(this.getRowCount() - 1);
        }
        return null;
    }

    public List<Map<String, Object>> getMapList() {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(this.getRowCount());
        for (DataItem r : this._rows) {
            list.add(r.getMap());
        }
        return list;
    }

    @Deprecated
    public <T extends IBinder> List<T> toList(T model) {
        ArrayList<IBinder> list = new ArrayList<IBinder>(this.getRowCount());
        for (DataItem r : this._rows) {
            IBinder item = model.clone();
            if (WeedConfig.isDebug && !model.getClass().isInstance(item)) {
                throw new IllegalArgumentException(model.getClass() + " clone error (" + item.getClass() + ")");
            }
            item.bind(key -> r.getVariate(key));
            list.add(item);
        }
        return list;
    }

    public <T> List<T> toEntityList(Class<T> clz) {
        ClassWrap clzWrap = ClassWrap.get(clz);
        ArrayList<IBinder> list = new ArrayList<IBinder>(this.getRowCount());
        if (IBinder.class.isAssignableFrom(clz)) {
            IBinder mod = (IBinder)clzWrap.newInstance();
            for (DataItem r : this._rows) {
                IBinder item = mod.clone();
                item.bind(key -> r.getVariate(key));
                list.add(item);
            }
        } else {
            for (DataItem r : this._rows) {
                Object item = clzWrap.toEntity(r);
                list.add((IBinder)item);
            }
        }
        return list;
    }

    public Map<String, Object> toMap(String keyColumn) {
        return this.toMap(keyColumn, null);
    }

    public Map<String, Object> toMap(String keyColumn, String valColumn) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (valColumn == null || valColumn.length() == 0) {
            for (DataItem r : this._rows) {
                map.put(r.get(keyColumn).toString(), r);
            }
        } else {
            for (DataItem r : this._rows) {
                map.put(r.get(keyColumn).toString(), r.get(valColumn));
            }
        }
        return map;
    }

    public <T> Set<T> toSet(String column) {
        HashSet<Object> set = new HashSet<Object>();
        for (DataItem r : this._rows) {
            set.add(r.get(column));
        }
        return set;
    }

    public <T> Set<T> toSet(int columnIndex) {
        HashSet<Object> set = new HashSet<Object>();
        for (DataItem r : this._rows) {
            set.add(r.get(columnIndex));
        }
        return set;
    }

    public <T> List<T> toArray(String columnName) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataItem r : this._rows) {
            list.add(r.get(columnName));
        }
        return list;
    }

    public <T> List<T> toArray(int columnIndex) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (DataItem r : this._rows) {
            list.add(r.get(columnIndex));
        }
        return list;
    }

    @Override
    public Iterator<DataItem> iterator() {
        return this._rows.iterator();
    }

    @Override
    public void forEach(Consumer<? super DataItem> action) {
        this._rows.forEach((Consumer<DataItem>)action);
    }

    @Override
    public Spliterator<DataItem> spliterator() {
        return this._rows.spliterator();
    }
}

