/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.weed.DbContext;
import org.noear.weed.DbTranUtil;
import org.noear.weed.WeedConfig;
import org.noear.weed.ext.Act0Ex;
import org.noear.weed.utils.ThrowableUtils;

public class DbTran {
    private final Map<DataSource, Connection> conMap = new HashMap<DataSource, Connection>();
    private boolean _autoCommit = false;

    public Connection getConnection(DbContext db) throws SQLException {
        return this.getConnection(db.getMetaData().getDataSource());
    }

    public Connection getConnection(DataSource ds) throws SQLException {
        if (this.conMap.containsKey(ds)) {
            return this.conMap.get(ds);
        }
        Connection con = ds.getConnection();
        if (!this._autoCommit) {
            con.setAutoCommit(false);
        }
        this.conMap.putIfAbsent(ds, con);
        return con;
    }

    public DbTran autoCommit(boolean autoCommit) {
        this._autoCommit = autoCommit;
        return this;
    }

    public DbTran execute(Act0Ex<Throwable> handler) throws SQLException {
        DbTran tranTmp = DbTranUtil.current();
        try {
            DbTranUtil.currentSet(this);
            handler.run();
            if (!this._autoCommit) {
                this.commit();
            }
        }
        catch (Throwable ex) {
            if (!this._autoCommit) {
                this.rollback();
            }
            if ((ex = ThrowableUtils.throwableUnwrap(ex)) instanceof SQLException) {
                throw (SQLException)ex;
            }
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        finally {
            DbTranUtil.currentRemove();
            this.close();
            if (tranTmp != null) {
                DbTranUtil.currentSet(tranTmp);
            }
        }
        return this;
    }

    protected void rollback() throws SQLException {
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            kv.getValue().rollback();
        }
    }

    protected void commit() throws SQLException {
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            kv.getValue().commit();
        }
    }

    protected void close() throws SQLException {
        for (Map.Entry<DataSource, Connection> kv : this.conMap.entrySet()) {
            try {
                if (kv.getValue().isClosed()) continue;
                kv.getValue().close();
            }
            catch (Exception ex) {
                WeedConfig.runExceptionEvent(null, ex);
            }
        }
    }
}

