/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.noear.weed.Command;
import org.noear.weed.DbContext;
import org.noear.weed.DbProcedure;
import org.noear.weed.SQLBuilder;
import org.noear.weed.WeedConfig;
import org.noear.weed.utils.EntityUtils;
import org.noear.weed.utils.StringUtils;
import org.noear.weed.utils.ThrowableUtils;
import org.noear.weed.xml.XmlSqlBlock;
import org.noear.weed.xml.XmlSqlFactory;

public class DbXmlsqlProcedure
extends DbProcedure {
    private String _sqlid;
    private Map<String, Object> _map = new HashMap<String, Object>();

    public DbXmlsqlProcedure(DbContext context) {
        super(context);
    }

    protected DbXmlsqlProcedure sql(String sqlid) {
        this._sqlid = sqlid;
        this.commandText = sqlid;
        this.paramS.clear();
        this._weedKey = null;
        return this;
    }

    @Override
    public DbProcedure set(String param, Object value) {
        this._map.put(param, value);
        return this;
    }

    @Override
    public DbProcedure setMap(Map<String, Object> map) {
        if (map != null) {
            map.forEach((k, v) -> this._map.put((String)k, v));
        }
        return this;
    }

    @Override
    public DbProcedure setEntity(Object obj) {
        EntityUtils.fromEntity(obj, (k, v) -> this._map.put((String)k, v));
        return this;
    }

    private void _onSet(String name, Object val) {
        if ("_tran".equals(name)) {
            // empty if block
        }
    }

    @Override
    protected String getCommandID() {
        return this.commandText;
    }

    @Override
    public String getWeedKey() {
        if (this._weedKey == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getCommandID()).append(":");
            for (Object p : this._map.values()) {
                sb.append("_").append(p);
            }
            this._weedKey = sb.toString();
        }
        return this._weedKey;
    }

    @Override
    protected Command getCommand() {
        Command cmd = new Command(this.context);
        cmd.key = this.getCommandID();
        XmlSqlBlock block = XmlSqlFactory.get(this._sqlid);
        if (block == null || block.builder == null) {
            throw new RuntimeException("Sql @" + this._sqlid + " does not exist");
        }
        SQLBuilder sqlBuilder = null;
        try {
            sqlBuilder = block.builder.build(this._map);
        }
        catch (Throwable ex) {
            System.out.println("[Weed] " + block.getClasscode(true));
            ex = ThrowableUtils.throwableUnwrap(ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
        for (Object p1 : sqlBuilder.paramS) {
            this.doSet("", p1);
        }
        cmd.text = sqlBuilder.toString();
        cmd.paramS = this.paramS;
        this.tryCacheController(cmd, block);
        this.runCommandBuiltEvent(cmd);
        return cmd;
    }

    private void tryCacheController(Command cmd, XmlSqlBlock block) {
        if (!StringUtils.isEmpty(block._caching) && this._cache == null) {
            cmd.cache = WeedConfig.libOfCache.get(block._caching);
            if (cmd.cache == null) {
                throw new RuntimeException("WeedConfig.libOfCache does not exist:@" + block._caching);
            }
            if (block.isSelect()) {
                this.caching(cmd.cache);
                if (!StringUtils.isEmpty(block._usingCache)) {
                    this.usingCache(Integer.parseInt(block._usingCache));
                }
                if (!StringUtils.isEmpty(block._cacheTag)) {
                    this._cache.usingCache((uc, obj) -> Arrays.asList(block.formatAppendTags(block, this._map, obj).split(",")).forEach(k -> this.cacheTag(k.trim())));
                }
            } else if (!StringUtils.isEmpty(block._cacheClear)) {
                cmd.onExecuteAft = c -> Arrays.asList(block.formatRemoveTags(block, this._map).split(",")).forEach(k -> c.cache.clear(k.trim()));
            }
        }
    }
}

