/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.noear.weed.DbContext;
import org.noear.weed.DbProcedure;
import org.noear.weed.MapperHandler;
import org.noear.weed.Variate;
import org.noear.weed.utils.StringUtils;
import org.noear.weed.xml.XmlSqlBlock;
import org.noear.weed.xml.XmlSqlFactory;
import org.noear.weed.xml.XmlSqlLoader;

class MapperUtil {
    private static String _proxy_lock = "";
    private static Map<Class<?>, Object> _proxy_cache = new HashMap();
    private static Map<String, Class<?>> _clzMap = new HashMap();

    MapperUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <T> T proxy(Class<T> mapperInf, DbContext db) {
        Object tmp = _proxy_cache.get(mapperInf);
        if (tmp == null) {
            String string = _proxy_lock;
            synchronized (string) {
                tmp = _proxy_cache.get(mapperInf);
                if (tmp == null) {
                    tmp = MapperUtil.buildProxy(mapperInf, db);
                    _proxy_cache.put(mapperInf, tmp);
                }
            }
        }
        return (T)tmp;
    }

    private static <T> T buildProxy(Class<?> mapperInf, DbContext db) {
        XmlSqlLoader.tryLoad();
        return (T)Proxy.newProxyInstance(mapperInf.getClassLoader(), new Class[]{mapperInf}, (InvocationHandler)new MapperHandler(db, mapperInf));
    }

    public static Object exec(DbContext db, String xsqlid, Map<String, Object> paramS, Class<?> rClz, Type rType) throws Exception {
        XmlSqlBlock block = XmlSqlFactory.get(xsqlid.substring(1));
        if (block == null) {
            throw new RuntimeException("Xmlsql does not exist:" + xsqlid);
        }
        return MapperUtil.exec(db, block, xsqlid, paramS, rClz, rType);
    }

    protected static Object exec(DbContext db, XmlSqlBlock block, String xsqlid, Map<String, Object> paramS, Class<?> rClz, Type rType) throws Exception {
        DbProcedure sp = db.call(xsqlid);
        if (paramS != null) {
            sp.setMap(paramS);
        }
        if (block.isSelect()) {
            if (block._return.indexOf(".") > 0) {
                if (block._return_item != null) {
                    if (block._return.indexOf("java.lang.") > 0) {
                        return sp.getArray(0);
                    }
                    Class<?> rst_clz2 = MapperUtil.item_type(rType, block);
                    return sp.getList(rst_clz2);
                }
                Class<Object> rst_type = rClz;
                if (rClz == null) {
                    rst_type = !StringUtils.isEmpty(block._return) ? Class.forName(block._return) : Void.TYPE;
                }
                return sp.getItem(rst_type);
            }
            if (block._return.startsWith("List<")) {
                return sp.getDataList().toArray(0);
            }
            if (block._return.startsWith("Set<")) {
                return sp.getDataList().toSet(0);
            }
            switch (block._return) {
                case "Map": {
                    return sp.getMap();
                }
                case "MapList": {
                    return sp.getMapList();
                }
                case "DataItem": {
                    return sp.getDataItem();
                }
                case "DataList": {
                    return sp.getDataList();
                }
            }
            Variate valV = sp.getVariate();
            if (valV.getValue() == null) {
                if (Integer.TYPE == rType) {
                    return 0;
                }
                if (Long.TYPE == rType) {
                    return 0L;
                }
                if (Float.TYPE == rType) {
                    return Float.valueOf(0.0f);
                }
                if (Double.TYPE == rType) {
                    return 0.0;
                }
            } else {
                if (block._return.toLowerCase().startsWith("int")) {
                    return valV.intValue(0);
                }
                if (block._return.toLowerCase().startsWith("long")) {
                    return valV.longValue(0L);
                }
                if (block._return.toLowerCase().startsWith("float")) {
                    return Float.valueOf(valV.floatValue(0.0f));
                }
                if (block._return.toLowerCase().startsWith("double")) {
                    return valV.doubleValue(0.0);
                }
                if (block._return.toLowerCase().startsWith("str")) {
                    return valV.stringValue(null);
                }
            }
            return valV.getValue();
        }
        if (block.isInsert()) {
            long rst = sp.insert();
            if (block._return != null && block._return.indexOf("ool") > 0) {
                return rst > 0L;
            }
            return rst;
        }
        int rst = sp.execute();
        if (block._return != null && block._return.indexOf("ool") > 0) {
            return rst > 0;
        }
        return rst;
    }

    private static Class<?> item_type(Type rType, XmlSqlBlock block) throws Exception {
        if (rType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)rType).getActualTypeArguments()[0];
        }
        if (!StringUtils.isEmpty(block._return_item)) {
            return MapperUtil.getClass(block._return_item);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class<?> getClass(String fullname) throws Exception {
        Class<?> tmp = _clzMap.get(fullname);
        if (tmp == null) {
            String string = fullname.intern();
            synchronized (string) {
                tmp = _clzMap.get(fullname);
                if (tmp == null) {
                    tmp = Class.forName(fullname);
                    _clzMap.put(fullname, tmp);
                }
            }
        }
        return tmp;
    }
}

