/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.dialect;

import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.noear.weed.dialect.DbDialectBase;

public class DbH2Dialect
extends DbDialectBase {
    @Override
    public Object preChange(Object val) throws SQLException {
        if (val instanceof Clob) {
            Clob clob = (Clob)val;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (val instanceof Byte) {
            return (Byte)val > 0;
        }
        return val;
    }

    @Override
    public ResultSet getTables(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        return md.getTables(null, null, null, new String[]{"TABLE"});
    }

    @Override
    public String preReview(String code) {
        if (code.indexOf("CREATE TABLE") >= 0) {
            return code.replace("ENGINE=InnoDB ", "").replace("USING BTREE", "").replace("USING HASH", "").replaceAll("`\\(\\d+\\)\\)", "`)").replace("CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ", "");
        }
        if (code.indexOf("information_schema.") >= 0) {
            return code.toUpperCase();
        }
        return code;
    }

    @Override
    public boolean supportsVariablePaging() {
        return true;
    }
}

