/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.dialect;

import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.noear.weed.DbContext;
import org.noear.weed.SQLBuilder;
import org.noear.weed.dialect.DbDialectBase;

public class DbSQLiteDialect
extends DbDialectBase {
    @Override
    public Object preChange(Object val) throws SQLException {
        if (val instanceof Clob) {
            Clob clob = (Clob)val;
            return clob.getSubString(1L, (int)clob.length());
        }
        if (val instanceof Byte) {
            return (Byte)val > 0;
        }
        return val;
    }

    @Override
    public ResultSet getTables(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        return md.getTables(null, null, null, new String[]{"TABLE"});
    }

    @Override
    public String preReview(String code) {
        if (code.indexOf("CREATE TABLE") >= 0) {
            code = code.replace("ENGINE=InnoDB ", "").replace("USING BTREE", "").replace("USING HASH", "").replaceAll("`\\(\\d+\\)\\)", "`)").replace("CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci ", "").replace(" int NOT NULL AUTO_INCREMENT", " INTEGER PRIMARY KEY AUTOINCREMENT").replace(" bigint NOT NULL AUTO_INCREMENT", " INTEGER PRIMARY KEY AUTOINCREMENT");
            return code.replaceAll("\\sCOMMENT\\s+'[^']*'", "");
        }
        if (code.indexOf("information_schema.") >= 0) {
            return code.toUpperCase();
        }
        if (code.indexOf("TRUNCATE TABLE ") >= 0) {
            return code.replace("TRUNCATE TABLE ", "DELETE FROM ");
        }
        return code;
    }

    @Override
    public void buildSelectRangeCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int start, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" LIMIT ? OFFSET ?");
            sqlB.paramS.add(size);
            sqlB.paramS.add(start);
        } else {
            sqlB.append(" LIMIT ").append(size).append(" OFFSET ").append(start);
        }
    }

    @Override
    public boolean supportsVariablePaging() {
        return true;
    }
}

