/*
 * Decompiled with CFR 0.152.
 */
package org.noear.weed.wrap;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.noear.weed.WeedConfig;
import org.noear.weed.annotation.Column;
import org.noear.weed.annotation.Exclude;

public class FieldWrap {
    public final Field field;
    public final String name;
    public final boolean exclude;
    public final boolean readonly;
    private Method _getter;
    private Method _setter;

    protected FieldWrap(Class<?> clz, Field f1, boolean isFinal) {
        this.field = f1;
        this.exclude = f1.getAnnotation(Exclude.class) != null || Modifier.isFinal(f1.getModifiers());
        this.readonly = isFinal;
        Column fn = f1.getAnnotation(Column.class);
        this.name = fn != null ? fn.value() : WeedConfig.namingStrategy.fieldToColumnName(clz, f1);
        this.field.setAccessible(true);
        this._getter = FieldWrap.findGetter(clz, f1);
        this._setter = FieldWrap.findSetter(clz, f1);
    }

    public Object getValue(Object tObj) throws ReflectiveOperationException {
        if (this._getter == null) {
            return this.field.get(tObj);
        }
        return this._getter.invoke(tObj, new Object[0]);
    }

    public void setValue(Object tObj, Object val) throws ReflectiveOperationException {
        if (this.readonly) {
            return;
        }
        try {
            if (val == null) {
                return;
            }
            val = WeedConfig.typeConverter.convert(val, this.field.getType());
            if (this._setter == null) {
                this.field.set(tObj, val);
            } else {
                this._setter.invoke(tObj, val);
            }
        }
        catch (IllegalArgumentException ex) {
            if (val == null) {
                throw new IllegalArgumentException(this.name + "(" + this.field.getType().getSimpleName() + ")\u7c7b\u578b\u63a5\u6536\u5931\u8d25!", ex);
            }
            throw new IllegalArgumentException(this.name + "(" + this.field.getType().getSimpleName() + ")\u7c7b\u578b\u63a5\u6536\u5931\u8d25\uff1aval(" + val.getClass().getSimpleName() + ")", ex);
        }
    }

    private static Method findGetter(Class<?> tCls, Field field) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String setMethodName = "get" + firstLetter + fieldName.substring(1);
        try {
            Method getFun = tCls.getMethod(setMethodName, new Class[0]);
            if (getFun != null) {
                return getFun;
            }
        }
        catch (NoSuchMethodException getFun) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static Method findSetter(Class<?> tCls, Field field) {
        String fieldName = field.getName();
        String firstLetter = fieldName.substring(0, 1).toUpperCase();
        String setMethodName = "set" + firstLetter + fieldName.substring(1);
        try {
            Method setFun = tCls.getMethod(setMethodName, field.getType());
            if (setFun != null) {
                return setFun;
            }
        }
        catch (NoSuchMethodException setFun) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

