/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.cache.redis;

import java.lang.reflect.Type;
import java.util.Properties;
import org.noear.redisx.RedisClient;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.cache.ISerializer;
import org.noear.wood.cache.redis.JavabinSerializer;
import org.noear.wood.utils.EncryptUtils;
import org.noear.wood.utils.StringUtils;

public class RedisCache
implements ICacheServiceEx {
    private String _cacheKeyHead;
    private int _defaultSeconds;
    private RedisClient _cache = null;
    private ISerializer<String> _serializer = null;

    public RedisCache serializer(ISerializer<String> serializer) {
        if (serializer != null) {
            this._serializer = serializer;
        }
        return this;
    }

    public RedisCache(String keyHeader, int defSeconds, String server, String user, String password) {
        Properties prop = new Properties();
        prop.setProperty("server", server);
        if (user != null) {
            prop.setProperty("user", user);
        }
        if (password != null) {
            prop.setProperty("password", password);
        }
        this.initDo(prop, keyHeader, defSeconds);
    }

    public RedisCache(Properties prop) {
        this.initDo(prop, prop.getProperty("keyHeader"), 0);
    }

    public RedisCache(Properties prop, String keyHeader, int defSeconds) {
        this.initDo(prop, keyHeader, defSeconds);
    }

    private void initDo(Properties prop, String keyHeader, int defSeconds) {
        String defSeconds_str = prop.getProperty("defSeconds");
        if (defSeconds == 0 && !StringUtils.isEmpty((String)defSeconds_str)) {
            defSeconds = Integer.parseInt(defSeconds_str);
        }
        this._cacheKeyHead = keyHeader;
        this._defaultSeconds = defSeconds;
        if (this._defaultSeconds < 1) {
            this._defaultSeconds = 30;
        }
        this._cache = new RedisClient(prop);
        this._serializer = JavabinSerializer.instance;
    }

    public void store(String key, Object obj, int seconds) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            try {
                String val = (String)this._serializer.serialize(obj);
                if (seconds > 0) {
                    this._cache.open(ru -> ru.key(newKey).expire(seconds).set(val));
                } else {
                    this._cache.open(ru -> ru.key(newKey).expire(this.getDefalutSeconds()).set(val));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
    }

    public <T> T get(String key, Type type) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            String val = (String)this._cache.openAndGet(ru -> ru.key(newKey).get());
            try {
                return (T)this._serializer.deserialize((Object)val, type);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    public void remove(String key) {
        if (this._cache != null) {
            String newKey = this.newKey(key);
            this._cache.open(ru -> ru.key(newKey).delete());
        }
    }

    public int getDefalutSeconds() {
        return this._defaultSeconds;
    }

    public String getCacheKeyHead() {
        return this._cacheKeyHead;
    }

    private String newKey(String key) {
        return this._cacheKeyHead + "$" + EncryptUtils.md5((String)key);
    }
}

