package org.noear.wood.wrap;

public enum DbType {
    //
    // 摘要:
    //     未知或未定义。
    Unknown,

    MySQL,
    MariaDB,

    SQLServer,
    PostgreSQL,
    Oracle,
    DB2,
    SQLite,
    H2,
    Phoenix,
    ClickHouse,
    Presto,

    /*
    Unknown(DatabaseType.Unknown, "Unknown", "Unknown", 0),
    OracleThinServiceName(DatabaseType.Oracle, "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@//${host}:${port}/${name}", 1521),
    OracleThinSID(DatabaseType.Oracle, "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@${host}:${port}:${name}", 1521),
    OracleThinTNSName(DatabaseType.Oracle, "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@${name}", 1521),
    OracleOCI(DatabaseType.Oracle, "oracle.jdbc.OracleDriver", "jdbc:oracle:oci:@${host}:${port}:${name}", 1521),
    OracleOCI8(DatabaseType.Oracle, "oracle.jdbc.OracleDriver", "jdbc:oracle:oci8:@${host}:${port}:${name}", 1521),

    SQLServer(DatabaseType.SQLServer, "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://${host}:${port};DatabaseName=${name}", 1433),
    SQLServer2000(DatabaseType.SQLServer2000, "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:microsoft:sqlserver://${host}:${port};DatabaseName=${name}", 1433),

    MySQL(DatabaseType.MySQL, "com.mysql.jdbc.Driver", "jdbc:mysql://${host}:${port}/${name}", 3306),

    DB2(DatabaseType.DB2, "com.ibm.db2.jcc.DB2Driver", "jdbc:db2://${host}:${port}/${name}", 50000),

    PostgreSQL(DatabaseType.PostgreSQL, "org.postgresql.Driver", "jdbc:postgresql://${host}:${port}/${name}", 5432),

    HWMPPDB(DatabaseType.HWMPPDB, "org.postgresql.Driver", "jdbc:postgresql://${host}:${port}/${name}", 5432),

    GaussDB200(DatabaseType.GaussDB200, "org.postgresql.Driver", "jdbc:postgresql://${host}:${port}/${name}", 5432),
    GaussDB100(DatabaseType.GaussDB100, "com.huawei.gauss.jdbc.ZenithDriver", "jdbc:zenith:@${host}:${port}", 40000),

    SQLiteFile(DatabaseType.SQLite, "org.sqlite.JDBC", "jdbc:sqlite:${name}", 0),
    SQLiteMemory(DatabaseType.SQLite, "org.sqlite.JDBC", "jdbc:sqlite:", 0),

    BDBFile(DatabaseType.BDB, "SQLite.JDBCDriver", "jdbc:sqlite:/${name}", 0),
    BDBMemory(DatabaseType.BDB, "SQLite.JDBCDriver", "jdbc:sqlite:/", 0),

    SybaseASE(DatabaseType.Sybase, "com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:${host}:${port}/${name}", 5000),
    SybaseAnywhere(DatabaseType.Sybase, "com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:${host}:${port}?ServiceName=${name}", 2638),

    Hive(DatabaseType.Hive, "org.apache.hadoop.hive.jdbc.HiveDriver", "jdbc:hive://${host}:${port}/${name}", 10000),

    Teradata(DatabaseType.Teradata, "com.teradata.jdbc.TeraDriver", "jdbc:teradata://${host}/${name}", 0),

    GreenPlum(DatabaseType.GreenPlum, "org.postgresql.Driver", "jdbc:postgresql://${host}:${port}/${name}", 5432),

    GBase(DatabaseType.GBase, "com.gbase.jdbc.Driver", "jdbc:gbase://${host}:${port}/${name}", 5258);

    ClickHouse("jdbc:clickhouse://192.168.110.133:8123/system");// url路径
    */
}
