/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.Set;
import org.noear.wood.IBinder;
import org.noear.wood.IDataItem;
import org.noear.wood.Variate;
import org.noear.wood.ext.Act2;
import org.noear.wood.ext.Fun2;
import org.noear.wood.ext.LinkedCaseInsensitiveMap;
import org.noear.wood.utils.EntityUtils;
import org.noear.wood.wrap.ClassWrap;

public abstract class DataItemBase<Y extends DataItemBase>
implements IDataItem {
    Map<String, Object> _data = new LinkedCaseInsensitiveMap<Object>();
    private boolean _isUsingDbNull = false;

    public DataItemBase(Boolean isUsingDbNull) {
        this._isUsingDbNull = isUsingDbNull;
    }

    @Override
    public int count() {
        return this._data.size();
    }

    @Override
    public void clear() {
        this._data.clear();
    }

    @Override
    public boolean exists(String name) {
        if (name == null) {
            return false;
        }
        return this._data.containsKey(name);
    }

    @Override
    public Set<String> keys() {
        return this._data.keySet();
    }

    @Override
    public void remove(String name) {
        this._data.remove(name);
    }

    public Y set(String name, Object value) {
        this._data.put(name, value);
        return (Y)this;
    }

    public Y setIf(boolean condition, String name, Object value) {
        if (condition) {
            this.set(name, value);
        }
        return (Y)this;
    }

    public Y setDf(String name, Object value, Object def) {
        if (value == null) {
            this.set(name, def);
        } else {
            this.set(name, value);
        }
        return (Y)this;
    }

    @Override
    public Object get(int index) {
        for (String key : this._data.keySet()) {
            if (index == 0) {
                return this.get(key);
            }
            --index;
        }
        return null;
    }

    @Override
    public Object get(String name) {
        return this._data.get(name);
    }

    @Override
    public <T> T getOrDef(String name, T def) {
        return (T)this._data.getOrDefault(name, def);
    }

    @Override
    public Variate getVariate(String name) {
        if (this._data.containsKey(name)) {
            return new Variate(name, this.get(name));
        }
        return new Variate(name, null);
    }

    @Override
    public Short getShort(String name) {
        Number tmp = (Number)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.shortValue();
    }

    @Override
    public Integer getInt(String name) {
        Number tmp = (Number)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.intValue();
    }

    @Override
    public Long getLong(String name) {
        Number tmp = (Number)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.longValue();
    }

    @Override
    public Double getDouble(String name) {
        Number tmp = (Number)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.doubleValue();
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return (BigDecimal)this.get(name);
    }

    @Override
    public BigInteger getBigInteger(String name) {
        return (BigInteger)this.get(name);
    }

    @Override
    public Float getFloat(String name) {
        Number tmp = (Number)this.get(name);
        if (tmp == null) {
            return null;
        }
        return Float.valueOf(tmp.floatValue());
    }

    @Override
    public String getString(String name) {
        return (String)this.get(name);
    }

    @Override
    public Boolean getBoolean(String name) {
        return (Boolean)this.get(name);
    }

    @Override
    public java.util.Date getDateTime(String name) {
        return (java.util.Date)this.get(name);
    }

    @Override
    public LocalDateTime getLocalDateTime(String name) {
        Timestamp tmp = (Timestamp)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.toLocalDateTime();
    }

    @Override
    public LocalDate getLocalDate(String name) {
        Date tmp = (Date)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.toLocalDate();
    }

    @Override
    public LocalTime getLocalTime(String name) {
        Time tmp = (Time)this.get(name);
        if (tmp == null) {
            return null;
        }
        return tmp.toLocalTime();
    }

    @Override
    public void forEach(Act2<String, Object> callback) {
        for (Map.Entry<String, Object> kv : this._data.entrySet()) {
            Object val = kv.getValue();
            if (val == null && this._isUsingDbNull) {
                callback.run(kv.getKey(), "$NULL");
                continue;
            }
            callback.run(kv.getKey(), val);
        }
    }

    public Y setMap(Map<String, Object> data) {
        return this.setMapIf(data, (k, v) -> v != null);
    }

    public Y setMapIf(Map<String, Object> data, Fun2<Boolean, String, Object> condition) {
        data.forEach((? super K k, ? super V v) -> {
            if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                this.set((String)k, v);
            }
        });
        return (Y)this;
    }

    public Y setEntity(Object obj) {
        return this.setEntityIf(obj, (k, v) -> v != null);
    }

    public Y setEntityIf(Object obj, Fun2<Boolean, String, Object> condition) {
        EntityUtils.fromEntity(obj, (k, v) -> {
            if (((Boolean)condition.run((String)k, v)).booleanValue()) {
                this.set((String)k, v);
            }
        });
        return (Y)this;
    }

    public <T> T toEntity(Class<T> cls) {
        ClassWrap classWrap = ClassWrap.get(cls);
        if (IBinder.class.isAssignableFrom(cls)) {
            IBinder mod = (IBinder)classWrap.newInstance();
            mod.bind(key -> this.getVariate(key));
            return (T)mod;
        }
        return classWrap.toEntity(this);
    }

    @Override
    public Map<String, Object> getMap() {
        return this._data;
    }
}

