/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.io.Closeable;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.noear.wood.WoodConfig;
import org.noear.wood.dialect.DbClickHouseDialect;
import org.noear.wood.dialect.DbDb2Dialect;
import org.noear.wood.dialect.DbDialect;
import org.noear.wood.dialect.DbH2Dialect;
import org.noear.wood.dialect.DbMySQLDialect;
import org.noear.wood.dialect.DbOracleDialect;
import org.noear.wood.dialect.DbPhoenixDialect;
import org.noear.wood.dialect.DbPostgreSQLDialect;
import org.noear.wood.dialect.DbPrestoDialect;
import org.noear.wood.dialect.DbSQLServerDialect;
import org.noear.wood.dialect.DbSQLiteDialect;
import org.noear.wood.ext.Act1Ex;
import org.noear.wood.wrap.ColumnWrap;
import org.noear.wood.wrap.DbType;
import org.noear.wood.wrap.TableWrap;

public class DbContextMetaData
implements Closeable {
    private String schema;
    private String catalog;
    private String productName;
    private String productVersion;
    private String url;
    private transient Map<String, TableWrap> tableAll;
    private transient DbType type = DbType.Unknown;
    private transient DbDialect dialect;
    private transient DataSource dataSource;

    public String getUrl() {
        return this.url;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    protected void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    public Connection getConnection() throws SQLException {
        return WoodConfig.connectionFactory.getConnection(this.getDataSource());
    }

    public Connection getMetaConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public String getSchema() {
        return this.schema;
    }

    protected void setSchema(String schema) {
        this.schema = schema;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public DbType getType() {
        this.init();
        return this.type;
    }

    public void setType(DbType type) {
        this.init();
        this.type = type;
    }

    public DbDialect getDialect() {
        this.init();
        return this.dialect;
    }

    public void setDialect(DbDialect dialect) {
        this.init();
        this.dialect = dialect;
    }

    public Collection<TableWrap> getTableAll() {
        this.init();
        this.initTables();
        return this.tableAll.values();
    }

    public TableWrap getTable(String tableName) {
        this.init();
        this.initTables();
        return this.tableAll.get(tableName.toLowerCase());
    }

    public String getTablePk1(String tableName) {
        TableWrap tw = this.getTable(tableName);
        return tw == null ? null : tw.getPk1();
    }

    public synchronized void refresh() {
        this.initDo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init() {
        if (this.dialect != null) {
            return true;
        }
        DbContextMetaData dbContextMetaData = this;
        synchronized (dbContextMetaData) {
            if (this.dialect != null) {
                return true;
            }
            return this.initDo();
        }
    }

    private void initPrintln(String x) {
        if (this.schema == null) {
            System.out.println("[Wood] Init: " + x);
        } else {
            System.out.println("[Wood] Init: " + x + " - " + this.schema);
        }
    }

    private boolean initDo() {
        this.initPrintln("Init metadata dialect");
        return this.openMetaConnection(conn -> {
            DatabaseMetaData md = conn.getMetaData();
            this.url = md.getURL();
            this.productName = md.getDatabaseProductName();
            this.productVersion = md.getDatabaseProductVersion();
            if (this.dialect == null) {
                this.setDatabaseType(this.url);
                this.setSchema((Connection)conn);
            }
        });
    }

    private void setDatabaseType(String jdbcUrl) {
        if (jdbcUrl != null) {
            String pn = jdbcUrl.toLowerCase().replace(" ", "");
            if (pn.startsWith("jdbc:mysql:")) {
                this.type = DbType.MySQL;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:mariadb:")) {
                this.type = DbType.MariaDB;
                this.dialect = new DbMySQLDialect();
            } else if (pn.startsWith("jdbc:sqlserver:")) {
                this.type = DbType.SQLServer;
                this.dialect = new DbSQLServerDialect();
            } else if (pn.startsWith("jdbc:oracle:")) {
                this.type = DbType.Oracle;
                this.dialect = new DbOracleDialect();
            } else if (pn.startsWith("jdbc:postgresql:")) {
                this.type = DbType.PostgreSQL;
                this.dialect = new DbPostgreSQLDialect();
            } else if (pn.startsWith("jdbc:db2:")) {
                this.type = DbType.DB2;
                this.dialect = new DbDb2Dialect();
            } else if (pn.startsWith("jdbc:sqlite:")) {
                this.type = DbType.SQLite;
                this.dialect = new DbSQLiteDialect();
            } else if (pn.startsWith("jdbc:h2:")) {
                this.type = DbType.H2;
                this.dialect = new DbH2Dialect();
            } else if (pn.startsWith("jdbc:phoenix:")) {
                this.type = DbType.Phoenix;
                this.dialect = new DbPhoenixDialect();
            } else if (pn.startsWith("jdbc:clickhouse:")) {
                this.type = DbType.ClickHouse;
                this.dialect = new DbClickHouseDialect();
            } else if (pn.startsWith("jdbc:presto:")) {
                this.type = DbType.Presto;
                this.dialect = new DbPrestoDialect();
            } else {
                this.dialect = new DbMySQLDialect();
            }
        } else {
            this.type = DbType.MySQL;
            this.dialect = new DbMySQLDialect();
        }
    }

    private void setSchema(Connection conn) throws SQLException {
        try {
            this.catalog = conn.getCatalog();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (this.schema != null) {
            return;
        }
        try {
            this.schema = conn.getSchema();
            if (this.schema == null) {
                this.schema = this.catalog;
            }
        }
        catch (Throwable e) {
            switch (this.type) {
                case PostgreSQL: {
                    this.schema = "public";
                    break;
                }
                case H2: {
                    this.schema = "PUBLIC";
                    break;
                }
                case SQLServer: {
                    this.schema = "dbo";
                }
                case Oracle: {
                    this.schema = conn.getMetaData().getUserName();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() {
        if (this.tableAll != null) {
            return;
        }
        DbContextMetaData dbContextMetaData = this;
        synchronized (dbContextMetaData) {
            if (this.tableAll != null) {
                return;
            }
            this.tableAll = new HashMap<String, TableWrap>();
            this.initPrintln("Init metadata tables");
            this.openMetaConnection(conn -> this.initTablesLoadDo(conn.getMetaData()));
        }
    }

    private void initTablesLoadDo(DatabaseMetaData md) throws SQLException {
        ResultSet rs = null;
        rs = this.getDialect().getTables(md, this.catalog, this.schema);
        while (rs.next()) {
            String name = rs.getString("TABLE_NAME");
            String remarks = rs.getString("REMARKS");
            TableWrap tWrap = new TableWrap(name, remarks);
            this.tableAll.put(name.toLowerCase(), tWrap);
        }
        rs.close();
        ArrayList<ColumnWrap> columnAll = new ArrayList<ColumnWrap>();
        rs = md.getColumns(this.catalog, this.schema, "%", "%");
        while (rs.next()) {
            int digit = 0;
            Object o = rs.getObject("DECIMAL_DIGITS");
            if (o != null) {
                digit = ((Number)o).intValue();
            }
            ColumnWrap cw = new ColumnWrap(rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), digit, rs.getString("IS_NULLABLE"), rs.getString("REMARKS"));
            columnAll.add(cw);
        }
        rs.close();
        for (String key : this.tableAll.keySet()) {
            TableWrap tWrap = this.tableAll.get(key);
            columnAll.stream().filter(c1 -> key.equals(c1.getTable())).forEach(c1 -> tWrap.addColumn((ColumnWrap)c1));
            rs = md.getPrimaryKeys(this.catalog, this.schema, tWrap.getName());
            while (rs.next()) {
                String idName = rs.getString("COLUMN_NAME");
                tWrap.addPk(idName);
            }
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean openMetaConnection(Act1Ex<Connection, Exception> callback) {
        boolean bl;
        Connection conn = null;
        try {
            this.initPrintln("The db metadata connectivity...");
            conn = this.getMetaConnection();
            callback.run(conn);
            this.initPrintln("The db metadata is loaded successfully");
            bl = true;
            if (conn == null) return bl;
        }
        catch (Throwable ex) {
            try {
                this.initPrintln("The db metadata is loaded failed");
                ex.printStackTrace();
                boolean bl2 = false;
                return bl2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        try {
            conn.close();
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        if (this.dataSource != null && this.dataSource instanceof Closeable) {
            ((Closeable)((Object)this.dataSource)).close();
        }
    }
}

