/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.noear.wood.Command;
import org.noear.wood.DbContext;
import org.noear.wood.DbProcedure;
import org.noear.wood.TmlAnalyzer;
import org.noear.wood.TmlBlock;
import org.noear.wood.TmlMark;
import org.noear.wood.Variate;
import org.noear.wood.WoodConfig;
import org.noear.wood.utils.EntityUtils;

public class DbQueryProcedure
extends DbProcedure {
    private Map<String, Variate> _paramS2 = new HashMap<String, Variate>();

    public DbQueryProcedure(DbContext context) {
        super(context);
    }

    protected DbQueryProcedure sql(String sqlCode) {
        this.commandText = sqlCode;
        this.paramS.clear();
        this._woodKey = null;
        return this;
    }

    private DbQueryProcedure doSqlItem(String sqlCode) {
        this.commandText = sqlCode;
        this.paramS.clear();
        this._woodKey = null;
        return this;
    }

    private void set_do(String param, Object value) {
        this._paramS2.put(param, new Variate(param, value));
    }

    @Override
    public DbProcedure set(String param, Object value) {
        if (param.startsWith("@")) {
            this.set_do(param.substring(1), value);
        } else {
            this.set_do(param, value);
        }
        return this;
    }

    @Override
    public DbProcedure setMap(Map<String, Object> map) {
        if (map != null) {
            map.forEach((k, v) -> this.set_do((String)k, v));
        }
        return this;
    }

    @Override
    public DbProcedure setEntity(Object obj) {
        EntityUtils.fromEntity(obj, (k, v) -> this.set_do((String)k, v));
        return this;
    }

    @Override
    public String getWoodKey() {
        return this.buildWoodKey(this._paramS2.values());
    }

    @Override
    protected String getCommandID() {
        this.tryLazyload();
        return this.commandText;
    }

    @Override
    protected Command getCommand() throws SQLException {
        this.tryLazyload();
        Command cmd = new Command(this.context);
        cmd.key = this.getCommandID();
        String sqlTxt = this.commandText;
        this.build(cmd, sqlTxt);
        this.runCommandBuiltEvent(cmd);
        return cmd;
    }

    protected void build(Command cmd, String tml) {
        HashMap<String, String> tmpList = new HashMap<String, String>();
        TmlBlock block = TmlAnalyzer.get(tml, this._paramS2);
        tml = block.sql2;
        for (TmlMark tm : block.marks) {
            Variate val = this._paramS2.get(tm.name);
            if (WoodConfig.isDebug && val == null) {
                throw new RuntimeException("Lack of parameter:" + tm.name);
            }
            Object tmp = val.getValue();
            if (tmp instanceof Iterable) {
                StringBuilder sb = new StringBuilder();
                for (Object p2 : (Iterable)tmp) {
                    this.doSet(new Variate(tm.name, p2));
                    sb.append("?").append(",");
                }
                int len = sb.length();
                if (len > 0) {
                    sb.deleteCharAt(len - 1);
                }
                tmpList.put(tm.mark, sb.toString());
                continue;
            }
            if (!tm.mark.startsWith("@")) continue;
            this.doSet(val);
        }
        if (tmpList.size() > 0) {
            ArrayList keyList = new ArrayList(tmpList.keySet());
            Collections.sort(keyList, (o1, o2) -> {
                int len = o2.length() - o1.length();
                if (len > 0) {
                    return 1;
                }
                if (len < 0) {
                    return -1;
                }
                return 0;
            });
            for (String key : keyList) {
                tml = tml.replace(key, (CharSequence)tmpList.get(key));
            }
        }
        if (WoodConfig.isUsingSchemaExpression && tml.indexOf("$") >= 0) {
            tml = this.context.schema() == null ? tml.replace("$.", "") : tml.replace("$", this.context.schema());
        }
        cmd.paramS = this.paramS;
        cmd.text = tml;
    }

    @Override
    public int execute() throws SQLException {
        String[] sqlList;
        this.tryLazyload();
        if (this.context.isAllowMultiQueries()) {
            return super.execute();
        }
        int num = 0;
        for (String sql : sqlList = this.commandText.split(";")) {
            if (sql.length() <= 10) continue;
            this.doSqlItem(sql);
            num += super.execute();
        }
        return num;
    }
}

