/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.noear.wood.Command;
import org.noear.wood.DataItem;
import org.noear.wood.DataList;
import org.noear.wood.DbContext;
import org.noear.wood.DbQuery;
import org.noear.wood.GetHandler;
import org.noear.wood.IDataItem;
import org.noear.wood.IPage;
import org.noear.wood.IQuery;
import org.noear.wood.SQLBuilder;
import org.noear.wood.SelectQ;
import org.noear.wood.Variate;
import org.noear.wood.WhereBase;
import org.noear.wood.WoodConfig;
import org.noear.wood.cache.CacheUsing;
import org.noear.wood.cache.ICacheController;
import org.noear.wood.cache.ICacheService;
import org.noear.wood.ext.Act1;
import org.noear.wood.ext.Act2;
import org.noear.wood.impl.IPageImpl;
import org.noear.wood.wrap.DbType;

public class DbTableQueryBase<T extends DbTableQueryBase>
extends WhereBase<T>
implements ICacheController<DbTableQueryBase> {
    String _table_raw;
    String _table;
    SQLBuilder _builder_bef;
    int _isLog = 0;
    protected int limit_start;
    protected int limit_size;
    protected int limit_top = 0;
    String _hint = null;
    private boolean _usingNull = WoodConfig.isUsingValueNull;
    private boolean _usingExpression = WoodConfig.isUsingValueExpression;
    protected CacheUsing _cache = null;

    public DbTableQueryBase(DbContext context) {
        super(context);
        this._builder_bef = new SQLBuilder();
    }

    public T log(boolean isLog) {
        this._isLog = isLog ? 1 : -1;
        return (T)this;
    }

    public T build(Act1<T> builder) {
        builder.run(this);
        return (T)this;
    }

    protected T table(String table) {
        if (table.startsWith("#")) {
            this._table_raw = this._table = table.substring(1);
        } else {
            this._table_raw = table;
            this._table = table.indexOf(46) > 0 ? table : (WoodConfig.isUsingSchemaPrefix && this._context.schema() != null ? this.fmtObject(this._context.schema() + "." + table) : this.fmtObject(table));
        }
        return (T)this;
    }

    public T with(String name, String code, Object ... args) {
        if (this._builder_bef.length() < 6) {
            this._builder_bef.append(" WITH ");
        } else {
            this._builder_bef.append(",");
        }
        this._builder_bef.append(this.fmtColumn(name)).append(" AS (").append(code, args).append(") ");
        return (T)this;
    }

    public T with(String name, SelectQ select) {
        if (this._builder_bef.length() < 6) {
            this._builder_bef.append(" WITH ");
        } else {
            this._builder_bef.append(",");
        }
        this._builder_bef.append(this.fmtColumn(name)).append(" AS (").append(select).append(") ");
        return (T)this;
    }

    public T from(String table) {
        this._builder.append(" FROM ").append(this.fmtObject(table));
        return (T)this;
    }

    private T join(String style, String table) {
        if (table.startsWith("#")) {
            this._builder.append(style).append(table.substring(1));
        } else if (WoodConfig.isUsingSchemaPrefix && this._context.schema() != null) {
            this._builder.append(style).append(this.fmtObject(this._context.schema() + "." + table));
        } else {
            this._builder.append(style).append(this.fmtObject(table));
        }
        return (T)this;
    }

    public T innerJoin(String table) {
        return this.join(" INNER JOIN ", table);
    }

    public T leftJoin(String table) {
        return this.join(" LEFT JOIN ", table);
    }

    public T rightJoin(String table) {
        return this.join(" RIGHT JOIN ", table);
    }

    public T append(String code, Object ... args) {
        this._builder.append(code, args);
        return (T)this;
    }

    public T on(String code) {
        this._builder.append(" ON ").append(code);
        return (T)this;
    }

    public T onEq(String column1, String column2) {
        this._builder.append(" ON ").append(this.fmtColumn(column1)).append("=").append(this.fmtColumn(column2));
        return (T)this;
    }

    public long insert(Act1<IDataItem> dataBuilder) throws SQLException {
        DataItem item = new DataItem();
        dataBuilder.run(item);
        return this.insert(item);
    }

    public long insert(IDataItem data) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0L;
        }
        return this.insertCompile(data).insert();
    }

    public Command insertAsCmd(IDataItem data) {
        if (data == null || data.count() == 0) {
            return null;
        }
        return this.insertCompile(data).getCommand();
    }

    protected DbQuery insertCompile(IDataItem data) {
        this._builder.clear();
        this._context.getDialect().buildInsertOneCode(this._context, this._table, this._builder, this::isSqlExpr, this._usingNull, data);
        return this.compile();
    }

    public long insertBy(IDataItem data, String conditionFields) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0L;
        }
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this.where("1=1", new Object[0]);
        for (String f : ff) {
            this.andEq(f, data.get(f));
        }
        if (this.selectExists()) {
            return 0L;
        }
        return this.insert(data);
    }

    public boolean insertList(List<DataItem> valuesList) throws SQLException {
        if (valuesList == null) {
            return false;
        }
        return this.insertList(valuesList.get(0), valuesList);
    }

    public <T> boolean insertList(Collection<T> valuesList, Act2<T, DataItem> dataBuilder) throws SQLException {
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T values : valuesList) {
            DataItem item = new DataItem();
            dataBuilder.run(values, item);
            list2.add(item);
        }
        if (list2.size() > 0) {
            return this.insertList((IDataItem)list2.get(0), list2);
        }
        return false;
    }

    protected <T extends GetHandler> boolean insertList(IDataItem cols, Collection<T> valuesList) throws SQLException {
        if (valuesList == null || valuesList.size() == 0) {
            return false;
        }
        if (cols == null || cols.count() == 0) {
            return false;
        }
        this._builder.backup();
        this._context.getDialect().buildInsertOneCode(this._context, this._table, this._builder, this::isSqlExpr, true, cols);
        ArrayList<Object[]> argList = new ArrayList<Object[]>();
        String tml = this._builder.toString();
        for (GetHandler item : valuesList) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (String key : cols.keys()) {
                tmp.add(item.get(key));
            }
            argList.add(tmp.toArray());
        }
        this._builder.clear();
        this._builder.append(tml, argList.toArray());
        int[] rst = this.compile().executeBatch();
        this._builder.restore();
        return rst.length > 0;
    }

    @Deprecated
    public long upsert(IDataItem data, String conditionFields) throws SQLException {
        return this.upsertBy(data, conditionFields);
    }

    public long upsertBy(IDataItem data, String conditionFields) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0L;
        }
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this.where("1=1", new Object[0]);
        for (String f : ff) {
            this.andEq(f, data.get(f));
        }
        if (this.selectExists()) {
            for (String f : ff) {
                data.remove(f);
            }
            return this.update(data);
        }
        return this.insert(data);
    }

    public int updateBy(IDataItem data, String conditionFields) throws SQLException {
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this.whereTrue();
        for (String f : ff) {
            this.andEq(f, data.get(f));
        }
        return this.update(data);
    }

    public int update(Act1<IDataItem> dataBuilder) throws SQLException {
        DataItem item = new DataItem();
        dataBuilder.run(item);
        return this.update(item);
    }

    public int update(IDataItem data) throws SQLException {
        if (data == null || data.count() == 0) {
            return 0;
        }
        return this.updateCompile(data).execute();
    }

    public Command updateAsCmd(IDataItem data) {
        if (data == null || data.count() == 0) {
            return null;
        }
        return this.updateCompile(data).getCommand();
    }

    protected DbQuery updateCompile(IDataItem data) {
        ArrayList<Object> args = new ArrayList<Object>();
        StringBuilder sb = new StringBuilder();
        this._context.getDialect().updateCmd(sb, this._table);
        this.updateItemsBuild0(data, sb, args);
        this._builder.backup();
        this._builder.insert(sb.toString(), args.toArray());
        if (WoodConfig.isUpdateMustConditional && this._builder.indexOf(" WHERE ") < 0) {
            throw new RuntimeException("Lack of update condition!!!");
        }
        if (this.limit_top > 0 && (this.dbType() == DbType.MySQL || this.dbType() == DbType.MariaDB)) {
            this._builder.append(" LIMIT ?", this.limit_top);
        }
        DbQuery query = this.compile();
        this._builder.restore();
        return query;
    }

    private void updateItemsBuild0(IDataItem data, StringBuilder buf, List<Object> args) {
        data.forEach((key, value) -> {
            if (value == null) {
                if (this._usingNull) {
                    buf.append(this.fmtColumn((String)key)).append("=null,");
                }
                return;
            }
            if (value instanceof String) {
                String val2 = (String)value;
                if (this.isSqlExpr(val2)) {
                    buf.append(this.fmtColumn((String)key)).append("=").append(val2.substring(1)).append(",");
                } else {
                    buf.append(this.fmtColumn((String)key)).append("=?,");
                    args.add(value);
                }
            } else {
                buf.append(this.fmtColumn((String)key)).append("=?,");
                args.add(value);
            }
        });
        buf.deleteCharAt(buf.length() - 1);
    }

    private void updateItemsBuildByFields0(IDataItem data, StringBuilder buf) {
        data.forEach((key, value) -> buf.append(this.fmtColumn((String)key)).append("=?,"));
        buf.deleteCharAt(buf.length() - 1);
    }

    public int[] updateList(List<DataItem> valuesList, String conditionFields) throws SQLException {
        if (valuesList == null || valuesList.size() == 0) {
            return null;
        }
        return this.updateList(valuesList.get(0), valuesList, conditionFields);
    }

    public <T> int[] updateList(Collection<T> valuesList, Act2<T, DataItem> dataBuilder, String conditionFields) throws SQLException {
        if (valuesList == null || valuesList.size() == 0) {
            return null;
        }
        ArrayList<DataItem> list2 = new ArrayList<DataItem>();
        for (T values : valuesList) {
            DataItem item = new DataItem();
            dataBuilder.run(values, item);
            list2.add(item);
        }
        if (list2.size() > 0) {
            return this.updateList((IDataItem)list2.get(0), list2, conditionFields);
        }
        return null;
    }

    protected <T extends GetHandler> int[] updateList(IDataItem cols, Collection<T> valuesList, String conditionFields) throws SQLException {
        if (valuesList == null || valuesList.size() == 0) {
            return null;
        }
        if (cols == null || cols.count() == 0) {
            return null;
        }
        String[] ff = conditionFields.split(",");
        if (ff.length == 0) {
            throw new RuntimeException("Please enter constraints");
        }
        this._builder.backup();
        this.where("1=1", new Object[0]);
        for (String f : ff) {
            this.and(f + "=?", new Object[0]);
        }
        ArrayList<Object[]> argList = new ArrayList<Object[]>();
        StringBuilder sb = new StringBuilder();
        this._context.getDialect().updateCmd(sb, this._table);
        this.updateItemsBuildByFields0(cols, sb);
        for (GetHandler item : valuesList) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            for (String key : cols.keys()) {
                tmp.add(item.get(key));
            }
            for (String key : ff) {
                tmp.add(item.get(key));
            }
            argList.add(tmp.toArray());
        }
        this._builder.insert(sb.toString(), argList.toArray());
        int[] rst = this.compile().executeBatch();
        this._builder.restore();
        return rst;
    }

    public int delete() throws SQLException {
        return this.deleteCompile().execute();
    }

    public Command deleteAsCmd() {
        return this.deleteCompile().getCommand();
    }

    protected DbQuery deleteCompile() {
        StringBuilder sb = new StringBuilder();
        this._context.getDialect().deleteCmd(sb, this._table, this._builder.indexOf(" FROM ") < 0);
        this._builder.insert(sb.toString(), new Object[0]);
        if (this.limit_top > 0 && (this.dbType() == DbType.MySQL || this.dbType() == DbType.MariaDB)) {
            this._builder.append(" LIMIT ?", this.limit_top);
        }
        if (WoodConfig.isDeleteMustConditional && this._builder.indexOf(" WHERE ") < 0) {
            throw new RuntimeException("Lack of delete condition!!!");
        }
        return this.compile();
    }

    public T limit(int start, int size) {
        this.limit_start = start;
        this.limit_size = size;
        return (T)this;
    }

    public T limit(int size) {
        this.limit_top = size;
        return (T)this;
    }

    public T paging(int start, int size) {
        this.limit_start = start;
        this.limit_size = size;
        return (T)this;
    }

    public T top(int size) {
        this.limit_top = size;
        return (T)this;
    }

    public T hint(String hint) {
        this._hint = hint;
        return (T)this;
    }

    @Deprecated
    public boolean exists() throws SQLException {
        return this.selectExists();
    }

    @Deprecated
    public long count() throws SQLException {
        return this.selectCount();
    }

    @Deprecated
    public long count(String code) throws SQLException {
        return this.selectCount(code);
    }

    @Deprecated
    public IQuery select(String columns) {
        return this.selectDo(columns);
    }

    public Command selectAsCmd(String columns) {
        return this.selectCompile(columns).getCommand();
    }

    protected IQuery selectDo(String columns) {
        DbQuery rst = this.selectCompile(columns);
        if (this._cache != null) {
            rst.cache(this._cache);
        }
        return rst;
    }

    protected DbQuery selectCompile(String columns) {
        this.select_do(columns, true);
        DbQuery rst = this.compile();
        this._builder.restore();
        return rst;
    }

    public boolean selectExists() throws SQLException {
        int bak = this.limit_top;
        this.limit(1);
        this.select_do(" 1 ", false);
        this.limit(bak);
        DbQuery rst = this.compile();
        if (this._cache != null) {
            rst.cache(this._cache);
        }
        this._builder.restore();
        return rst.getValue() != null;
    }

    public long selectCount() throws SQLException {
        return this.selectCount("COUNT(*)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long selectCount(String column) throws SQLException {
        if (column.indexOf("(") < 0) {
            column = "COUNT(" + column + ")";
        }
        int limit_start_bak = this.limit_start;
        int limit_size_bak = this.limit_size;
        int limit_top_bak = this.limit_top;
        StringBuilder _orderBy_bak = this._orderBy;
        this.limit_start = 0;
        this.limit_size = 0;
        this.limit_top = 0;
        this._orderBy = null;
        try {
            long l = this.selectDo(column).getVariate().longValue(0L);
            return l;
        }
        finally {
            this.limit_start = limit_start_bak;
            this.limit_size = limit_size_bak;
            this.limit_top = limit_top_bak;
            this._orderBy = _orderBy_bak;
        }
    }

    public Variate selectVariate(String column) throws SQLException {
        return this.selectDo(column).getVariate();
    }

    public Object selectValue(String column) throws SQLException {
        return this.selectDo(column).getValue();
    }

    public <T> T selectValue(String column, T def) throws SQLException {
        return this.selectDo(column).getValue(def);
    }

    public <T> T selectItem(String columns, Class<T> clz) throws SQLException {
        return this.selectDo(columns).getItem(clz);
    }

    public <T> List<T> selectList(String columns, Class<T> clz) throws SQLException {
        return this.selectDo(columns).getList(clz);
    }

    public <T> IPage<T> selectPage(String columns, Class<T> clz) throws SQLException {
        long total = this.selectCount();
        List<T> list = this.selectDo(columns).getList(clz);
        return new IPageImpl<T>(list, total, this.limit_size);
    }

    public DataItem selectDataItem(String columns) throws SQLException {
        return this.selectDo(columns).getDataItem();
    }

    public DataList selectDataList(String columns) throws SQLException {
        return this.selectDo(columns).getDataList();
    }

    public IPage<DataItem> selectDataPage(String columns) throws SQLException {
        long total = this.selectCount();
        List<DataItem> list = this.selectDo(columns).getDataList().getRows();
        return new IPageImpl<DataItem>(list, total, this.limit_size);
    }

    public Map<String, Object> selectMap(String columns) throws SQLException {
        return this.selectDo(columns).getMap();
    }

    public List<Map<String, Object>> selectMapList(String columns) throws SQLException {
        return this.selectDo(columns).getMapList();
    }

    public IPage<Map<String, Object>> selectMapPage(String columns) throws SQLException {
        long total = this.selectCount();
        List<Map<String, Object>> list = this.selectDo(columns).getMapList();
        return new IPageImpl<Map<String, Object>>(list, total, this.limit_size);
    }

    public <T> List<T> selectArray(String column) throws SQLException {
        return this.selectDo(column).getArray();
    }

    public SelectQ selectQ(String columns) {
        this.select_do(columns, true);
        return new SelectQ(this._builder);
    }

    private void select_do(String columns, boolean doFormat) {
        this._builder.backup();
        StringBuilder sb = new StringBuilder(this._builder.builder.length() + 100);
        sb.append(" ");
        if (doFormat) {
            sb.append(this.fmtMutColumns(columns)).append(" FROM ").append(this._table);
        } else {
            sb.append(columns).append(" FROM ").append(this._table);
        }
        sb.append((CharSequence)this._builder.builder);
        this._builder.builder = sb;
        if (this.limit_top > 0) {
            this._context.getDialect().buildSelectTopCode(this._context, this._table_raw, this._builder, this._orderBy, this.limit_top);
        } else if (this.limit_size > 0) {
            this._context.getDialect().buildSelectRangeCode(this._context, this._table_raw, this._builder, this._orderBy, this.limit_start, this.limit_size);
        } else {
            this._builder.insert(0, (Object)"SELECT ");
            if (this._orderBy != null) {
                this._builder.append(this._orderBy);
            }
        }
        if (this._hint != null) {
            sb.append(this._hint);
            this._builder.insert(0, (Object)this._hint);
        }
        if (this._builder_bef.length() > 0) {
            this._builder.insert(this._builder_bef);
        }
    }

    private DbQuery compile() {
        DbQuery temp = new DbQuery(this._context).sql(this._builder);
        this._builder.clear();
        return (DbQuery)temp.onCommandBuilt(cmd -> {
            cmd.isLog = this._isLog;
            cmd.tag = this._table;
        });
    }

    protected boolean usingNull() {
        return this._usingNull;
    }

    public T usingNull(boolean isUsing) {
        this._usingNull = isUsing;
        return (T)this;
    }

    protected boolean usingExpr() {
        return this._usingExpression;
    }

    public T usingExpr(boolean isUsing) {
        this._usingExpression = isUsing;
        return (T)this;
    }

    private boolean isSqlExpr(String txt) {
        if (!this._usingExpression) {
            return false;
        }
        return txt.startsWith("$") && txt.indexOf(" ") < 0 && txt.length() < 100;
    }

    @Override
    public T caching(ICacheService service) {
        this._cache = new CacheUsing(service);
        return (T)this;
    }

    @Override
    public T usingCache(boolean isCache) {
        this._cache.usingCache(isCache);
        return (T)this;
    }

    @Override
    public T usingCache(int seconds) {
        this._cache.usingCache(seconds);
        return (T)this;
    }

    @Override
    public T cacheTag(String tag) {
        this._cache.cacheTag(tag);
        return (T)this;
    }
}

