/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.util.ArrayList;
import java.util.List;
import org.noear.wood.DbQuery;
import org.noear.wood.Variate;

public class SQLBuilder {
    public StringBuilder builder = new StringBuilder(200);
    public List<Object> paramS = new ArrayList<Object>();
    private StringBuilder b_builder = new StringBuilder();
    private List<Object> b_paramS = new ArrayList<Object>();

    public int indexOf(String str) {
        return this.builder.indexOf(str);
    }

    public void clear() {
        this.builder.delete(0, this.builder.length());
        this.paramS.clear();
    }

    protected void backup() {
        this.b_builder.append(this.builder.toString());
        this.b_paramS.addAll(this.paramS);
    }

    protected void restore() {
        this.clear();
        this.builder.append((CharSequence)this.b_builder);
        this.paramS.addAll(this.b_paramS);
    }

    public SQLBuilder insert(String code, Object ... args) {
        SQLPartBuilder pb = new SQLPartBuilder(code, args);
        this.builder.insert(0, pb.code);
        this.paramS.addAll(0, pb.paramS);
        return this;
    }

    public SQLBuilder insert(SQLBuilder part) {
        this.builder.insert(0, part.builder);
        this.paramS.addAll(0, part.paramS);
        return this;
    }

    public SQLBuilder insert(int offset, Object val) {
        this.builder.insert(offset, val);
        return this;
    }

    public SQLBuilder append(String code, Object ... args) {
        SQLPartBuilder pb = new SQLPartBuilder(code, args);
        this.builder.append(pb.code);
        this.paramS.addAll(pb.paramS);
        return this;
    }

    public SQLBuilder append(Object val) {
        this.builder.append(val);
        return this;
    }

    public SQLBuilder append(SQLBuilder part) {
        this.builder.append((CharSequence)part.builder);
        this.paramS.addAll(part.paramS);
        return this;
    }

    public SQLBuilder remove(int start, int length) {
        this.builder.delete(start, start + length);
        return this;
    }

    public SQLBuilder removeLast() {
        this.builder.setLength(this.builder.length() - 1);
        return this;
    }

    public SQLBuilder trimEnd(String str) {
        int len = str.length();
        if (len > 0) {
            int idx;
            String tmp = this.builder.toString().trim();
            while ((idx = tmp.lastIndexOf(str)) == tmp.length() - len) {
                tmp = tmp.substring(0, tmp.length() - len);
            }
            this.builder.setLength(0);
            this.builder.append(tmp);
        }
        return this;
    }

    public SQLBuilder trimStart(String str) {
        int len = str.length();
        if (len > 0) {
            int idx;
            String tmp = this.builder.toString().trim();
            while ((idx = tmp.indexOf(str)) == 0) {
                tmp = tmp.substring(len);
            }
            this.builder.setLength(0);
            this.builder.append(tmp);
        }
        return this;
    }

    public SQLBuilder addPrefix(String str) {
        return this.addPrefix(str, true);
    }

    public SQLBuilder addSuffix(String str) {
        return this.addSuffix(str, true);
    }

    public SQLBuilder addPrefix(String str, boolean allowEmpty) {
        if (allowEmpty) {
            this.builder.insert(0, str);
        } else if (this.builder.length() > 0) {
            this.builder.insert(0, str);
        }
        return this;
    }

    public SQLBuilder addSuffix(String str, boolean allowEmpty) {
        if (allowEmpty) {
            this.builder.append(str);
        } else if (this.builder.length() > 0) {
            this.builder.append(str);
        }
        return this;
    }

    public int length() {
        return this.builder.length();
    }

    public String toString() {
        return this.builder.toString();
    }

    protected class SQLPartBuilder {
        public String code;
        public List<Object> paramS = new ArrayList<Object>();

        public SQLPartBuilder(String code, Object[] args) {
            if (args != null && args.length > 0) {
                StringBuilder builder = new StringBuilder();
                builder.append(code);
                for (Object p1 : args) {
                    if (p1 instanceof Iterable) {
                        StringBuilder sb = new StringBuilder();
                        for (Object p2 : (Iterable)p1) {
                            this.paramS.add(p2);
                            sb.append("?").append(",");
                        }
                        int len = sb.length();
                        if (len > 0) {
                            sb.deleteCharAt(len - 1);
                        }
                        int idx = builder.indexOf("?...");
                        String tmp = sb.toString();
                        if (len == 0) {
                            builder.replace(idx, idx + 4, "null");
                            continue;
                        }
                        builder.replace(idx, idx + 4, tmp);
                        continue;
                    }
                    if (p1 instanceof DbQuery) {
                        DbQuery s1 = (DbQuery)p1;
                        for (Variate p2 : s1.paramS) {
                            this.paramS.add(p2.getValue());
                        }
                        int idx = builder.indexOf("?...");
                        if (s1.paramS.size() > 0) {
                            builder.replace(idx, idx + 4, s1.commandText);
                            continue;
                        }
                        builder.replace(idx, idx + 4, s1.commandText);
                        continue;
                    }
                    this.paramS.add(p1);
                }
                this.code = builder.toString();
            } else {
                this.code = code;
            }
        }
    }
}

