/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.dialect;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.noear.wood.DbContext;
import org.noear.wood.IDataItem;
import org.noear.wood.SQLBuilder;
import org.noear.wood.dialect.DbDialect;
import org.noear.wood.ext.Fun1;

public abstract class DbDialectBase
implements DbDialect {
    @Override
    public Object preChange(Object val) throws SQLException {
        return val;
    }

    @Override
    public String preReview(String code) {
        return code;
    }

    @Override
    public ResultSet getTables(DatabaseMetaData md, String catalog, String schema) throws SQLException {
        return md.getTables(catalog, schema, null, new String[]{"TABLE", "VIEW"});
    }

    @Override
    public boolean supportsVariablePaging() {
        return false;
    }

    @Override
    public boolean supportsInsertGeneratedKey() {
        return true;
    }

    @Override
    public boolean excludeFormat(String str) {
        return str.startsWith("`") || str.indexOf(".") > 0;
    }

    @Override
    public String schemaFormat(String name) {
        return name;
    }

    @Override
    public String tableFormat(String name) {
        return "`" + name + "`";
    }

    @Override
    public String columnFormat(String name) {
        return "`" + name + "`";
    }

    @Override
    public void buildSelectRangeCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int start, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" LIMIT ?,?");
            sqlB.paramS.add(start);
            sqlB.paramS.add(size);
        } else {
            sqlB.append(" LIMIT ").append(start).append(",").append(size);
        }
    }

    @Override
    public void buildSelectTopCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" LIMIT ?");
            sqlB.paramS.add(size);
        } else {
            sqlB.append(" LIMIT ").append(size);
        }
    }

    @Override
    public void buildInsertOneCode(DbContext ctx, String table1, SQLBuilder sqlB, Fun1<Boolean, String> isSqlExpr, boolean _usingNull, IDataItem values) {
        ArrayList args = new ArrayList();
        StringBuilder sb = new StringBuilder();
        this.insertCmd(sb, table1);
        sb.append(" (");
        values.forEach((key, value) -> {
            if (value == null && !_usingNull) {
                return;
            }
            sb.append(ctx.formater().formatColumn((String)key)).append(",");
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(") ");
        sb.append("VALUES");
        sb.append("(");
        values.forEach((key, value) -> {
            if (value == null) {
                if (_usingNull) {
                    sb.append("?,");
                    args.add(null);
                }
            } else if (value instanceof String) {
                String val2 = (String)value;
                if (((Boolean)isSqlExpr.run(val2)).booleanValue()) {
                    sb.append(val2.substring(1)).append(",");
                } else {
                    sb.append("?,");
                    args.add(value);
                }
            } else {
                sb.append("?,");
                args.add(value);
            }
        });
        sb.deleteCharAt(sb.length() - 1);
        sb.append(")");
        sqlB.append(sb.toString(), args.toArray());
    }

    @Override
    public void insertCmd(StringBuilder sb, String table1) {
        sb.append("INSERT INTO ").append(table1).append(" ");
    }

    @Override
    public void updateCmd(StringBuilder sb, String table1) {
        sb.append("UPDATE ").append(table1).append(" SET ");
    }

    @Override
    public void deleteCmd(StringBuilder sb, String table1, boolean addFrom) {
        sb.append("DELETE ");
        if (addFrom) {
            sb.append(" FROM ").append(table1);
        } else {
            sb.append(table1);
        }
        sb.append(" ");
    }
}

