/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.dialect;

import java.sql.Clob;
import java.sql.SQLException;
import org.noear.wood.DbContext;
import org.noear.wood.SQLBuilder;
import org.noear.wood.dialect.DbDialectBase;

public class DbOracleDialect
extends DbDialectBase {
    @Override
    public Object preChange(Object val) throws SQLException {
        if (val instanceof Clob) {
            Clob clob = (Clob)val;
            return clob.getSubString(1L, (int)clob.length());
        }
        return val;
    }

    @Override
    public boolean excludeFormat(String str) {
        return str.startsWith("\"");
    }

    @Override
    public String schemaFormat(String sc) {
        return "\"" + sc + "\"";
    }

    @Override
    public String tableFormat(String tb) {
        String[] ss = tb.split("\\.");
        if (ss.length > 1) {
            return "\"" + ss[0] + "\".\"" + ss[1].toUpperCase() + "\"";
        }
        return "\"" + ss[0].toUpperCase() + "\"";
    }

    @Override
    public String columnFormat(String col) {
        String[] ss = col.split("\\.");
        if (ss.length > 1) {
            if ("*".equals(ss[1])) {
                return "\"" + ss[0].toUpperCase() + "\".*";
            }
            return "\"" + ss[0] + "\".\"" + ss[1].toUpperCase() + "\"";
        }
        return "\"" + ss[0].toUpperCase() + "\"";
    }

    @Override
    public boolean supportsVariablePaging() {
        return true;
    }

    @Override
    public void buildSelectRangeCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int start, int size) {
        sqlB.insert(0, (Object)"SELECT t.* FROM (SELECT ROWNUM WD3_ROW_NUM,x.* FROM (SELECT ");
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(") x  WHERE ROWNUM<=?");
            sqlB.append(") t WHERE t.WD3_ROW_NUM >?");
            sqlB.paramS.add(start + size);
            sqlB.paramS.add(start);
        } else {
            sqlB.append(") x  WHERE ROWNUM<=").append(start + size);
            sqlB.append(") t WHERE t.WD3_ROW_NUM >").append(start);
        }
    }

    @Override
    public void buildSelectTopCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int size) {
        sqlB.insert(0, (Object)"SELECT ");
        if (sqlB.indexOf(" WHERE ") > 0) {
            sqlB.append(" AND");
        } else {
            sqlB.append(" WHERE");
        }
        if (this.supportsVariablePaging()) {
            sqlB.append(" ROWNUM <= ?");
            sqlB.paramS.add(size);
        } else {
            sqlB.append(" ROWNUM <= ").append(size);
        }
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
    }
}

