/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.dialect;

import org.noear.wood.DbContext;
import org.noear.wood.SQLBuilder;
import org.noear.wood.dialect.DbDialectBase;

public class DbSQLServerDialect
extends DbDialectBase {
    @Override
    public boolean excludeFormat(String str) {
        return str.startsWith("\"") || str.startsWith("[") || str.indexOf(".") > 0;
    }

    @Override
    public String tableFormat(String tb) {
        return "[" + tb + "]";
    }

    @Override
    public String columnFormat(String col) {
        return "[" + col + "]";
    }

    @Override
    public void buildSelectRangeCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int start, int size) {
        StringBuilder sb = new StringBuilder();
        if (orderBy == null) {
            String tb = table1.split(" ")[0].replace("$.", "").trim();
            String pk = ctx.getMetaData().getTablePk1(tb);
            if (pk == null) {
                throw new RuntimeException("Please add orderBy");
            }
            sb.append("SELECT ROW_NUMBER() OVER(ORDER BY ").append(pk).append(") AS _ROW_NUM, ");
        } else {
            sb.append("SELECT ROW_NUMBER() OVER(").append((CharSequence)orderBy).append(") AS _ROW_NUM, ");
        }
        sqlB.insert(0, (Object)sb);
        StringBuilder sb2 = new StringBuilder();
        sb2.append("SELECT _x.* FROM (").append((CharSequence)sqlB.builder).append(") _x ");
        sb2.append(" WHERE _x._ROW_NUM BETWEEN ").append(start + 1).append(" AND ").append(start + size);
        sqlB.builder = sb2;
    }

    @Override
    public void buildSelectTopCode(DbContext ctx, String table1, SQLBuilder sqlB, StringBuilder orderBy, int size) {
        sqlB.insert(0, (Object)("SELECT TOP " + size));
        if (orderBy != null) {
            sqlB.append(orderBy);
        }
    }
}

