/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.h2gis.api.ProgressVisitor;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.noise_planet.noisemodelling.jdbc.input.DefaultTableLoader;
import org.noise_planet.noisemodelling.jdbc.utils.CellIndex;

public abstract class GridMapMaker {
    protected static final double MINIMAL_BUFFER_RATIO = 0.3;
    protected DefaultTableLoader.BuildingTableParameters buildingTableParameters = new DefaultTableLoader.BuildingTableParameters();
    protected final String sourcesTableName;
    protected String soilTableName = "";
    protected String demTable = "";
    protected String sound_lvl_field = "DB_M";
    protected boolean receiverHasAbsoluteZCoordinates = false;
    protected boolean sourceHasAbsoluteZCoordinates = false;
    protected double maximumPropagationDistance = 750.0;
    protected double maximumReflectionDistance = 100.0;
    protected double gs = 0.0;
    protected double groundSurfaceSplitSideLength = 200.0;
    protected int soundReflectionOrder = 2;
    protected boolean bodyBarrier = false;
    public boolean verbose = true;
    protected boolean computeHorizontalDiffraction = true;
    protected boolean computeVerticalDiffraction = true;
    protected GeometryFactory geometryFactory;
    protected int gridDim = 0;
    protected Envelope mainEnvelope = new Envelope();

    public GridMapMaker(String buildingsTableName, String sourcesTableName) {
        this.buildingTableParameters.buildingsTableName = buildingsTableName;
        this.sourcesTableName = sourcesTableName;
    }

    public DefaultTableLoader.BuildingTableParameters getBuildingTableParameters() {
        return this.buildingTableParameters;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public Envelope getCellEnv(CellIndex cellIndex) {
        return GridMapMaker.getCellEnv(this.mainEnvelope, cellIndex.getLatitudeIndex(), cellIndex.getLongitudeIndex(), this.getCellWidth(), this.getCellHeight());
    }

    public static Envelope getCellEnv(Envelope mainEnvelope, int cellI, int cellJ, double cellWidth, double cellHeight) {
        return new Envelope(mainEnvelope.getMinX() + (double)cellI * cellWidth, mainEnvelope.getMinX() + (double)cellI * cellWidth + cellWidth, mainEnvelope.getMinY() + cellHeight * (double)cellJ, mainEnvelope.getMinY() + cellHeight * (double)cellJ + cellHeight);
    }

    public double getGroundSurfaceSplitSideLength() {
        return this.groundSurfaceSplitSideLength;
    }

    public void setGroundSurfaceSplitSideLength(double groundSurfaceSplitSideLength) {
        this.groundSurfaceSplitSideLength = groundSurfaceSplitSideLength;
    }

    public void setBodyBarrier(boolean bodyBarrier) {
        this.bodyBarrier = bodyBarrier;
    }

    public double getCellWidth() {
        return this.mainEnvelope.getWidth() / (double)this.gridDim;
    }

    public double getCellHeight() {
        return this.mainEnvelope.getHeight() / (double)this.gridDim;
    }

    protected abstract Envelope getComputationEnvelope(Connection var1) throws SQLException;

    public void initialize(Connection connection, ProgressVisitor progression) throws SQLException {
        if (this.soundReflectionOrder > 0 && this.maximumPropagationDistance < this.maximumReflectionDistance) {
            throw new SQLException(new IllegalArgumentException("Maximum wall seeking distance cannot be superior than maximum propagation distance"));
        }
        int srid = 0;
        DBTypes dbTypes = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        if (!this.sourcesTableName.isEmpty()) {
            srid = GeometryTableUtilities.getSRID((Connection)connection, (TableLocation)TableLocation.parse((String)this.sourcesTableName, (DBTypes)dbTypes));
        }
        if (srid == 0) {
            srid = GeometryTableUtilities.getSRID((Connection)connection, (TableLocation)TableLocation.parse((String)this.buildingTableParameters.buildingsTableName, (DBTypes)dbTypes));
        }
        this.geometryFactory = new GeometryFactory(new PrecisionModel(), srid);
        if (this.mainEnvelope.isNull()) {
            this.setMainEnvelope(this.getComputationEnvelope(connection));
        }
    }

    public int getGridDim() {
        return this.gridDim;
    }

    public void setGridDim(int gridDim) {
        this.gridDim = gridDim;
    }

    public String getBuildingsTableName() {
        return this.buildingTableParameters.buildingsTableName;
    }

    public String getSourcesTableName() {
        return this.sourcesTableName;
    }

    public String getSoilTableName() {
        return this.soilTableName;
    }

    public boolean isReceiverHasAbsoluteZCoordinates() {
        return this.receiverHasAbsoluteZCoordinates;
    }

    public void setReceiverHasAbsoluteZCoordinates(boolean receiverHasAbsoluteZCoordinates) {
        this.receiverHasAbsoluteZCoordinates = receiverHasAbsoluteZCoordinates;
    }

    public boolean isSourceHasAbsoluteZCoordinates() {
        return this.sourceHasAbsoluteZCoordinates;
    }

    public void setSourceHasAbsoluteZCoordinates(boolean sourceHasAbsoluteZCoordinates) {
        this.sourceHasAbsoluteZCoordinates = sourceHasAbsoluteZCoordinates;
    }

    public boolean iszBuildings() {
        return this.buildingTableParameters.zBuildings;
    }

    public void setzBuildings(boolean zBuildings) {
        this.buildingTableParameters.zBuildings = zBuildings;
    }

    public void setSoilTableName(String soilTableName) {
        this.soilTableName = soilTableName;
    }

    public String getDemTable() {
        return this.demTable;
    }

    public void setDemTable(String demTable) {
        this.demTable = demTable;
    }

    public String getSound_lvl_field() {
        return this.sound_lvl_field;
    }

    public void setSound_lvl_field(String sound_lvl_field) {
        this.sound_lvl_field = sound_lvl_field;
    }

    public double getMaximumPropagationDistance() {
        return this.maximumPropagationDistance;
    }

    public void setMaximumPropagationDistance(double maximumPropagationDistance) {
        this.maximumPropagationDistance = maximumPropagationDistance;
    }

    public void setGs(double gs) {
        this.gs = gs;
    }

    public double getGs() {
        return this.gs;
    }

    public double getMaximumReflectionDistance() {
        return this.maximumReflectionDistance;
    }

    public void setMaximumReflectionDistance(double maximumReflectionDistance) {
        this.maximumReflectionDistance = maximumReflectionDistance;
    }

    public int getSoundReflectionOrder() {
        return this.soundReflectionOrder;
    }

    public void setSoundReflectionOrder(int soundReflectionOrder) {
        this.soundReflectionOrder = soundReflectionOrder;
    }

    public boolean isComputeHorizontalDiffraction() {
        return this.computeHorizontalDiffraction;
    }

    public void setComputeHorizontalDiffraction(boolean computeHorizontalDiffraction) {
        this.computeHorizontalDiffraction = computeHorizontalDiffraction;
    }

    public double getWallAbsorption() {
        return this.buildingTableParameters.defaultWallAbsorption;
    }

    public void setWallAbsorption(double wallAbsorption) {
        this.buildingTableParameters.defaultWallAbsorption = wallAbsorption;
    }

    public String getHeightField() {
        return this.buildingTableParameters.heightField;
    }

    public void setHeightField(String heightField) {
        this.buildingTableParameters.heightField = heightField;
    }

    public Envelope getMainEnvelope() {
        return this.mainEnvelope;
    }

    public void setMainEnvelope(Envelope mainEnvelope) {
        this.mainEnvelope = mainEnvelope;
        if (this.gridDim == 0) {
            double greatestSideLength = mainEnvelope.maxExtent();
            int subdivisionLevel = 0;
            while (this.maximumPropagationDistance / (greatestSideLength / Math.pow(2.0, subdivisionLevel)) < 0.3) {
                ++subdivisionLevel;
            }
            this.gridDim = (int)Math.pow(2.0, subdivisionLevel);
        }
    }

    public boolean isComputeVerticalDiffraction() {
        return this.computeVerticalDiffraction;
    }

    public void setComputeVerticalDiffraction(boolean computeVerticalDiffraction) {
        this.computeVerticalDiffraction = computeVerticalDiffraction;
    }
}

