/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.jdbc.input;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.h2gis.utilities.GeometryTableUtilities;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.h2gis.utilities.TableLocation;
import org.h2gis.utilities.Tuple;
import org.h2gis.utilities.dbtypes.DBTypes;
import org.h2gis.utilities.dbtypes.DBUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.prep.PreparedPolygon;
import org.locationtech.jts.io.WKTWriter;
import org.noise_planet.noisemodelling.emission.LineSource;
import org.noise_planet.noisemodelling.emission.directivity.DirectivityRecord;
import org.noise_planet.noisemodelling.emission.directivity.DirectivitySphere;
import org.noise_planet.noisemodelling.emission.directivity.DiscreteDirectivitySphere;
import org.noise_planet.noisemodelling.emission.directivity.OmnidirectionalDirection;
import org.noise_planet.noisemodelling.emission.directivity.cnossos.RailwayCnossosDirectivitySphere;
import org.noise_planet.noisemodelling.emission.railway.cnossos.RailWayCnossosParameters;
import org.noise_planet.noisemodelling.jdbc.EmissionTableGenerator;
import org.noise_planet.noisemodelling.jdbc.NoiseMapByReceiverMaker;
import org.noise_planet.noisemodelling.jdbc.input.SceneDatabaseInputSettings;
import org.noise_planet.noisemodelling.jdbc.input.SceneWithEmission;
import org.noise_planet.noisemodelling.jdbc.utils.CellIndex;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Building;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.Wall;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultTableLoader
implements NoiseMapByReceiverMaker.TableLoader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DefaultTableLoader.class);
    NoiseMapByReceiverMaker noiseMapByReceiverMaker;
    protected double groundSurfaceSplitSideLength = 200.0;
    public List<Integer> frequencyArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((int[])ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE));
    public List<Double> exactFrequencyArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((Double[])ProfileBuilder.DEFAULT_FREQUENCIES_EXACT_THIRD_OCTAVE));
    public List<Double> aWeightingArray = Arrays.asList(AcousticIndicatorsFunctions.asOctaveBands((Double[])ProfileBuilder.DEFAULT_FREQUENCIES_A_WEIGHTING_THIRD_OCTAVE));
    public Map<String, AttenuationParameters> cnossosParametersPerPeriod = new HashMap<String, AttenuationParameters>();
    public AttenuationParameters defaultParameters = new AttenuationParameters();
    public static final int DEFAULT_FETCH_SIZE = 300;
    protected int fetchSize = 300;
    public Map<Integer, DirectivitySphere> directionAttributes = new HashMap<Integer, DirectivitySphere>();

    public void insertTrainDirectivity() {
        this.directionAttributes.clear();
        this.directionAttributes.put(0, (DirectivitySphere)new OmnidirectionalDirection());
        int i = 1;
        for (String typeSource : RailWayCnossosParameters.sourceType) {
            this.directionAttributes.put(i, (DirectivitySphere)new RailwayCnossosDirectivitySphere(new LineSource(typeSource)));
            ++i;
        }
    }

    @Override
    public void initialize(Connection connection, NoiseMapByReceiverMaker noiseMapByReceiverMaker) throws SQLException {
        List sourceFields;
        this.noiseMapByReceiverMaker = noiseMapByReceiverMaker;
        SceneDatabaseInputSettings inputSettings = noiseMapByReceiverMaker.getSceneInputSettings();
        if (inputSettings.inputMode == SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_GUESS) {
            inputSettings.inputMode = SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_ATTENUATION;
            if (!inputSettings.sourcesEmissionTableName.isEmpty()) {
                sourceFields = JDBCUtilities.getColumnNames((Connection)connection, (String)noiseMapByReceiverMaker.getSourcesEmissionTableName());
                inputSettings.inputMode = sourceFields.contains("LV_SPD") ? SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_TRAFFIC_FLOW : SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_LW;
            } else {
                sourceFields = JDBCUtilities.getColumnNames((Connection)connection, (String)noiseMapByReceiverMaker.getSourcesTableName());
                for (EmissionTableGenerator.STANDARD_PERIOD period : EmissionTableGenerator.STANDARD_PERIOD.values()) {
                    String periodFieldName = EmissionTableGenerator.STANDARD_PERIOD_VALUE[period.ordinal()];
                    List<Integer> frequencyValues = DefaultTableLoader.readFrequenciesFromLwTable(noiseMapByReceiverMaker.getFrequencyFieldPrepend() + periodFieldName, sourceFields);
                    if (!frequencyValues.isEmpty()) {
                        inputSettings.inputMode = SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_LW_DEN;
                        break;
                    }
                    if (!sourceFields.contains("LV_SPD_" + periodFieldName)) continue;
                    inputSettings.inputMode = SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_TRAFFIC_FLOW_DEN;
                    break;
                }
            }
        }
        if (inputSettings.inputMode == SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_LW) {
            List sourceField = JDBCUtilities.getColumnNames((Connection)connection, (String)noiseMapByReceiverMaker.getSourcesEmissionTableName());
            List<Integer> frequencyValues = DefaultTableLoader.readFrequenciesFromLwTable(noiseMapByReceiverMaker.getFrequencyFieldPrepend(), sourceField);
            if (frequencyValues.isEmpty()) {
                throw new SQLException("Source emission table " + noiseMapByReceiverMaker.getSourcesTableName() + " does not contains any frequency bands");
            }
            this.frequencyArray = new ArrayList<Integer>(frequencyValues);
            this.exactFrequencyArray = new ArrayList<Double>();
            this.aWeightingArray = new ArrayList<Double>();
            ProfileBuilder.initializeFrequencyArrayFromReference(this.frequencyArray, this.exactFrequencyArray, this.aWeightingArray);
        } else if (inputSettings.inputMode == SceneDatabaseInputSettings.INPUT_MODE.INPUT_MODE_LW_DEN) {
            sourceFields = JDBCUtilities.getColumnNames((Connection)connection, (String)noiseMapByReceiverMaker.getSourcesTableName());
            HashSet<Integer> frequencySet = new HashSet<Integer>();
            for (EmissionTableGenerator.STANDARD_PERIOD period : EmissionTableGenerator.STANDARD_PERIOD.values()) {
                String periodFieldName = EmissionTableGenerator.STANDARD_PERIOD_VALUE[period.ordinal()];
                frequencySet.addAll(DefaultTableLoader.readFrequenciesFromLwTable(noiseMapByReceiverMaker.getFrequencyFieldPrepend() + periodFieldName, sourceFields));
            }
            this.frequencyArray = new ArrayList<Integer>(frequencySet);
            this.exactFrequencyArray = new ArrayList<Double>();
            this.aWeightingArray = new ArrayList<Double>();
            ProfileBuilder.initializeFrequencyArrayFromReference(this.frequencyArray, this.exactFrequencyArray, this.aWeightingArray);
        }
        this.defaultParameters.setFrequencies(this.frequencyArray);
        if (!inputSettings.periodAtmosphericSettingsTableName.isEmpty()) {
            this.loadAtmosphericTableSettings(connection, inputSettings.periodAtmosphericSettingsTableName);
        }
        for (AttenuationParameters parameters : this.cnossosParametersPerPeriod.values()) {
            parameters.setFrequencies(this.frequencyArray);
        }
        if (inputSettings.useTrainDirectivity) {
            this.insertTrainDirectivity();
        } else if (!inputSettings.directivityTableName.isEmpty()) {
            this.directionAttributes = DefaultTableLoader.fetchDirectivity(connection, inputSettings.directivityTableName, 1, noiseMapByReceiverMaker.getFrequencyFieldPrepend());
            if (noiseMapByReceiverMaker.isVerbose()) {
                LOGGER.info("Loaded {} directivities from the database", (Object)this.directionAttributes.size());
            }
        }
    }

    private void loadAtmosphericTableSettings(Connection connection, String atmosphericSettingsTableName) throws SQLException {
        String query = "SELECT * FROM " + atmosphericSettingsTableName;
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(query);){
            while (resultSet.next()) {
                AttenuationParameters.readFromDatabase((ResultSet)resultSet, this.cnossosParametersPerPeriod);
            }
        }
    }

    public List<Integer> getFrequencyArray() {
        return this.frequencyArray;
    }

    public List<Double> getExactFrequencyArray() {
        return this.exactFrequencyArray;
    }

    public List<Double> getaWeightingArray() {
        return this.aWeightingArray;
    }

    public Map<String, AttenuationParameters> getCnossosParametersPerPeriod() {
        return this.cnossosParametersPerPeriod;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public Map<Integer, DirectivitySphere> getDirectionAttributes() {
        return this.directionAttributes;
    }

    private static List<Integer> readFrequenciesFromLwTable(String frequencyPrepend, List<String> sourceField) throws SQLException {
        ArrayList<Integer> frequencyValues = new ArrayList<Integer>();
        for (String fieldName : sourceField) {
            if (!fieldName.toUpperCase(Locale.ROOT).startsWith(frequencyPrepend)) continue;
            try {
                int freq = Integer.parseInt(fieldName.substring(frequencyPrepend.length()));
                int index = Arrays.binarySearch(ProfileBuilder.DEFAULT_FREQUENCIES_THIRD_OCTAVE, freq);
                if (index < 0) continue;
                frequencyValues.add(freq);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return frequencyValues;
    }

    @Override
    public SceneWithEmission create(Connection connection, CellIndex cellIndex, Set<Long> skipReceivers) throws SQLException {
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        GeometryFactory geometryFactory = this.noiseMapByReceiverMaker.getGeometryFactory();
        Envelope cellEnvelope = this.noiseMapByReceiverMaker.getCellEnv(cellIndex);
        Envelope expandedCellEnvelop = new Envelope(cellEnvelope);
        double maximumPropagationDistance = this.noiseMapByReceiverMaker.getMaximumPropagationDistance();
        double maximumReflectionDistance = this.noiseMapByReceiverMaker.getMaximumReflectionDistance();
        expandedCellEnvelop.expandBy(maximumPropagationDistance + 2.0 * maximumReflectionDistance);
        ProfileBuilder profileBuilder = new ProfileBuilder();
        profileBuilder.setFrequencyArray(this.frequencyArray);
        SceneWithEmission scene = new SceneWithEmission(profileBuilder, this.noiseMapByReceiverMaker.getSceneInputSettings());
        scene.setDirectionAttributes(this.directionAttributes);
        scene.cnossosParametersPerPeriod = this.cnossosParametersPerPeriod;
        scene.defaultCnossosParameters = this.defaultParameters;
        scene.periodSet.addAll(this.cnossosParametersPerPeriod.keySet());
        DefaultTableLoader.fetchCellBuildings(connection, this.noiseMapByReceiverMaker.getBuildingTableParameters(), expandedCellEnvelop, scene.profileBuilder, geometryFactory);
        this.fetchCellDem(connection, expandedCellEnvelop, scene.profileBuilder);
        this.fetchCellSoilAreas(connection, expandedCellEnvelop, scene.profileBuilder);
        scene.profileBuilder.finishFeeding();
        scene.reflexionOrder = this.noiseMapByReceiverMaker.getSoundReflectionOrder();
        scene.setBodyBarrier(this.noiseMapByReceiverMaker.isBodyBarrier());
        scene.maxRefDist = maximumReflectionDistance;
        scene.maxSrcDist = maximumPropagationDistance;
        scene.setComputeVerticalDiffraction(this.noiseMapByReceiverMaker.isComputeVerticalDiffraction());
        scene.setComputeHorizontalDiffraction(this.noiseMapByReceiverMaker.isComputeHorizontalDiffraction());
        this.fetchCellSource(connection, expandedCellEnvelop, scene, true);
        String receiverTableName = this.noiseMapByReceiverMaker.getReceiverTableName();
        String receiverGeomName = (String)GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)receiverTableName)).get(0);
        int intPk = JDBCUtilities.getIntegerPrimaryKey((Connection)connection.unwrap(Connection.class), (TableLocation)TableLocation.parse((String)receiverTableName, (DBTypes)dbType));
        Object pkSelect = "";
        if (intPk < 1) {
            throw new SQLException(String.format("Table %s missing primary key for receiver identification", receiverTableName));
        }
        pkSelect = ", " + TableLocation.quoteIdentifier((String)JDBCUtilities.getColumnName((Connection)connection, (String)receiverTableName, (int)intPk), (DBTypes)dbType);
        try (PreparedStatement st = connection.prepareStatement("SELECT " + TableLocation.quoteIdentifier((String)receiverGeomName, (DBTypes)dbType) + (String)pkSelect + " FROM " + receiverTableName + " WHERE " + TableLocation.quoteIdentifier((String)receiverGeomName, (DBTypes)dbType) + " && ?::geometry");){
            st.setObject(1, geometryFactory.toGeometry(cellEnvelope));
            try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                while (rs.next()) {
                    long receiverPk = rs.getLong(2);
                    if (skipReceivers.contains(receiverPk)) continue;
                    skipReceivers.add(receiverPk);
                    Geometry pt = rs.getGeometry();
                    if (pt == null || pt.isEmpty()) continue;
                    if (pt.getCoordinate().getZ() == Double.NaN) {
                        throw new IllegalArgumentException("The table " + receiverTableName + " contain at least one receiver without Z ordinate. You must specify X,Y,Z for each receiver");
                    }
                    scene.addReceiver(receiverPk, pt.getCoordinate(), rs);
                }
            }
        }
        return scene;
    }

    public static Map<Integer, DirectivitySphere> fetchDirectivity(Connection connection, String tableName, int defaultInterpolation, String frequencyFieldPrepend) throws SQLException {
        HashMap<Integer, DirectivitySphere> directionAttributes = new HashMap<Integer, DirectivitySphere>();
        List fields = JDBCUtilities.getColumnNames((Connection)connection, (String)tableName);
        ArrayList<String> frequenciesFields = new ArrayList<String>();
        for (String field : fields) {
            if (!field.toUpperCase(Locale.ROOT).startsWith(frequencyFieldPrepend)) continue;
            try {
                double frequency = Double.parseDouble(field.substring(frequencyFieldPrepend.length()));
                if (!(frequency > 0.0)) continue;
                frequenciesFields.add(field);
            }
            catch (NumberFormatException frequency) {}
        }
        if (frequenciesFields.isEmpty()) {
            return directionAttributes;
        }
        double[] frequencies = new double[frequenciesFields.size()];
        for (int idFrequency = 0; idFrequency < frequencies.length; ++idFrequency) {
            frequencies[idFrequency] = Double.parseDouble(((String)frequenciesFields.get(idFrequency)).substring(2));
        }
        StringBuilder sb = new StringBuilder("SELECT DIR_ID, THETA, PHI");
        for (String frequency : frequenciesFields) {
            sb.append(", ");
            sb.append(frequency);
        }
        sb.append(" FROM ");
        sb.append(tableName);
        sb.append(" ORDER BY DIR_ID");
        try (Statement st = connection.createStatement();
             ResultSet rs = st.executeQuery(sb.toString());){
            ArrayList<DirectivityRecord> rows = new ArrayList<DirectivityRecord>();
            int lastDirId = Integer.MIN_VALUE;
            while (rs.next()) {
                int dirId = rs.getInt(1);
                if (lastDirId != dirId && !rows.isEmpty()) {
                    DiscreteDirectivitySphere attributes = new DiscreteDirectivitySphere(lastDirId, frequencies);
                    attributes.setInterpolationMethod(defaultInterpolation);
                    attributes.addDirectivityRecords(rows);
                    directionAttributes.put(lastDirId, (DirectivitySphere)attributes);
                    rows.clear();
                }
                lastDirId = dirId;
                double theta = Math.toRadians(rs.getDouble(2));
                double phi = Math.toRadians(rs.getDouble(3));
                double[] att = new double[frequencies.length];
                for (int freqColumn = 0; freqColumn < frequencies.length; ++freqColumn) {
                    att[freqColumn] = rs.getDouble(freqColumn + 4);
                }
                DirectivityRecord r = new DirectivityRecord(theta, phi, att);
                rows.add(r);
            }
            if (!rows.isEmpty()) {
                DiscreteDirectivitySphere attributes = new DiscreteDirectivitySphere(lastDirId, frequencies);
                attributes.setInterpolationMethod(defaultInterpolation);
                attributes.addDirectivityRecords(rows);
                directionAttributes.put(lastDirId, (DirectivitySphere)attributes);
            }
        }
        return directionAttributes;
    }

    public static void fetchCellBuildings(Connection connection, BuildingTableParameters buildingTableParameters, Envelope fetchEnvelope, ProfileBuilder builder, GeometryFactory geometryFactory) throws SQLException {
        LinkedList<Building> buildings = new LinkedList<Building>();
        LinkedList<Wall> walls = new LinkedList<Wall>();
        DefaultTableLoader.fetchCellBuildings(connection, buildingTableParameters, fetchEnvelope, buildings, walls, geometryFactory);
        for (Building building : buildings) {
            builder.addBuilding(building);
        }
        for (Wall wall : walls) {
            builder.addWall(wall);
        }
    }

    public static void fetchCellBuildings(Connection connection, BuildingTableParameters buildingTableParameters, Envelope fetchEnvelope, List<Building> buildings, List<Wall> walls, GeometryFactory geometryFactory) throws SQLException {
        Geometry envGeo = geometryFactory.toGeometry(fetchEnvelope);
        boolean fetchAlpha = JDBCUtilities.hasField((Connection)connection, (String)buildingTableParameters.buildingsTableName, (String)buildingTableParameters.alphaFieldName);
        Object additionalQuery = "";
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        if (!buildingTableParameters.heightField.isEmpty()) {
            additionalQuery = (String)additionalQuery + ", " + TableLocation.quoteIdentifier((String)buildingTableParameters.heightField, (DBTypes)dbType);
        }
        if (fetchAlpha) {
            additionalQuery = (String)additionalQuery + ", " + buildingTableParameters.alphaFieldName;
        }
        String pkBuilding = "";
        int indexPk = JDBCUtilities.getIntegerPrimaryKey((Connection)connection.unwrap(Connection.class), (TableLocation)new TableLocation(buildingTableParameters.buildingsTableName, dbType));
        if (indexPk > 0) {
            pkBuilding = JDBCUtilities.getColumnName((Connection)connection, (String)buildingTableParameters.buildingsTableName, (int)indexPk);
            additionalQuery = (String)additionalQuery + ", " + pkBuilding;
        }
        String buildingGeomName = (String)GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)buildingTableParameters.buildingsTableName, (DBTypes)dbType)).get(0);
        try (PreparedStatement st = connection.prepareStatement("SELECT " + TableLocation.quoteIdentifier((String)buildingGeomName) + (String)additionalQuery + " FROM " + buildingTableParameters.buildingsTableName + " WHERE " + TableLocation.quoteIdentifier((String)buildingGeomName, (DBTypes)dbType) + " && ?::geometry");){
            st.setObject(1, geometryFactory.toGeometry(fetchEnvelope));
            try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                int columnIndex = 0;
                if (!pkBuilding.isEmpty()) {
                    columnIndex = JDBCUtilities.getFieldIndex((ResultSetMetaData)rs.getMetaData(), (String)pkBuilding);
                }
                double oldAlpha = buildingTableParameters.defaultWallAbsorption;
                while (rs.next()) {
                    Geometry building = rs.getGeometry();
                    if (building == null) continue;
                    Geometry intersectedGeometry = null;
                    try {
                        intersectedGeometry = building.intersection(envGeo);
                    }
                    catch (TopologyException ex) {
                        WKTWriter wktWriter = new WKTWriter(3);
                        LOGGER.error(String.format("Error with input buildings geometry\n%s\n%s", wktWriter.write(building), wktWriter.write(envGeo)), (Throwable)ex);
                    }
                    if (!(intersectedGeometry instanceof Polygon) && !(intersectedGeometry instanceof MultiPolygon) && !(intersectedGeometry instanceof LineString)) continue;
                    if (fetchAlpha) {
                        oldAlpha = rs.getDouble(buildingTableParameters.alphaFieldName);
                    }
                    long pk = -1L;
                    if (columnIndex != 0) {
                        pk = rs.getLong(columnIndex);
                    }
                    for (int i = 0; i < intersectedGeometry.getNumGeometries(); ++i) {
                        Geometry geometry = intersectedGeometry.getGeometryN(i);
                        if (geometry instanceof Polygon && !geometry.isEmpty()) {
                            Building poly = new Building((Polygon)geometry, buildingTableParameters.heightField.isEmpty() ? Double.MAX_VALUE : rs.getDouble(buildingTableParameters.heightField), oldAlpha, pk, buildingTableParameters.zBuildings);
                            buildings.add(poly);
                            continue;
                        }
                        if (!(geometry instanceof LineString)) continue;
                        LineString lineString = (LineString)geometry;
                        Coordinate[] coordinates = lineString.getCoordinates();
                        for (int vertex = 0; vertex < coordinates.length - 1; ++vertex) {
                            Wall wall = new Wall(new LineSegment(coordinates[vertex], coordinates[vertex + 1]), -1, ProfileBuilder.IntersectionType.WALL);
                            wall.setG(oldAlpha);
                            wall.setPrimaryKey(pk);
                            wall.setHeight(buildingTableParameters.heightField.isEmpty() ? Double.MAX_VALUE : rs.getDouble(buildingTableParameters.heightField));
                            walls.add(wall);
                        }
                    }
                }
            }
        }
    }

    protected void fetchCellDem(Connection connection, Envelope fetchEnvelope, ProfileBuilder profileBuilder) throws SQLException {
        String demTable = this.noiseMapByReceiverMaker.getDemTable();
        if (!demTable.isEmpty()) {
            GeometryFactory geometryFactory = this.noiseMapByReceiverMaker.getGeometryFactory();
            DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
            List geomFields = GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)demTable, (DBTypes)dbType));
            if (geomFields.isEmpty()) {
                throw new SQLException("Digital elevation model table \"" + demTable + "\" must exist and contain a POINT field");
            }
            String topoGeomName = (String)geomFields.get(0);
            double sumZ = 0.0;
            int topoCount = 0;
            try (PreparedStatement st = connection.prepareStatement("SELECT " + TableLocation.quoteIdentifier((String)topoGeomName, (DBTypes)dbType) + " FROM " + demTable + " WHERE " + TableLocation.quoteIdentifier((String)topoGeomName, (DBTypes)dbType) + " && ?::geometry");){
                st.setObject(1, geometryFactory.toGeometry(fetchEnvelope));
                try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                    while (rs.next()) {
                        Geometry pt = rs.getGeometry();
                        if (pt == null) continue;
                        Coordinate ptCoordinate = pt.getCoordinate();
                        profileBuilder.addTopographicPoint(ptCoordinate);
                        if (Double.isNaN(ptCoordinate.z)) continue;
                        sumZ += ptCoordinate.z;
                        ++topoCount;
                    }
                }
                double averageZ = 0.0;
                if (topoCount > 0) {
                    averageZ = sumZ / (double)topoCount;
                }
                Envelope extentedEnvelope = new Envelope(fetchEnvelope);
                extentedEnvelope.expandBy(fetchEnvelope.getDiameter());
                Coordinate[] coordinates = geometryFactory.toGeometry(extentedEnvelope).getCoordinates();
                for (int i = 0; i < coordinates.length - 1; ++i) {
                    Coordinate coordinate = coordinates[i];
                    profileBuilder.addTopographicPoint(new Coordinate(coordinate.x, coordinate.y, averageZ));
                }
            }
        }
    }

    protected void fetchCellSoilAreas(Connection connection, Envelope fetchEnvelope, ProfileBuilder builder) throws SQLException {
        String soilTableName = this.noiseMapByReceiverMaker.getSoilTableName();
        if (!soilTableName.isEmpty()) {
            GeometryFactory geometryFactory = this.noiseMapByReceiverMaker.getGeometryFactory();
            DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
            double startX = Math.floor(fetchEnvelope.getMinX() / this.groundSurfaceSplitSideLength) * this.groundSurfaceSplitSideLength;
            double startY = Math.floor(fetchEnvelope.getMinY() / this.groundSurfaceSplitSideLength) * this.groundSurfaceSplitSideLength;
            String soilGeomName = (String)GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)TableLocation.parse((String)soilTableName, (DBTypes)dbType)).get(0);
            try (PreparedStatement st = connection.prepareStatement("SELECT " + TableLocation.quoteIdentifier((String)soilGeomName, (DBTypes)dbType) + ", G FROM " + soilTableName + " WHERE " + TableLocation.quoteIdentifier((String)soilGeomName, (DBTypes)dbType) + " && ?::geometry");){
                st.setObject(1, geometryFactory.toGeometry(fetchEnvelope));
                try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                    while (rs.next()) {
                        Geometry mainPolygon = rs.getGeometry();
                        if (mainPolygon == null) continue;
                        for (int idPoly = 0; idPoly < mainPolygon.getNumGeometries(); ++idPoly) {
                            Geometry poly = mainPolygon.getGeometryN(idPoly);
                            if (!(poly instanceof Polygon)) continue;
                            PreparedPolygon preparedPolygon = new PreparedPolygon((Polygonal)((Polygon)poly));
                            Envelope geoEnv = poly.getEnvelopeInternal();
                            double startXGeo = Math.max(startX, Math.floor(geoEnv.getMinX() / this.groundSurfaceSplitSideLength) * this.groundSurfaceSplitSideLength);
                            double startYGeo = Math.max(startY, Math.floor(geoEnv.getMinY() / this.groundSurfaceSplitSideLength) * this.groundSurfaceSplitSideLength);
                            double g = rs.getDouble("G");
                            double maxX = Math.min(fetchEnvelope.getMaxX(), geoEnv.getMaxX());
                            double maxY = Math.min(fetchEnvelope.getMaxY(), geoEnv.getMaxY());
                            for (double xCursor = startXGeo; xCursor < maxX; xCursor += this.groundSurfaceSplitSideLength) {
                                for (double yCursor = startYGeo; yCursor < maxY; yCursor += this.groundSurfaceSplitSideLength) {
                                    Envelope cellEnv = new Envelope(xCursor, xCursor + this.groundSurfaceSplitSideLength, yCursor, yCursor + this.groundSurfaceSplitSideLength);
                                    Geometry envGeom = geometryFactory.toGeometry(cellEnv);
                                    if (!preparedPolygon.intersects(envGeom)) continue;
                                    try {
                                        Geometry inters = poly.intersection(envGeom);
                                        if (inters.isEmpty() || !(inters instanceof Polygon) && !(inters instanceof MultiPolygon)) continue;
                                        builder.addGroundEffect(inters, g);
                                        continue;
                                    }
                                    catch (IllegalArgumentException | TopologyException throwable) {
                                        // empty catch block
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchCellSource(Connection connection, Envelope fetchEnvelope, SceneWithEmission scene, boolean doIntersection) throws SQLException {
        String sourcesTableName = this.noiseMapByReceiverMaker.getSourcesTableName();
        GeometryFactory geometryFactory = this.noiseMapByReceiverMaker.getGeometryFactory();
        DBTypes dbType = DBUtils.getDBType((Connection)connection.unwrap(Connection.class));
        TableLocation sourceTableIdentifier = TableLocation.parse((String)sourcesTableName, (DBTypes)dbType);
        List geomFields = GeometryTableUtilities.getGeometryColumnNames((Connection)connection, (TableLocation)sourceTableIdentifier);
        if (geomFields.isEmpty()) {
            throw new SQLException(String.format("The table %s does not exists or does not contain a geometry field", sourceTableIdentifier));
        }
        String sourceGeomName = (String)geomFields.get(0);
        Geometry domainConstraint = geometryFactory.toGeometry(fetchEnvelope);
        Tuple primaryKey = JDBCUtilities.getIntegerPrimaryKeyNameAndIndex((Connection)connection.unwrap(Connection.class), (TableLocation)new TableLocation(sourcesTableName, dbType));
        if (primaryKey == null) {
            throw new IllegalArgumentException(String.format("Source table %s does not contain a primary key", sourceTableIdentifier));
        }
        int pkIndex = (Integer)primaryKey.second();
        try (PreparedStatement st = connection.prepareStatement("SELECT * FROM " + sourcesTableName + " WHERE " + TableLocation.quoteIdentifier((String)sourceGeomName) + " && ?::geometry");){
            st.setObject(1, geometryFactory.toGeometry(fetchEnvelope));
            st.setFetchSize(this.fetchSize);
            boolean autoCommit = connection.getAutoCommit();
            if (autoCommit) {
                connection.setAutoCommit(false);
            }
            st.setFetchDirection(1000);
            try (SpatialResultSet rs = st.executeQuery().unwrap(SpatialResultSet.class);){
                while (rs.next()) {
                    Coordinate[] coordinates;
                    Geometry geo = rs.getGeometry();
                    if (geo == null) continue;
                    if (doIntersection) {
                        geo = domainConstraint.intersection(geo);
                    }
                    if (geo.isEmpty()) continue;
                    for (Coordinate coordinate : coordinates = geo.getCoordinates()) {
                        if (coordinate.getZ() != Double.NaN) continue;
                        throw new IllegalArgumentException("The table " + sourcesTableName + " contain at least one source without Z ordinate. You must specify X,Y,Z for each source");
                    }
                    scene.addSource(rs.getLong(pkIndex), geo, rs);
                }
            }
            finally {
                if (autoCommit) {
                    connection.setAutoCommit(true);
                }
            }
        }
        String emissionTableName = scene.sceneDatabaseInputSettings.sourcesEmissionTableName;
        if (!emissionTableName.isEmpty()) {
            try (PreparedStatement st = connection.prepareStatement("SELECT E.* FROM " + sourcesTableName + " S INNER JOIN " + emissionTableName + " E ON S." + (String)primaryKey.first() + " = E." + scene.sceneDatabaseInputSettings.sourceEmissionPrimaryKeyField + " WHERE S." + TableLocation.quoteIdentifier((String)sourceGeomName) + " && ?::geometry");){
                st.setObject(1, geometryFactory.toGeometry(fetchEnvelope));
                st.setFetchSize(this.fetchSize);
                boolean autoCommit = connection.getAutoCommit();
                if (autoCommit) {
                    connection.setAutoCommit(false);
                }
                st.setFetchDirection(1000);
                try (ResultSet rs = st.executeQuery();){
                    while (rs.next()) {
                        scene.addSourceEmission(rs.getLong(scene.sceneDatabaseInputSettings.sourceEmissionPrimaryKeyField), rs);
                    }
                }
                finally {
                    if (autoCommit) {
                        connection.setAutoCommit(true);
                    }
                }
            }
        }
    }

    public static class BuildingTableParameters {
        public String buildingsTableName;
        public String heightField = "HEIGHT";
        public String alphaFieldName = "G";
        public double defaultWallAbsorption = 100000.0;
        public boolean zBuildings = false;

        public String getAlphaFieldName() {
            return this.alphaFieldName;
        }

        public void setAlphaFieldName(String alphaFieldName) {
            this.alphaFieldName = alphaFieldName;
        }

        public String getHeightField() {
            return this.heightField;
        }

        public void setHeightField(String heightField) {
            this.heightField = heightField;
        }
    }
}

