/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.h2gis.utilities.JDBCUtilities;
import org.h2gis.utilities.SpatialResultSet;
import org.locationtech.jts.geom.Geometry;
import org.noise_planet.noisemodelling.emission.directivity.DirectivitySphere;
import org.noise_planet.noisemodelling.emission.directivity.OmnidirectionalDirection;
import org.noise_planet.noisemodelling.pathfinder.path.Scene;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.ProfileBuilder;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;

public class SceneWithAttenuation
extends Scene {
    public static final double DEFAULT_GS = 0.0;
    public Map<Integer, DirectivitySphere> directionAttributes = new HashMap<Integer, DirectivitySphere>();
    public Map<Long, Integer> sourceEmissionAttenuation = new HashMap<Long, Integer>();
    public Map<Long, Double> sourceGs = new HashMap<Long, Double>();
    public Map<String, Integer> sourceFieldNames = new HashMap<String, Integer>();
    public AttenuationParameters defaultCnossosParameters = new AttenuationParameters();
    public Map<String, AttenuationParameters> cnossosParametersPerPeriod = new HashMap<String, AttenuationParameters>();
    public Set<String> periodSet = new HashSet<String>();

    public SceneWithAttenuation(ProfileBuilder profileBuilder) {
        super(profileBuilder);
        this.defaultCnossosParameters.setFrequencies(profileBuilder.frequencyArray);
    }

    public SceneWithAttenuation() {
    }

    public double getSourceGs(int srcIndex) {
        return this.sourceGs.get(this.sourcesPk.get(srcIndex));
    }

    public void addSource(Long pk, Geometry geom, Double gs) {
        this.addSource(pk, geom);
        this.sourceGs.put(pk, gs);
    }

    public void setDirectionAttributes(Map<Integer, DirectivitySphere> directionAttributes) {
        this.directionAttributes = directionAttributes;
        directionAttributes.forEach((integer, directivitySphere) -> this.profileBuilder.frequencyArray.forEach(frequency -> {
            if (!directivitySphere.coverFrequency((double)frequency.intValue())) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "The provided DirectivitySphere does not handle %d Hertz", frequency));
            }
        }));
    }

    public void addSource(Long pk, Geometry geom, SpatialResultSet rs) throws SQLException {
        if (this.sourceFieldNames.isEmpty()) {
            List fieldNames = JDBCUtilities.getColumnNames((ResultSetMetaData)rs.getMetaData());
            for (int idField = 0; idField < fieldNames.size(); ++idField) {
                this.sourceFieldNames.put(((String)fieldNames.get(idField)).toUpperCase(Locale.ROOT), idField + 1);
            }
        }
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        boolean hasOrientation = false;
        if (this.sourceFieldNames.containsKey("YAW")) {
            yaw = rs.getFloat(this.sourceFieldNames.get("YAW").intValue());
            hasOrientation = true;
        }
        if (this.sourceFieldNames.containsKey("PITCH")) {
            pitch = rs.getFloat(this.sourceFieldNames.get("PITCH").intValue());
            hasOrientation = true;
        }
        if (this.sourceFieldNames.containsKey("ROLL")) {
            roll = rs.getFloat(this.sourceFieldNames.get("ROLL").intValue());
            hasOrientation = true;
        }
        int directivityField = JDBCUtilities.getFieldIndex((ResultSetMetaData)rs.getMetaData(), (String)"DIR_ID");
        if (this.sourceFieldNames.containsKey("DIR_ID")) {
            this.sourceEmissionAttenuation.put(pk, rs.getInt(directivityField));
        }
        if (hasOrientation) {
            this.addSource(pk, geom, new Orientation((double)yaw, (double)pitch, (double)roll));
        } else {
            this.addSource(pk, geom);
        }
        int gsField = JDBCUtilities.getFieldIndex((ResultSetMetaData)rs.getMetaData(), (String)"GS");
        if (this.sourceFieldNames.containsKey("GS")) {
            this.sourceGs.put(pk, rs.getDouble(gsField));
        }
    }

    public boolean isOmnidirectional(int srcIndex) {
        if (srcIndex < 0 || srcIndex >= this.sourcesPk.size()) {
            return true;
        }
        long sourcePk = (Long)this.sourcesPk.get(srcIndex);
        if (!this.sourceEmissionAttenuation.containsKey(sourcePk)) {
            return true;
        }
        return this.directionAttributes.get(this.sourceEmissionAttenuation.get(sourcePk)) instanceof OmnidirectionalDirection;
    }

    public double[] getSourceAttenuation(int srcIndex, double[] frequencies, double phi, double theta) {
        int directivityIdentifier = this.sourceEmissionAttenuation.get(this.sourcesPk.get(srcIndex));
        if (this.directionAttributes.containsKey(directivityIdentifier)) {
            return this.directionAttributes.get(directivityIdentifier).getAttenuationArray(frequencies, phi, theta);
        }
        return new double[frequencies.length];
    }

    public void clearSources() {
        super.clearSources();
        this.sourceEmissionAttenuation.clear();
        this.sourceFieldNames.clear();
        this.sourceGs.clear();
        this.directionAttributes.clear();
    }
}

