/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.math.Vector3D;
import org.noise_planet.noisemodelling.pathfinder.utils.AcousticIndicatorsFunctions;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.AttenuationParameters;
import org.noise_planet.noisemodelling.propagation.SceneWithAttenuation;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.PointPath;
import org.noise_planet.noisemodelling.propagation.cnossos.SegmentPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttenuationCnossos {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttenuationCnossos.class);

    public static double getADiv(double distance) {
        return 20.0 * Math.log10(distance) + 11.0;
    }

    private static double getAAtm(double dist, double alpha_atmo) {
        return alpha_atmo * dist / 1000.0;
    }

    public static double[] getAGroundCore(CnossosPath pathParameters, SegmentPath segmentPath, AttenuationParameters data) {
        double[] aGround = new double[data.getFrequencies().size()];
        for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
            double AGround;
            double aGroundMin;
            int fm = data.getFrequencies().get(idfreq);
            double gw = segmentPath.gw;
            double dp = segmentPath.dp;
            double k = Math.PI * 2 * (double)fm / data.getCelerity();
            double w = 0.0185 * Math.pow(fm, 2.5) * Math.pow(gw, 2.6) / (Math.pow(fm, 1.5) * Math.pow(gw, 2.6) + 1300.0 * Math.pow(fm, 0.75) * Math.pow(gw, 1.3) + 1160000.0);
            double cf = dp * (1.0 + 3.0 * w * dp * Math.pow(Math.E, -Math.sqrt(w * dp))) / (1.0 + w * dp);
            if (pathParameters.isFavourable()) {
                aGroundMin = data.isPrime2520() ? (segmentPath.testFormF <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormF))) : (segmentPath.testFormH <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormH)));
                AGround = -10.0 * Math.log10(4.0 * Math.pow(k, 2.0) / Math.pow(segmentPath.dp, 2.0) * (Math.pow(segmentPath.zsF, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zsF + cf / k) * (Math.pow(segmentPath.zrF, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zrF + cf / k));
            } else {
                AGround = -10.0 * Math.log10(4.0 * Math.pow(k, 2.0) / Math.pow(segmentPath.dp, 2.0) * (Math.pow(segmentPath.zsH, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zsH + cf / k) * (Math.pow(segmentPath.zrH, 2.0) - Math.sqrt(2.0 * cf / k) * segmentPath.zrH + cf / k));
                aGroundMin = -3.0 * (1.0 - segmentPath.gm);
            }
            aGround[idfreq] = Math.max(AGround, aGroundMin);
            if (!pathParameters.keepAbsorption) continue;
            int n = idfreq;
            pathParameters.groundAttenuation.w[n] = pathParameters.groundAttenuation.w[n] + w;
            pathParameters.groundAttenuation.cf[idfreq] = cf;
            pathParameters.groundAttenuation.aGround[idfreq] = aGround[idfreq];
        }
        return aGround;
    }

    private static double[] getARef(CnossosPath pathParameters, AttenuationParameters data) {
        double[] aRef = new double[data.getFrequencies().size()];
        Arrays.fill(aRef, 0.0);
        for (PointPath pointPath : pathParameters.getPointList()) {
            if (!pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL)) continue;
            for (int idf = 0; idf < data.getFrequencies().size(); ++idf) {
                List<Double> alpha = pointPath.alphaWall;
                if (alpha == null || alpha.isEmpty()) continue;
                int n = idf;
                aRef[n] = aRef[n] + 10.0 * Math.log10(1.0 - alpha.get(idf));
            }
        }
        return aRef;
    }

    private static double[] aGround(SegmentPath segmentPath, CnossosPath pathParameters, AttenuationParameters data) {
        if (segmentPath.gPath != 0.0 || !data.isgDisc()) {
            return AttenuationCnossos.getAGroundCore(pathParameters, segmentPath, data);
        }
        double aGroundMin = AttenuationCnossos.getAGroundMin(segmentPath, pathParameters);
        double[] aGround = new double[data.getFrequencies().size()];
        Arrays.fill(aGround, aGroundMin);
        if (pathParameters.keepAbsorption) {
            pathParameters.groundAttenuation.aGround = aGround;
        }
        return aGround;
    }

    private static double getAGroundMin(SegmentPath segmentPath, CnossosPath pathParameters) {
        double aGroundMin = pathParameters.isFavourable() ? (segmentPath.testFormF <= 1.0 ? -3.0 * (1.0 - segmentPath.gm) : -3.0 * (1.0 - segmentPath.gm) * (1.0 + 2.0 * (1.0 - 1.0 / segmentPath.testFormF))) : -3.0;
        return aGroundMin;
    }

    public static double[] aDiv(CnossosPath pathParameters, AttenuationParameters data) {
        double[] aDiv = new double[data.getFrequencies().size()];
        long difVPointCount = pathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        Arrays.fill(aDiv, AttenuationCnossos.getADiv(difVPointCount == 0L ? pathParameters.getSRSegment().d : pathParameters.getSRSegment().dc));
        return aDiv;
    }

    public static double[] aAtm(double[] alphaAtmosphericKm, double distance) {
        double[] aAtm = new double[alphaAtmosphericKm.length];
        for (int idfreq = 0; idfreq < aAtm.length; ++idfreq) {
            aAtm[idfreq] = AttenuationCnossos.getAAtm(distance, alphaAtmosphericKm[idfreq]);
        }
        return aAtm;
    }

    private static boolean isValidRcrit(CnossosPath pp, int freq) {
        double lambda = 340.0 / (double)freq;
        return pp.delta > -lambda / 20.0 && pp.delta > lambda / 4.0 - pp.deltaPrime || pp.delta > 0.0;
    }

    public static double[] aBoundary(CnossosPath path, AttenuationParameters data) {
        double[] aGround = new double[data.getFrequencies().size()];
        double[] aDif = new double[data.getFrequencies().size()];
        List diffPts = path.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH_RCRIT) || pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH) || pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).collect(Collectors.toList());
        path.aBoundary.init(data.getFrequencies().size());
        for (int i = 0; i < data.getFrequencies().size(); ++i) {
            int finalI = i;
            boolean isValidRCriterion = AttenuationCnossos.isValidRcrit(path, data.getFrequencies().get(finalI));
            PointPath first = diffPts.stream().filter(pp -> pp.type.equals((Object)PointPath.POINT_TYPE.DIFH) || pp.type.equals((Object)PointPath.POINT_TYPE.DIFV) || pp.type.equals((Object)PointPath.POINT_TYPE.DIFH_RCRIT) && isValidRCriterion).findFirst().orElse(null);
            double d = aGround[i] = path.isFavourable() ? AttenuationCnossos.aGroundF(path, path.getSRSegment(), data, i) : AttenuationCnossos.aGroundH(path, path.getSRSegment(), data, i);
            if (path.groundAttenuation != null && path.groundAttenuation.aGround != null) {
                path.groundAttenuation.aGround[i] = aGround[i];
            }
            if (first != null) {
                aDif[i] = AttenuationCnossos.aDif(path, data, i, first.type);
                if (first.type.equals((Object)PointPath.POINT_TYPE.DIFV) || !isValidRCriterion) continue;
                aGround[i] = 0.0;
                continue;
            }
            aDif[i] = 0.0;
        }
        if (path.keepAbsorption) {
            path.aDif = aDif;
        }
        double[] aBoundary = new double[data.getFrequencies().size()];
        for (int i = 0; i < data.getFrequencies().size(); ++i) {
            aBoundary[i] = aGround[i] + aDif[i];
        }
        return aBoundary;
    }

    public static double[] deltaRetrodif(CnossosPath reflect, AttenuationParameters data) {
        double[] retroDiff = new double[data.getFrequencies().size()];
        Arrays.fill(retroDiff, 0.0);
        Coordinate originalS = reflect.getSRSegment().s;
        Coordinate originalR = reflect.getSRSegment().r;
        double SR = originalS.distance(originalR);
        Coordinate s = originalS;
        Coordinate r = originalR;
        List<PointPath> pointList = reflect.getPointList();
        for (int idPoint = 0; idPoint < pointList.size(); ++idPoint) {
            PointPath pointPath = pointList.get(idPoint);
            if (pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH)) {
                s = pointPath.coordinate;
                continue;
            }
            if (!pointPath.type.equals((Object)PointPath.POINT_TYPE.REFL)) continue;
            for (int idPointNext = 0; idPointNext < pointList.size(); ++idPointNext) {
                PointPath pointPathNext = pointList.get(idPoint);
                if (!pointPathNext.type.equals((Object)PointPath.POINT_TYPE.DIFH)) continue;
                r = pointPathNext.coordinate;
                break;
            }
            Coordinate p = new Coordinate(pointPath.coordinate.x, pointPath.obstacleZ);
            double ch = 1.0;
            if (reflect.isFavourable()) {
                double lambda;
                int i;
                double SP = s.distance(p);
                double PR = p.distance(r);
                double gamma = 2.0 * Math.max(1000.0, 8.0 * SR);
                double e = reflect.e;
                double SpO = gamma * Math.asin(SP / gamma);
                double OpR = gamma * Math.asin(PR / gamma);
                double SpR = gamma * Math.asin(s.distance(r) / gamma);
                double deltaPrime = -(SpO + OpR - SpR);
                if (e < 0.3) {
                    for (i = 0; i < data.getFrequencies().size(); ++i) {
                        double dLRetro;
                        lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                        double testForm = 40.0 / lambda * deltaPrime;
                        retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
                    }
                    continue;
                }
                for (i = 0; i < data.getFrequencies().size(); ++i) {
                    double dLRetro;
                    double Csecond;
                    lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                    double testForm = 40.0 / lambda * (Csecond = 1.0 + 5.0 * lambda / e * 5.0 * lambda / e / 1.0 / 3.0 + 5.0 * lambda / e * 5.0 * lambda / e) * deltaPrime;
                    retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
                }
                continue;
            }
            double deltaPrime = s.distance(r) - s.distance(p) - p.distance(r);
            for (int i = 0; i < data.getFrequencies().size(); ++i) {
                double dLRetro;
                double lambda = 340.0 / (double)data.getFrequencies().get(i).intValue();
                double testForm = 40.0 / lambda * deltaPrime;
                retroDiff[i] = dLRetro = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
            }
        }
        return retroDiff;
    }

    private static double aDif(CnossosPath proPathParameters, AttenuationParameters data, int frequencyIndex, PointPath.POINT_TYPE type) {
        SegmentPath first = proPathParameters.getSegmentList().get(0);
        SegmentPath last = proPathParameters.getSegmentList().get(proPathParameters.getSegmentList().size() - 1);
        double ch = 1.0;
        double lambda = 340.0 / (double)data.getFrequencies().get(frequencyIndex).intValue();
        long difHCount = proPathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFH)).count();
        long difVCount = proPathParameters.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
        double cSecond = type.equals((Object)PointPath.POINT_TYPE.DIFH) && difHCount <= 1L || type.equals((Object)PointPath.POINT_TYPE.DIFV) && difVCount <= 1L || proPathParameters.e <= 0.3 ? 1.0 : (1.0 + Math.pow(5.0 * lambda / proPathParameters.e, 2.0)) / (0.3333333333333333 + Math.pow(5.0 * lambda / proPathParameters.e, 2.0));
        double _delta = proPathParameters.delta;
        double deltaDStar = proPathParameters.getSegmentList().get((int)0).dPrime + proPathParameters.getSegmentList().get((int)(proPathParameters.getSegmentList().size() - 1)).dPrime - proPathParameters.getSRSegment().dPrime;
        double deltaDiffSR = 0.0;
        double testForm = 40.0 / lambda * cSecond * _delta;
        if (_delta >= 0.0 || _delta > -lambda / 20.0 && _delta > lambda / 4.0 - deltaDStar) {
            deltaDiffSR = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        } else if (type.equals((Object)PointPath.POINT_TYPE.DIFH)) {
            return 0.0;
        }
        if (type.equals((Object)PointPath.POINT_TYPE.DIFV)) {
            if (proPathParameters.keepAbsorption) {
                proPathParameters.aBoundary.deltaDiffSR[frequencyIndex] = deltaDiffSR;
            }
            return deltaDiffSR;
        }
        _delta = proPathParameters.deltaSPrimeR;
        testForm = 40.0 / lambda * cSecond * _delta;
        double deltaDiffSPrimeR = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        _delta = proPathParameters.deltaSRPrime;
        testForm = 40.0 / lambda * cSecond * _delta;
        double deltaDiffSRPrime = testForm >= -2.0 ? 10.0 * ch * Math.log10(3.0 + testForm) : 0.0;
        double aGroundSO = proPathParameters.isFavourable() ? AttenuationCnossos.aGroundF(proPathParameters, first, data, frequencyIndex) : AttenuationCnossos.aGroundH(proPathParameters, first, data, frequencyIndex);
        double aGroundOR = proPathParameters.isFavourable() ? AttenuationCnossos.aGroundF(proPathParameters, last, data, frequencyIndex, true) : AttenuationCnossos.aGroundH(proPathParameters, last, data, frequencyIndex, true);
        double deltaGroundSO = -20.0 * Math.log10(1.0 + (Math.pow(10.0, -aGroundSO / 20.0) - 1.0) * Math.pow(10.0, -(deltaDiffSPrimeR - deltaDiffSR) / 20.0));
        double deltaGroundOR = -20.0 * Math.log10(1.0 + (Math.pow(10.0, -aGroundOR / 20.0) - 1.0) * Math.pow(10.0, -(deltaDiffSRPrime - deltaDiffSR) / 20.0));
        if (Double.isNaN(deltaGroundSO)) {
            deltaGroundSO = aGroundSO;
            deltaDiffSR = deltaDiffSPrimeR;
        }
        if (Double.isNaN(deltaGroundOR)) {
            deltaGroundOR = aGroundOR;
            deltaDiffSR = deltaDiffSPrimeR;
        }
        double aDiff = Math.min(25.0, Math.max(0.0, deltaDiffSR)) + deltaGroundSO + deltaGroundOR;
        if (proPathParameters.keepAbsorption) {
            proPathParameters.aBoundary.deltaDiffSR[frequencyIndex] = deltaDiffSR;
            proPathParameters.aBoundary.aGroundSO[frequencyIndex] = aGroundSO;
            proPathParameters.aBoundary.aGroundOR[frequencyIndex] = aGroundOR;
            proPathParameters.aBoundary.deltaDiffSPrimeR[frequencyIndex] = deltaDiffSPrimeR;
            proPathParameters.aBoundary.deltaDiffSRPrime[frequencyIndex] = deltaDiffSRPrime;
            proPathParameters.aBoundary.deltaGroundSO[frequencyIndex] = deltaGroundSO;
            proPathParameters.aBoundary.deltaGroundOR[frequencyIndex] = deltaGroundOR;
            proPathParameters.aBoundary.aDiff[frequencyIndex] = aDiff;
        }
        return aDiff;
    }

    private static double[] computeCfKValues(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq, false);
    }

    private static double[] computeCfKValues(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        int fm = data.getFrequencies().get(idFreq);
        double c = data.getCelerity();
        double dp = path.dp;
        double k = Math.PI * 2 * (double)fm / c;
        double gw = forceGPath ? path.gPath : (proPathParameters.isFavourable() ? path.gPath : path.gPathPrime);
        double w = 0.0185 * Math.pow(fm, 2.5) * Math.pow(gw, 2.6) / (Math.pow(fm, 1.5) * Math.pow(gw, 2.6) + 1300.0 * Math.pow(fm, 0.75) * Math.pow(gw, 1.3) + 1160000.0);
        double cf = dp * (1.0 + 3.0 * w * dp * Math.exp(-Math.sqrt(w * dp))) / (1.0 + w * dp);
        return new double[]{cf, k, w};
    }

    public static double aGroundH(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.aGroundH(proPathParameters, path, data, idFreq, false);
    }

    public static double aGroundH(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        double[] values = AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq, forceGPath);
        double cf = values[0];
        double k = values[1];
        double w = values[2];
        if (proPathParameters.keepAbsorption && path == proPathParameters.getSRSegment()) {
            proPathParameters.groundAttenuation.w[idFreq] = w;
            proPathParameters.groundAttenuation.cf[idFreq] = cf;
        }
        if (path.gPath == 0.0) {
            return -3.0;
        }
        double dp = path.dp;
        double gm = forceGPath ? path.gPath : path.gPathPrime;
        double aGroundHMin = -3.0 * (1.0 - gm);
        double zs = path.zsH;
        double zr = path.zrH;
        double aGroundHComputed = -10.0 * Math.log10(4.0 * (k * k) / (dp * dp) * (zs * zs - Math.sqrt(2.0 * cf / k) * zs + cf / k) * (zr * zr - Math.sqrt(2.0 * cf / k) * zr + cf / k));
        return Math.max(aGroundHComputed, aGroundHMin);
    }

    public static double aGroundF(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq) {
        return AttenuationCnossos.aGroundF(proPathParameters, path, data, idFreq, false);
    }

    public static double aGroundF(CnossosPath proPathParameters, SegmentPath path, AttenuationParameters data, int idFreq, boolean forceGPath) {
        double aGroundFMin;
        double[] values = AttenuationCnossos.computeCfKValues(proPathParameters, path, data, idFreq);
        double cf = values[0];
        double k = values[1];
        double w = values[2];
        if (proPathParameters.keepAbsorption && path == proPathParameters.getSRSegment()) {
            proPathParameters.groundAttenuation.w[idFreq] = w;
            proPathParameters.groundAttenuation.cf[idFreq] = cf;
        }
        double gm = forceGPath ? path.gPath : path.gPathPrime;
        double d = aGroundFMin = path.testFormH <= 1.0 ? -3.0 * (1.0 - gm) : -3.0 * (1.0 - gm) * (1.0 + 2.0 * (1.0 - 1.0 / path.testFormH));
        if (path.gPath == 0.0) {
            return aGroundFMin;
        }
        double dp = path.dp;
        double zs = path.zsF;
        double zr = path.zrF;
        double aGroundFComputed = -10.0 * Math.log10(4.0 * (k * k) / (dp * dp) * (zs * zs - Math.sqrt(2.0 * cf / k) * zs + cf / k) * (zr * zr - Math.sqrt(2.0 * cf / k) * zr + cf / k));
        return Math.max(aGroundFComputed, aGroundFMin);
    }

    public static double[] computeCnossosAttenuation(AttenuationParameters data, CnossosPath proPathParameters, SceneWithAttenuation scene, boolean exportAttenuationMatrix) {
        double[] aRetroDiff;
        double[] aBoundary;
        if (data == null) {
            return new double[0];
        }
        double[] frequencies = new double[]{};
        if (scene != null) {
            frequencies = scene.profileBuilder.frequencyArray.stream().mapToDouble(value -> value.intValue()).toArray();
        }
        if (exportAttenuationMatrix) {
            proPathParameters.keepAbsorption = true;
            proPathParameters.groundAttenuation.init(data.getFrequencies().size());
            proPathParameters.init(data.getFrequencies().size());
        }
        double[] aDiv = AttenuationCnossos.aDiv(proPathParameters, data);
        double[] aAtm = AttenuationCnossos.aAtm(data.getAlpha_atmo(), proPathParameters.getSRSegment().d);
        double[] aRef = AttenuationCnossos.getARef(proPathParameters, data);
        if (exportAttenuationMatrix) {
            proPathParameters.aRef = (double[])aRef.clone();
        }
        double[] aGlobalMeteo = new double[data.getFrequencies().size()];
        double[] deltaBodyScreen = new double[data.getFrequencies().size()];
        List<PointPath> ptList = proPathParameters.getPointList();
        double hRail = 0.5;
        Coordinate src = ptList.get((int)0).coordinate;
        PointPath pDif = ptList.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).findFirst().orElse(null);
        if (pDif != null && !pDif.alphaWall.isEmpty() && pDif.bodyBarrier) {
            int n = 3;
            Coordinate rcv = ptList.get((int)(ptList.size() - 1)).coordinate;
            double[][] deltaGeo = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaAbs = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaDif = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRef = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRetroDifi = new double[n + 1][data.getFrequencies().size()];
            double[][] deltaRetroDif = new double[n + 1][data.getFrequencies().size()];
            double[] deltaL = new double[data.getFrequencies().size()];
            Arrays.fill(deltaL, AcousticIndicatorsFunctions.dBToW((double)0.0));
            double db = pDif.coordinate.x;
            double hb = pDif.coordinate.y;
            Coordinate B = new Coordinate(db, hb);
            double Cref = 1.0;
            double dr = rcv.x;
            double h0 = ptList.get((int)0).altitude + hRail;
            double hs = ptList.get((int)0).altitude + src.y - hRail;
            double hr = ptList.get((int)(ptList.size() - 1)).altitude + ptList.get((int)(ptList.size() - 1)).coordinate.y - h0;
            double[] r = new double[4];
            if (db < 5.0 * hb) {
                for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                    int i;
                    if (!(pDif.alphaWall.get(idfreq) < 0.8)) continue;
                    double dif0 = 0.0;
                    double ch = 1.0;
                    double lambda = 340.0 / (double)data.getFrequencies().get(idfreq).intValue();
                    double hi = hs;
                    double cSecond = 1.0;
                    for (i = 0; i <= n; ++i) {
                        double di = (double)(-2 * i) * db;
                        Coordinate si = new Coordinate(src.x + di, src.y);
                        r[i] = Math.sqrt(Math.pow(di - (db + dr), 2.0) + Math.pow(hi - hr, 2.0));
                        deltaGeo[i][idfreq] = 20.0 * Math.log10(r[0] / r[i]);
                        double deltai = si.distance(B) + B.distance(rcv) - si.distance(rcv);
                        double dif = 0.0;
                        double testForm = 40.0 / lambda * cSecond * deltai;
                        if (testForm >= -2.0) {
                            dif = 10.0 * ch * Math.log10(3.0 + testForm);
                        }
                        if (i == 0) {
                            dif0 = dif;
                            deltaRetroDif[i][idfreq] = dif;
                        } else {
                            deltaDif[i][idfreq] = dif0 - dif;
                        }
                        deltaAbs[i][idfreq] = (double)(10 * i) * Math.log10(1.0 - pDif.alphaWall.get(idfreq));
                        deltaRef[i][idfreq] = (double)(10 * i) * Math.log10(Cref);
                        double retroDif = 0.0;
                        Coordinate Pi = new Coordinate((double)(-(2 * i - 1)) * db, hb);
                        Coordinate RcvPrime = new Coordinate(dr, Math.max(hr, hb * (db + dr - di) / (db - di)));
                        deltai = -(si.distance(Pi) + Pi.distance(RcvPrime) - si.distance(RcvPrime));
                        testForm = 40.0 / lambda * cSecond * deltai;
                        if (testForm >= -2.0) {
                            retroDif = 10.0 * ch * Math.log10(3.0 + testForm);
                        }
                        deltaRetroDifi[i][idfreq] = i == 0 ? 0.0 : retroDif;
                    }
                    deltaRetroDif[0][idfreq] = 0.0;
                    for (i = 1; i <= n; ++i) {
                        double sumRetrodif = 0.0;
                        for (int j = 1; j <= i; ++j) {
                            sumRetrodif += deltaRetroDifi[j][idfreq];
                        }
                        deltaRetroDif[i][idfreq] = -sumRetrodif;
                    }
                    for (i = 0; i <= n; ++i) {
                        deltaL[idfreq] = deltaL[idfreq] + AcousticIndicatorsFunctions.dBToW((double)(deltaGeo[i][idfreq] + deltaDif[i][idfreq] + deltaAbs[i][idfreq] + deltaRef[i][idfreq] + deltaRetroDif[i][idfreq]));
                    }
                }
                deltaBodyScreen = AcousticIndicatorsFunctions.wToDb((double[])deltaL);
            }
        }
        Vector3D fieldVectorPropagation = Orientation.rotate((Orientation)proPathParameters.getSourceOrientation(), (Vector3D)Orientation.toVector((Orientation)proPathParameters.raySourceReceiverDirectivity), (boolean)false);
        int roseIndex = AttenuationParameters.getRoseIndex(Math.atan2(fieldVectorPropagation.getY(), fieldVectorPropagation.getX()));
        if (!proPathParameters.isFavourable()) {
            if (data.getWindRose()[roseIndex] != 1.0) {
                aBoundary = AttenuationCnossos.aBoundary(proPathParameters, data);
                aRetroDiff = AttenuationCnossos.deltaRetrodif(proPathParameters, data);
                for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                    aGlobalMeteo[idfreq] = -(aDiv[idfreq] + aAtm[idfreq] + aBoundary[idfreq] - aRef[idfreq] + aRetroDiff[idfreq] - deltaBodyScreen[idfreq]);
                }
                if (exportAttenuationMatrix) {
                    proPathParameters.aRetroDiff = (double[])aRetroDiff.clone();
                    proPathParameters.double_aBoundary = (double[])aBoundary.clone();
                    proPathParameters.aGlobalRaw = (double[])aGlobalMeteo.clone();
                }
            }
        } else if (data.getWindRose()[roseIndex] != 0.0) {
            proPathParameters.setFavourable(true);
            aBoundary = AttenuationCnossos.aBoundary(proPathParameters, data);
            aRetroDiff = AttenuationCnossos.deltaRetrodif(proPathParameters, data);
            for (int idfreq = 0; idfreq < data.getFrequencies().size(); ++idfreq) {
                aGlobalMeteo[idfreq] = -(aDiv[idfreq] + aAtm[idfreq] + aBoundary[idfreq] - aRef[idfreq] + aRetroDiff[idfreq] - deltaBodyScreen[idfreq]);
            }
            if (exportAttenuationMatrix) {
                proPathParameters.double_aBoundary = (double[])aBoundary.clone();
                proPathParameters.aRetroDiff = (double[])aRetroDiff.clone();
                proPathParameters.aGlobalRaw = (double[])aGlobalMeteo.clone();
            }
        }
        if (exportAttenuationMatrix) {
            proPathParameters.keepAbsorption = true;
            proPathParameters.aDiv = (double[])aDiv.clone();
            proPathParameters.aAtm = (double[])aAtm.clone();
        }
        double[] aGlobalMeteoRay = new double[aGlobalMeteo.length];
        double probability = data.getWindRose()[roseIndex];
        if (!proPathParameters.isFavourable()) {
            probability = 1.0 - probability;
        }
        for (int i = 0; i < aGlobalMeteoRay.length; ++i) {
            aGlobalMeteoRay[i] = AcousticIndicatorsFunctions.wToDb((double)(probability * AcousticIndicatorsFunctions.dBToW((double)aGlobalMeteo[i])));
        }
        int sourceId = proPathParameters.getCutProfile().getSource().id;
        double sourceLi = proPathParameters.getCutProfile().getSource().li;
        if (scene != null && !scene.isOmnidirectional(sourceId)) {
            Orientation directivityToPick = proPathParameters.raySourceReceiverDirectivity;
            double[] attSource = scene.getSourceAttenuation(sourceId, frequencies, Math.toRadians(directivityToPick.yaw), Math.toRadians(directivityToPick.pitch));
            if (exportAttenuationMatrix) {
                proPathParameters.aSource = attSource;
            }
            aGlobalMeteoRay = AcousticIndicatorsFunctions.sumArray((double[])aGlobalMeteoRay, (double[])attSource);
        }
        if (sourceLi > 1.0) {
            for (int i = 0; i < aGlobalMeteoRay.length; ++i) {
                aGlobalMeteoRay[i] = AcousticIndicatorsFunctions.wToDb((double)(AcousticIndicatorsFunctions.dBToW((double)aGlobalMeteoRay[i]) * sourceLi));
            }
        }
        if (exportAttenuationMatrix) {
            proPathParameters.aGlobal = (double[])aGlobalMeteoRay.clone();
        }
        return aGlobalMeteoRay;
    }
}

