/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.locationtech.jts.algorithm.CGAlgorithms3D;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.math.Vector2D;
import org.locationtech.jts.math.Vector3D;
import org.locationtech.jts.triangulate.quadedge.Vertex;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReceiver;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointReflection;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointSource;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointVEdgeDiffraction;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPointWall;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.CurvedProfileGenerator;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.GeometryUtils;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.JTSUtility;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.cnossos.CnossosPath;
import org.noise_planet.noisemodelling.propagation.cnossos.PointPath;
import org.noise_planet.noisemodelling.propagation.cnossos.SegmentPath;

public class CnossosPathBuilder {
    public static final double ALPHA0 = 2.0E-4;
    private static final double EPSILON = 1.0E-7;

    public static void computeRayleighDiff(SegmentPath srSeg, CutProfile cutProfile, CnossosPath pathParameters, LineSegment dSR, List<SegmentPath> segments, List<PointPath> points, List<Coordinate> pts2D, Coordinate[] pts2DGround, List<Integer> cut2DGroundIndex, List<Double> exactFrequencyArray) {
        ArrayList cuts = cutProfile.cutPoints;
        Coordinate src = pts2D.get(0);
        Coordinate rcv = pts2D.get(pts2D.size() - 1);
        CutPointSource srcCut = cutProfile.getSource();
        CutPointReceiver rcvCut = cutProfile.getReceiver();
        for (int i0Cut = 1; i0Cut < cuts.size() - 1; ++i0Cut) {
            int iO = cut2DGroundIndex.get(i0Cut);
            Coordinate o = pts2DGround[iO];
            double dSO = src.distance(o);
            double dOR = o.distance(rcv);
            double deltaH = (double)dSR.orientationIndex(o) * (dSO + dOR - srSeg.d);
            boolean rcrit = false;
            for (double f : exactFrequencyArray) {
                if (!(deltaH > -(340.0 / f) / 20.0)) continue;
                rcrit = true;
                break;
            }
            if (!rcrit) continue;
            rcrit = false;
            Coordinate[] soCoords = Arrays.copyOfRange(pts2DGround, 0, iO + 1);
            double[] abs = JTSUtility.getMeanPlaneCoefficients((Coordinate[])soCoords);
            SegmentPath seg1 = CnossosPathBuilder.computeSegment(src, o, abs);
            Coordinate[] orCoords = Arrays.copyOfRange(pts2DGround, iO, pts2DGround.length);
            double[] abr = JTSUtility.getMeanPlaneCoefficients((Coordinate[])orCoords);
            SegmentPath seg2 = CnossosPathBuilder.computeSegment(o, rcv, abr);
            Coordinate srcPrime = new Coordinate(src.x + (seg1.sMeanPlane.x - src.x) * 2.0, src.y + (seg1.sMeanPlane.y - src.y) * 2.0);
            Coordinate rcvPrime = new Coordinate(rcv.x + (seg2.rMeanPlane.x - rcv.x) * 2.0, rcv.y + (seg2.rMeanPlane.y - rcv.y) * 2.0);
            LineSegment dSPrimeRPrime = new LineSegment(srcPrime, rcvPrime);
            srSeg.dPrime = srcPrime.distance(rcvPrime);
            seg1.dPrime = srcPrime.distance(o);
            seg2.dPrime = o.distance(rcvPrime);
            double deltaPrimeH = (double)dSPrimeRPrime.orientationIndex(o) * (seg1.dPrime + seg2.dPrime - srSeg.dPrime);
            for (double f : exactFrequencyArray) {
                if (!(deltaH > 340.0 / f / 4.0 - deltaPrimeH)) continue;
                rcrit = true;
                break;
            }
            if (!rcrit) continue;
            seg1.setGpath(cutProfile.getGPath((CutPoint)srcCut, (CutPoint)cuts.get(i0Cut), 0.0), srcCut.getGroundCoefficient());
            seg2.setGpath(cutProfile.getGPath((CutPoint)cuts.get(i0Cut), (CutPoint)rcvCut, 0.0), srcCut.getGroundCoefficient());
            double dSPrimeO = seg1.sPrime.distance(o);
            double dSPrimeR = seg1.sPrime.distance(rcv);
            double dORPrime = o.distance(seg2.rPrime);
            double dSRPrime = src.distance(seg2.rPrime);
            if (!pathParameters.isFavourable()) {
                pathParameters.delta = deltaH;
                pathParameters.deltaPrime = deltaPrimeH;
                LineSegment sPrimeR = new LineSegment(seg1.sPrime, rcv);
                pathParameters.deltaSPrimeR = (double)sPrimeR.orientationIndex(o) * (dSPrimeO + dOR - dSPrimeR);
                LineSegment sRPrime = new LineSegment(src, seg2.rPrime);
                pathParameters.deltaSRPrime = (double)sRPrime.orientationIndex(o) * (dSO + dORPrime - dSRPrime);
            } else {
                Coordinate pA;
                double dOnR = seg2.d;
                double dSO0 = seg1.d;
                pathParameters.deltaSPrimeR = CurvedProfileGenerator.toCurve((double)dSPrimeO, (double)dSPrimeR) + CurvedProfileGenerator.toCurve((double)pathParameters.e, (double)dSPrimeR) + CurvedProfileGenerator.toCurve((double)dOnR, (double)dSPrimeR) - CurvedProfileGenerator.toCurve((double)dSPrimeR, (double)dSPrimeR);
                pathParameters.deltaSRPrime = CurvedProfileGenerator.toCurve((double)dSO0, (double)dSRPrime) + CurvedProfileGenerator.toCurve((double)pathParameters.e, (double)dSRPrime) + CurvedProfileGenerator.toCurve((double)dORPrime, (double)dSRPrime) - CurvedProfileGenerator.toCurve((double)dSRPrime, (double)dSRPrime);
                if (dSR.orientationIndex(o) == 1) {
                    pathParameters.delta = CurvedProfileGenerator.toCurve((double)dSO, (double)srSeg.d) + CurvedProfileGenerator.toCurve((double)dOR, (double)srSeg.d) - CurvedProfileGenerator.toCurve((double)srSeg.d, (double)srSeg.d);
                } else {
                    pA = dSR.pointAlong((o.x - src.x) / (rcv.x - src.x));
                    pathParameters.delta = 2.0 * CurvedProfileGenerator.toCurve((double)src.distance(pA), (double)srSeg.d) + 2.0 * CurvedProfileGenerator.toCurve((double)pA.distance(rcv), (double)srSeg.d) - CurvedProfileGenerator.toCurve((double)dSO, (double)srSeg.d) - CurvedProfileGenerator.toCurve((double)dOR, (double)srSeg.d) - CurvedProfileGenerator.toCurve((double)srSeg.d, (double)srSeg.d);
                }
                if (dSPrimeRPrime.orientationIndex(o) == 1) {
                    pathParameters.deltaPrime = CurvedProfileGenerator.toCurve((double)seg1.dPrime, (double)srSeg.dPrime) + CurvedProfileGenerator.toCurve((double)seg2.dPrime, (double)srSeg.dPrime) - CurvedProfileGenerator.toCurve((double)srSeg.dPrime, (double)srSeg.dPrime);
                } else {
                    pA = dSPrimeRPrime.pointAlong((o.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
                    pathParameters.deltaPrime = 2.0 * CurvedProfileGenerator.toCurve((double)srcPrime.distance(pA), (double)srSeg.dPrime) + 2.0 * CurvedProfileGenerator.toCurve((double)pA.distance(srcPrime), (double)srSeg.dPrime) - CurvedProfileGenerator.toCurve((double)seg1.dPrime, (double)srSeg.dPrime) - CurvedProfileGenerator.toCurve((double)seg2.dPrime, (double)srSeg.d) - CurvedProfileGenerator.toCurve((double)srSeg.dPrime, (double)srSeg.dPrime);
                }
            }
            segments.add(seg1);
            segments.add(seg2);
            points.add(new PointPath(o, o.z, new ArrayList<Double>(), PointPath.POINT_TYPE.DIFH_RCRIT));
        }
    }

    public static SegmentPath computeSegment(Coordinate src, Coordinate rcv, double[] meanPlane) {
        return CnossosPathBuilder.computeSegment(src, rcv, meanPlane, 0.0, 0.0);
    }

    public static SegmentPath computeSegment(Coordinate src, Coordinate rcv, double[] meanPlane, double gPath, double gS) {
        SegmentPath seg = new SegmentPath();
        Coordinate sourcePointOnMeanPlane = GeometryUtils.projectPointOnLine((Coordinate)src, (double)meanPlane[0], (double)meanPlane[1]);
        Coordinate receiverPointOnMeanPlane = GeometryUtils.projectPointOnLine((Coordinate)rcv, (double)meanPlane[0], (double)meanPlane[1]);
        Vector2D sourceToProjectedPoint = Vector2D.create((Coordinate)src, (Coordinate)sourcePointOnMeanPlane);
        Vector2D receiverToProjectedPoint = Vector2D.create((Coordinate)rcv, (Coordinate)receiverPointOnMeanPlane);
        seg.s = src;
        seg.r = rcv;
        seg.sMeanPlane = sourcePointOnMeanPlane;
        seg.rMeanPlane = receiverPointOnMeanPlane;
        seg.sPrime = Vector2D.create((Coordinate)sourcePointOnMeanPlane).add(sourceToProjectedPoint).toCoordinate();
        seg.rPrime = Vector2D.create((Coordinate)receiverPointOnMeanPlane).add(receiverToProjectedPoint).toCoordinate();
        seg.d = src.distance(rcv);
        seg.dp = sourcePointOnMeanPlane.distance(receiverPointOnMeanPlane);
        seg.zsH = src.distance(sourcePointOnMeanPlane);
        seg.zrH = rcv.distance(receiverPointOnMeanPlane);
        seg.a = meanPlane[0];
        seg.b = meanPlane[1];
        seg.testFormH = seg.dp / (30.0 * (seg.zsH + seg.zrH));
        seg.gPath = gPath;
        seg.gPathPrime = seg.testFormH <= 1.0 ? seg.gPath * seg.testFormH + gS * (1.0 - seg.testFormH) : seg.gPath;
        double deltaZT = 0.006 * seg.dp / (seg.zsH + seg.zrH);
        double deltaZS = 2.0E-4 * Math.pow(seg.zsH / (seg.zsH + seg.zrH), 2.0) * (seg.dp * seg.dp / 2.0);
        seg.zsF = seg.zsH + deltaZS + deltaZT;
        double deltaZR = 2.0E-4 * Math.pow(seg.zrH / (seg.zsH + seg.zrH), 2.0) * (seg.dp * seg.dp / 2.0);
        seg.zrF = seg.zrH + deltaZR + deltaZT;
        seg.testFormF = seg.dp / (30.0 * (seg.zsF + seg.zrF));
        return seg;
    }

    public static List<CnossosPath> computeCnossosPathsFromCutProfile(CutProfile cutProfile, boolean bodyBarrier, List<Double> exactFrequencyArray, double gS) {
        CnossosPath cnossosPath;
        ArrayList<CnossosPath> cnossosPaths = new ArrayList<CnossosPath>();
        if (cutProfile.profileType == CutProfile.PROFILE_TYPE.DIRECT || cutProfile.profileType == CutProfile.PROFILE_TYPE.REFLECTION) {
            CnossosPath cnossosPath2 = CnossosPathBuilder.computeCnossosPathFromCutProfile(cutProfile, bodyBarrier, exactFrequencyArray, gS, false);
            if (cnossosPath2 != null) {
                cnossosPaths.add(cnossosPath2);
            }
            if ((cnossosPath2 = CnossosPathBuilder.computeCnossosPathFromCutProfile(cutProfile, bodyBarrier, exactFrequencyArray, gS, true)) != null) {
                cnossosPaths.add(cnossosPath2);
            }
        } else if ((cutProfile.profileType == CutProfile.PROFILE_TYPE.LEFT || cutProfile.profileType == CutProfile.PROFILE_TYPE.RIGHT) && (cnossosPath = CnossosPathBuilder.computeCnossosPathFromCutProfile(cutProfile, bodyBarrier, exactFrequencyArray, gS, cutProfile.curvedPath)) != null) {
            cnossosPaths.add(cnossosPath);
        }
        return cnossosPaths;
    }

    public static CnossosPath computeCnossosPathFromCutProfile(CutProfile cutProfile, boolean bodyBarrier, List<Double> exactFrequencyArray, double gS, boolean favourable) {
        int i1;
        int i0;
        int i;
        if (favourable && (cutProfile.profileType == CutProfile.PROFILE_TYPE.LEFT || cutProfile.profileType == CutProfile.PROFILE_TYPE.RIGHT) && !cutProfile.isCurvedPath()) {
            throw new IllegalArgumentException("A favourable path cannot be computed using lateral non curved cut profile");
        }
        ArrayList<SegmentPath> segments = new ArrayList<SegmentPath>();
        ArrayList<PointPath> points = new ArrayList<PointPath>();
        ArrayList cutProfilePoints = cutProfile.cutPoints;
        List pts2D = cutProfile.computePts2D();
        if (pts2D.size() != cutProfilePoints.size()) {
            throw new IllegalArgumentException("The two arrays size should be the same");
        }
        ArrayList<Integer> cut2DGroundIndex = new ArrayList<Integer>(cutProfilePoints.size());
        Coordinate[] pts2DGround = cutProfile.computePts2DGround(cut2DGroundIndex).toArray(new Coordinate[0]);
        double[] meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])pts2DGround);
        Coordinate firstPts2D = (Coordinate)pts2D.get(0);
        Coordinate lastPts2D = (Coordinate)pts2D.get(pts2D.size() - 1);
        SegmentPath srPath = CnossosPathBuilder.computeSegment(firstPts2D, lastPts2D, meanPlane, cutProfile.getGPath(), cutProfile.getSource().groundCoefficient);
        srPath.setPoints2DGround(pts2DGround);
        srPath.dc = CGAlgorithms3D.distance((Coordinate)cutProfile.getReceiver().getCoordinate(), (Coordinate)cutProfile.getSource().getCoordinate());
        CnossosPath cnossosPath = new CnossosPath(cutProfile);
        cnossosPath.setFavourable(favourable);
        cnossosPath.setPointList(points);
        cnossosPath.setSegmentList(segments);
        cnossosPath.setSRSegment(srPath);
        cnossosPath.init(exactFrequencyArray.size());
        List hullPts2D = pts2D;
        if (favourable && cutProfile.profileType != CutProfile.PROFILE_TYPE.REFLECTION) {
            hullPts2D = cutProfile.computePts2D(true);
        }
        List hullPointsIndices = cutProfile.getConvexHullIndices(hullPts2D);
        Coordinate src = cutProfile.getSource().getCoordinate();
        if (hullPointsIndices.size() > 2) {
            for (i = 1; i < hullPointsIndices.size(); ++i) {
                i0 = (Integer)hullPointsIndices.get(i - 1);
                i1 = (Integer)hullPointsIndices.get(i);
                LineSegment segmentHull = new LineSegment((Coordinate)pts2D.get((Integer)hullPointsIndices.get(i - 1)), (Coordinate)pts2D.get((Integer)hullPointsIndices.get(i)));
                for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                    CutPoint currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                    if (!(currentPoint instanceof CutPointReflection) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0) continue;
                    CutPointReflection cutPointReflection = (CutPointReflection)currentPoint;
                    Coordinate interpolatedReflectionPoint = segmentHull.closestPoint((Coordinate)pts2D.get(pointIndex));
                    double wallAltitudeAtReflexionPoint = Vertex.interpolateZ((Coordinate)currentPoint.coordinate, (Coordinate)cutPointReflection.wall.p0, (Coordinate)cutPointReflection.wall.p1);
                    if (wallAltitudeAtReflexionPoint + 1.0E-7 >= interpolatedReflectionPoint.y) {
                        currentPoint.getCoordinate().setZ(interpolatedReflectionPoint.y);
                        ((Coordinate)pts2D.get(pointIndex)).setY(interpolatedReflectionPoint.y);
                        continue;
                    }
                    return null;
                }
            }
        }
        for (i = 1; i < hullPointsIndices.size(); ++i) {
            CutPoint currentPoint;
            i0 = (Integer)hullPointsIndices.get(i - 1);
            i1 = (Integer)hullPointsIndices.get(i);
            int i0Ground = (Integer)cut2DGroundIndex.get(i0);
            int i1Ground = (Integer)cut2DGroundIndex.get(i1);
            CutPoint cutPt0 = (CutPoint)cutProfilePoints.get(i0);
            CutPoint cutPt1 = (CutPoint)cutProfilePoints.get(i1);
            if (i1Ground - 1 > i0Ground && cutPt1 instanceof CutPointWall) {
                CutPointWall cutPt1Wall = (CutPointWall)cutPt1;
                if (cutPt1Wall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.BUILDING_ENTER)) {
                    --i1Ground;
                } else if (cutPt1Wall.intersectionType.equals((Object)CutPointWall.INTERSECTION_TYPE.THIN_WALL_ENTER_EXIT)) {
                    i1Ground -= 2;
                }
            }
            if (points.isEmpty()) {
                Orientation emissionDirection;
                points.add(new PointPath((Coordinate)pts2D.get(i0), cutPt0.getzGround(), PointPath.POINT_TYPE.SRCE));
                Coordinate targetPosition = ((CutPoint)cutProfilePoints.get(i1)).getCoordinate();
                for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                    currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                    if (!(currentPoint instanceof CutPointReflection) && !(currentPoint instanceof CutPointVEdgeDiffraction) || Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) == 0) continue;
                    targetPosition = currentPoint.getCoordinate();
                    break;
                }
                ((PointPath)points.get((int)0)).orientation = emissionDirection = CnossosPathBuilder.computeOrientation(cutProfile.getSource().orientation, ((CutPoint)cutProfilePoints.get(i0)).getCoordinate(), targetPosition);
                cnossosPath.raySourceReceiverDirectivity = emissionDirection;
                src = (Coordinate)pts2D.get(i0);
            }
            int previousPivotPoint = i0;
            for (int pointIndex = i0 + 1; pointIndex < i1; ++pointIndex) {
                currentPoint = (CutPoint)cutProfilePoints.get(pointIndex);
                if (currentPoint instanceof CutPointReflection && Double.compare(currentPoint.getCoordinate().z, currentPoint.getzGround()) != 0) {
                    CutPointReflection cutPointReflection = (CutPointReflection)currentPoint;
                    double wallAltitudeAtReflexionPoint = Vertex.interpolateZ((Coordinate)cutPointReflection.coordinate, (Coordinate)cutPointReflection.wall.p0, (Coordinate)cutPointReflection.wall.p1);
                    PointPath reflectionPoint = new PointPath((Coordinate)pts2D.get(pointIndex), (double)currentPoint.getzGround(), cutPointReflection.wallAlpha, PointPath.POINT_TYPE.REFL);
                    reflectionPoint.obstacleZ = wallAltitudeAtReflexionPoint;
                    points.add(reflectionPoint);
                    continue;
                }
                if (!(currentPoint instanceof CutPointVEdgeDiffraction)) continue;
                PointPath diffractionPoint = new PointPath((Coordinate)pts2D.get(pointIndex), (double)currentPoint.getzGround(), new ArrayList<Double>(), PointPath.POINT_TYPE.DIFV);
                points.add(diffractionPoint);
                Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i0Ground, (Integer)cut2DGroundIndex.get(pointIndex) + 1);
                meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
                SegmentPath seg = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(previousPivotPoint), (Coordinate)pts2D.get(pointIndex), meanPlane, cutProfile.getGPath(cutPt0, (CutPoint)cutProfilePoints.get(pointIndex), 0.0), gS);
                seg.setPoints2DGround(segmentGroundPoints);
                previousPivotPoint = pointIndex;
                segments.add(seg);
            }
            points.add(new PointPath((Coordinate)pts2D.get(i1), cutPt1.getzGround(), PointPath.POINT_TYPE.RECV));
            if (previousPivotPoint != i0 && i == hullPointsIndices.size() - 1) {
                Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i1Ground, pts2DGround.length);
                meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
                SegmentPath seg = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(previousPivotPoint), (Coordinate)pts2D.get(pts2D.size() - 1), meanPlane, cutProfile.getGPath(cutPt1, (CutPoint)cutProfilePoints.get(cutProfilePoints.size() - 1), 0.0), gS);
                seg.setPoints2DGround(segmentGroundPoints);
                segments.add(seg);
            }
            if (hullPointsIndices.size() == 2) break;
            Coordinate[] segmentGroundPoints = Arrays.copyOfRange(pts2DGround, i0Ground, i1Ground + 1);
            meanPlane = JTSUtility.getMeanPlaneCoefficients((Coordinate[])segmentGroundPoints);
            SegmentPath path = CnossosPathBuilder.computeSegment((Coordinate)pts2D.get(i0), (Coordinate)pts2D.get(i1), meanPlane, cutProfile.getGPath((CutPoint)cutProfilePoints.get(i0), (CutPoint)cutProfilePoints.get(i1), 0.0), ((CutPoint)cutProfilePoints.get((int)i0)).groundCoefficient);
            path.dc = cutPt0.getCoordinate().distance3D(cutPt1.getCoordinate());
            path.setPoints2DGround(segmentGroundPoints);
            segments.add(path);
            if (i == hullPointsIndices.size() - 1) continue;
            PointPath pt = (PointPath)points.get(points.size() - 1);
            pt.type = PointPath.POINT_TYPE.DIFH;
            pt.bodyBarrier = bodyBarrier;
            if (!(cutPt1 instanceof CutPointWall)) continue;
            pt.alphaWall = ((CutPointWall)cutPt1).wallAlpha;
        }
        if (points.isEmpty()) {
            return null;
        }
        Coordinate rcv = ((PointPath)points.get((int)(points.size() - 1))).coordinate;
        PointPath p0 = points.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).findFirst().orElse(null);
        if (p0 == null) {
            boolean horizontalPlaneDiffraction = cutProfile.cutPoints.stream().anyMatch(cutPoint -> cutPoint instanceof CutPointVEdgeDiffraction);
            ArrayList<SegmentPath> rayleighSegments = new ArrayList<SegmentPath>();
            ArrayList<PointPath> rayleighPoints = new ArrayList<PointPath>();
            if (!horizontalPlaneDiffraction) {
                LineSegment dSR = new LineSegment(firstPts2D, lastPts2D);
                CnossosPathBuilder.computeRayleighDiff(srPath, cutProfile, cnossosPath, dSR, rayleighSegments, rayleighPoints, pts2D, pts2DGround, cut2DGroundIndex, exactFrequencyArray);
            }
            if (rayleighSegments.isEmpty()) {
                if (segments.isEmpty()) {
                    segments.add(cnossosPath.getSRSegment());
                }
                cnossosPath.e = 0.0;
                List diffPoints = points.stream().filter(pointPath -> pointPath.type != PointPath.POINT_TYPE.REFL).collect(Collectors.toList());
                for (int idPoint = 1; idPoint < diffPoints.size() - 2; ++idPoint) {
                    cnossosPath.e += ((PointPath)diffPoints.get((int)idPoint)).coordinate.distance(((PointPath)diffPoints.get((int)(idPoint + 1))).coordinate);
                }
                long difVPointCount = cnossosPath.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
                double distance = difVPointCount == 0L ? cnossosPath.getSRSegment().d : cnossosPath.getSRSegment().dc;
                cnossosPath.delta = ((SegmentPath)segments.get((int)0)).d + cnossosPath.e + ((SegmentPath)segments.get((int)(segments.size() - 1))).d - distance;
            } else {
                segments.addAll(rayleighSegments);
                points.addAll(1, rayleighPoints);
            }
            return cnossosPath;
        }
        Coordinate c0 = p0.coordinate;
        PointPath pn = points.stream().filter(p -> p.type.equals((Object)PointPath.POINT_TYPE.DIFH)).reduce((first, second) -> second).orElse(null);
        if (pn == null) {
            return null;
        }
        Coordinate cn = pn.coordinate;
        SegmentPath seg1 = (SegmentPath)segments.get(0);
        SegmentPath seg2 = (SegmentPath)segments.get(segments.size() - 1);
        double dSO0 = seg1.d;
        double dOnR = seg2.d;
        LineSegment sr = new LineSegment(src, rcv);
        LineSegment sPrimeR = new LineSegment(seg1.sPrime, rcv);
        double dSPrimeR = seg1.sPrime.distance(rcv);
        double dSPrimeO = seg1.sPrime.distance(c0);
        cnossosPath.e = 0.0;
        List diffPoints = points.stream().filter(pointPath -> pointPath.type != PointPath.POINT_TYPE.REFL).collect(Collectors.toList());
        for (int idPoint = 1; idPoint < diffPoints.size() - 2; ++idPoint) {
            cnossosPath.e += ((PointPath)diffPoints.get((int)idPoint)).coordinate.distance(((PointPath)diffPoints.get((int)(idPoint + 1))).coordinate);
        }
        cnossosPath.deltaSPrimeR = favourable ? CurvedProfileGenerator.toCurve((double)dSPrimeO, (double)dSPrimeR) + CurvedProfileGenerator.toCurve((double)cnossosPath.e, (double)dSPrimeR) + CurvedProfileGenerator.toCurve((double)dOnR, (double)dSPrimeR) - CurvedProfileGenerator.toCurve((double)dSPrimeR, (double)dSPrimeR) : (double)sPrimeR.orientationIndex(c0) * (dSPrimeO + cnossosPath.e + dOnR - dSPrimeR);
        LineSegment sRPrime = new LineSegment(src, seg2.rPrime);
        double dSRPrime = src.distance(seg2.rPrime);
        double dORPrime = cn.distance(seg2.rPrime);
        cnossosPath.deltaSRPrime = favourable ? CurvedProfileGenerator.toCurve((double)dSO0, (double)dSRPrime) + CurvedProfileGenerator.toCurve((double)cnossosPath.e, (double)dSRPrime) + CurvedProfileGenerator.toCurve((double)dORPrime, (double)dSRPrime) - CurvedProfileGenerator.toCurve((double)dSRPrime, (double)dSRPrime) : (double)((src.x > seg2.rPrime.x ? -1 : 1) * sRPrime.orientationIndex(cn)) * (dSO0 + cnossosPath.e + dORPrime - dSRPrime);
        Coordinate srcPrime = new Coordinate(src.x + (seg1.sMeanPlane.x - src.x) * 2.0, src.y + (seg1.sMeanPlane.y - src.y) * 2.0);
        Coordinate rcvPrime = new Coordinate(rcv.x + (seg2.rMeanPlane.x - rcv.x) * 2.0, rcv.y + (seg2.rMeanPlane.y - rcv.y) * 2.0);
        LineSegment dSPrimeRPrime = new LineSegment(srcPrime, rcvPrime);
        srPath.dPrime = srcPrime.distance(rcvPrime);
        seg1.dPrime = srcPrime.distance(c0);
        seg2.dPrime = cn.distance(rcvPrime);
        if (!favourable || cutProfile.profileType != CutProfile.PROFILE_TYPE.DIRECT && cutProfile.profileType != CutProfile.PROFILE_TYPE.REFLECTION) {
            long difVPointCount = cnossosPath.getPointList().stream().filter(pointPath -> pointPath.type.equals((Object)PointPath.POINT_TYPE.DIFV)).count();
            double distance = difVPointCount == 0L ? cnossosPath.getSRSegment().d : cnossosPath.getSRSegment().dc;
            cnossosPath.delta = (double)sr.orientationIndex(c0) * (dSO0 + cnossosPath.e + dOnR - distance);
        } else if (sr.orientationIndex(c0) == 1) {
            cnossosPath.delta = CurvedProfileGenerator.toCurve((double)seg1.d, (double)srPath.d) + CurvedProfileGenerator.toCurve((double)cnossosPath.e, (double)srPath.d) + CurvedProfileGenerator.toCurve((double)seg2.d, (double)srPath.d) - CurvedProfileGenerator.toCurve((double)srPath.d, (double)srPath.d);
        } else {
            Coordinate pA = sr.pointAlong((c0.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
            cnossosPath.delta = 2.0 * CurvedProfileGenerator.toCurve((double)srcPrime.distance(pA), (double)srPath.dPrime) + 2.0 * CurvedProfileGenerator.toCurve((double)pA.distance(rcvPrime), (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)seg1.dPrime, (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)seg2.dPrime, (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)srPath.dPrime, (double)srPath.dPrime);
        }
        if (!favourable) {
            cnossosPath.deltaPrime = (double)dSPrimeRPrime.orientationIndex(c0) * (seg1.dPrime + cnossosPath.e + seg2.dPrime - srPath.dPrime);
        } else if (dSPrimeRPrime.orientationIndex(c0) == 1) {
            cnossosPath.deltaPrime = CurvedProfileGenerator.toCurve((double)seg1.dPrime, (double)srPath.dPrime) + CurvedProfileGenerator.toCurve((double)seg2.dPrime, (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)srPath.dPrime, (double)srPath.dPrime);
        } else {
            Coordinate pA = dSPrimeRPrime.pointAlong((c0.x - srcPrime.x) / (rcvPrime.x - srcPrime.x));
            cnossosPath.deltaPrime = 2.0 * CurvedProfileGenerator.toCurve((double)srcPrime.distance(pA), (double)srPath.dPrime) + 2.0 * CurvedProfileGenerator.toCurve((double)pA.distance(srcPrime), (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)seg1.dPrime, (double)srPath.dPrime) - CurvedProfileGenerator.toCurve((double)seg2.dPrime, (double)srPath.d) - CurvedProfileGenerator.toCurve((double)srPath.dPrime, (double)srPath.dPrime);
        }
        return cnossosPath;
    }

    private static Orientation computeOrientation(Orientation sourceOrientation, Coordinate src, Coordinate next) {
        if (sourceOrientation == null) {
            return null;
        }
        Vector3D outgoingRay = new Vector3D(new Coordinate(next.x - src.x, next.y - src.y, next.z - src.z)).normalize();
        return Orientation.fromVector((Vector3D)Orientation.rotate((Orientation)sourceOrientation, (Vector3D)outgoingRay, (boolean)true), (double)0.0);
    }
}

