/*
 * Decompiled with CFR 0.152.
 */
package org.noise_planet.noisemodelling.propagation.cnossos;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.math.Vector3D;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutPoint;
import org.noise_planet.noisemodelling.pathfinder.profilebuilder.CutProfile;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.GeometryUtils;
import org.noise_planet.noisemodelling.pathfinder.utils.geometry.Orientation;
import org.noise_planet.noisemodelling.propagation.cnossos.PointPath;
import org.noise_planet.noisemodelling.propagation.cnossos.SegmentPath;

public class Path {
    public static final int FOOTER_RESERVED_SIZE = 120;
    CutProfile cutProfile;
    private SegmentPath srSegment;
    private List<PointPath> pointList;
    private List<SegmentPath> segmentList;
    private boolean favourable;
    private String timePeriod = "";
    Orientation sourceOrientation = new Orientation(0.0, 0.0, 0.0);
    public Orientation raySourceReceiverDirectivity = new Orientation();
    double gs;
    public boolean keepAbsorption = false;

    public Path() {
    }

    public Path(CutProfile cutProfile) {
        this.cutProfile = cutProfile;
        this.setSourceOrientation(cutProfile.getSource().orientation);
    }

    public Path(Path other) {
        this.cutProfile = other.cutProfile;
        this.srSegment = other.srSegment;
        this.pointList = other.pointList;
        this.segmentList = other.segmentList;
        this.favourable = other.favourable;
        this.timePeriod = other.timePeriod;
        this.sourceOrientation = other.sourceOrientation;
        this.raySourceReceiverDirectivity = other.raySourceReceiverDirectivity;
        this.gs = other.gs;
        this.keepAbsorption = other.keepAbsorption;
    }

    public List<CutPoint> getCutPoints() {
        if (this.cutProfile == null) {
            return new ArrayList<CutPoint>();
        }
        return this.cutProfile.cutPoints;
    }

    public CutProfile getCutProfile() {
        return this.cutProfile;
    }

    public void setCutProfile(CutProfile cutProfile) {
        this.cutProfile = cutProfile;
    }

    public String getTimePeriod() {
        return this.timePeriod;
    }

    public void setTimePeriod(String timePeriod) {
        this.timePeriod = timePeriod;
    }

    public Orientation getSourceOrientation() {
        return this.sourceOrientation;
    }

    public void setSourceOrientation(Orientation sourceOrientation) {
        this.sourceOrientation = sourceOrientation;
    }

    public Orientation getRaySourceReceiverDirectivity() {
        return this.raySourceReceiverDirectivity;
    }

    public void setRaySourceReceiverDirectivity(Orientation raySourceReceiverDirectivity) {
        this.raySourceReceiverDirectivity = raySourceReceiverDirectivity;
    }

    public double getGs() {
        return this.gs;
    }

    public void setGs(double gs) {
        this.gs = gs;
    }

    public LineString asGeom() {
        GeometryFactory geometryFactory = new GeometryFactory();
        Coordinate[] coordinates = new Coordinate[this.pointList == null ? 0 : this.pointList.size()];
        int i = 0;
        double cutPointDistance = 0.0;
        int cutPointCursor = 0;
        if (this.getCutPoints().isEmpty() || coordinates.length <= 1) {
            return geometryFactory.createLineString();
        }
        for (PointPath pointPath : this.pointList) {
            while (cutPointCursor < this.getCutPoints().size() - 1 && pointPath.coordinate.x > cutPointDistance) {
                cutPointDistance += this.getCutPoints().get(++cutPointCursor - 1).getCoordinate().distance(this.getCutPoints().get(cutPointCursor).getCoordinate());
            }
            Coordinate rayPoint = new Coordinate(this.getCutPoints().get(cutPointCursor).getCoordinate());
            rayPoint.setZ(pointPath.coordinate.y);
            if (cutPointCursor > 0) {
                Coordinate p0 = this.getCutPoints().get(cutPointCursor - 1).getCoordinate();
                Coordinate p1 = this.getCutPoints().get(cutPointCursor).getCoordinate();
                double distanceP0P1 = p1.distance(p0);
                double ratio = Math.min(1.0, Math.max(0.0, (pointPath.coordinate.x - (cutPointDistance - distanceP0P1)) / distanceP0P1));
                rayPoint = new LineSegment(p0, p1).pointAlong(ratio);
                rayPoint.setZ(pointPath.coordinate.y);
            }
            coordinates[i++] = new Coordinate(rayPoint);
        }
        return geometryFactory.createLineString(coordinates);
    }

    public List<PointPath> getPointList() {
        return this.pointList;
    }

    public List<SegmentPath> getSegmentList() {
        return this.segmentList;
    }

    public SegmentPath getSRSegment() {
        return this.srSegment;
    }

    public void setPointList(List<PointPath> pointList) {
        this.pointList = pointList;
    }

    public void setSegmentList(List<SegmentPath> segmentList) {
        this.segmentList = segmentList;
    }

    public void setSRSegment(SegmentPath srSegment) {
        this.srSegment = srSegment;
    }

    public Path(List<SegmentPath> segmentList) {
        this.segmentList = segmentList;
    }

    public boolean isFavourable() {
        return this.favourable;
    }

    public void setFavourable(boolean favourable) {
        this.favourable = favourable;
    }

    double computeZs(SegmentPath segmentPath) {
        double zs = this.pointList.get((int)segmentPath.idPtStart).coordinate.z - GeometryUtils.projectPointOnSegment((Coordinate)this.pointList.get((int)segmentPath.idPtStart).coordinate, (Vector3D)segmentPath.meanGdPlane, (Coordinate)segmentPath.pInit).z;
        return zs > 0.0 ? zs : 0.0;
    }

    public double computeZr(SegmentPath segmentPath) {
        double zr = this.pointList.get((int)segmentPath.idPtFinal).coordinate.z - GeometryUtils.projectPointOnSegment((Coordinate)this.pointList.get((int)segmentPath.idPtFinal).coordinate, (Vector3D)segmentPath.meanGdPlane, (Coordinate)segmentPath.pInit).z;
        return zr > 0.0 ? zr : 0.0;
    }

    public double computeZsPrime(SegmentPath segmentPath) {
        double alpha0 = 2.0 * Math.pow(10.0, -4.0);
        double deltazt = 6.0 * Math.pow(10.0, -3.0) * segmentPath.dp / (segmentPath.zsH + segmentPath.zrH);
        double deltazs = alpha0 * Math.pow(segmentPath.zsH / (segmentPath.zsH + segmentPath.zrH), 2.0) * (Math.pow(segmentPath.dp, 2.0) / 2.0);
        return segmentPath.zsH + deltazs + deltazt;
    }

    public double computeZrPrime(SegmentPath segmentPath) {
        double alpha0 = 2.0 * Math.pow(10.0, -4.0);
        double deltazt = 6.0 * Math.pow(10.0, -3.0) * segmentPath.dp / (segmentPath.zsH + segmentPath.zrH);
        double deltazr = alpha0 * Math.pow(segmentPath.zrH / (segmentPath.zsH + segmentPath.zrH), 2.0) * (Math.pow(segmentPath.dp, 2.0) / 2.0);
        return segmentPath.zrH + deltazr + deltazt;
    }

    private double getRayCurveLength(double dSeg, double d) {
        double gamma = Math.max(1000.0, 8.0 * d);
        return 2.0 * gamma * Math.asin(dSeg / (2.0 * gamma));
    }

    public static void writeCoordinate(DataOutputStream out, Coordinate p) throws IOException {
        out.writeDouble(p.x);
        out.writeDouble(p.y);
        out.writeDouble(p.z);
    }

    public static Coordinate readCoordinate(DataInputStream in) throws IOException {
        return new Coordinate(in.readDouble(), in.readDouble(), in.readDouble());
    }

    public static void writeVector(DataOutputStream out, Vector3D p) throws IOException {
        out.writeDouble(p.getX());
        out.writeDouble(p.getY());
        out.writeDouble(p.getZ());
    }

    public static Vector3D readVector(DataInputStream in) throws IOException {
        return new Vector3D(in.readDouble(), in.readDouble(), in.readDouble());
    }
}

