/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph;

import java.util.Collection;
import java.util.Observer;
import java.util.Set;
import java.util.stream.Stream;
import org.nongnu.multigraph.Edge;
import org.nongnu.multigraph.PluggableObservable;

public interface Graph<N, E>
extends Set<N> {
    public boolean is_directed();

    public boolean is_simple();

    public void set(N var1, N var2, E var3);

    public void set(N var1, N var2, E var3, int var4);

    @Override
    public boolean add(N var1);

    public boolean remove(N var1, N var2, E var3);

    public boolean remove(N var1, N var2);

    public void clear_all_edges();

    default public void clear(N from) {
        for (Edge<N, E> e : this.edges(from)) {
            this.remove(e.from(), e.to());
        }
    }

    public int edge_outdegree(N var1);

    public int nodal_outdegree(N var1);

    public float avg_nodal_degree();

    public long link_count();

    public int max_nodal_degree();

    public Set<N> successors(N var1);

    public Set<Edge<N, E>> edges(N var1);

    public Stream<Edge<N, E>> stream(N var1);

    public Collection<Edge<N, E>> edges(N var1, N var2);

    public Edge<N, E> edge(N var1, N var2);

    public boolean is_linked(N var1, N var2);

    public Edge<N, E> edge(N var1, N var2, E var3);

    public Iterable<N> random_node_iterable();

    public Iterable<Edge<N, E>> random_edge_iterable(N var1);

    public void addObserver(Observer var1);

    public int countObservers();

    public void deleteObserver(Observer var1);

    public void deleteObservers();

    public boolean hasChanged();

    public void notifyObservers();

    public void notifyObservers(Object var1);

    public void plugObservable();

    public void unplugObservable();

    public PluggableObservable edge_events();
}

