/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.layout;

import java.awt.Dimension;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.layout.Layout;
import org.nongnu.multigraph.layout.PositionableNode;
import org.nongnu.multigraph.layout.Vector2D;

public class RadialLayout<N extends PositionableNode, E>
extends Layout<N, E> {
    public RadialLayout(Graph<N, E> graph, Dimension bound, int maxiterations) {
        super(graph, bound, maxiterations);
    }

    @Override
    public boolean layout(float interval) {
        double radius = (double)Math.min(this.bound.width, this.bound.height) / 2.0;
        double sweep = Math.PI * 2 / (double)this.graph.size();
        Vector2D v = new Vector2D(0.0, radius);
        for (PositionableNode node : this.graph) {
            node.getPosition().setLocation(v);
            v.rotate(sweep);
            debug.println("v: " + v);
        }
        return false;
    }
}

