/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.multigraph.rewire;

import org.nongnu.multigraph.EdgeLabeler;
import org.nongnu.multigraph.Graph;
import org.nongnu.multigraph.debug;
import org.nongnu.multigraph.rewire.ScaleFreeRewire;

public class MultiClassScaleFreeRewire<N, E>
extends ScaleFreeRewire<N, E> {
    protected int p = 1;
    private ScaleFreeRewire.m_modes p_mode = ScaleFreeRewire.m_modes.STRICT;

    public int p() {
        return this.p;
    }

    public MultiClassScaleFreeRewire<N, E> p(int p) {
        if (p >= this.graph.size()) {
            throw new IllegalArgumentException("p must be less than the graph size");
        }
        if (p < 0) {
            throw new IllegalArgumentException("p must be >= 0");
        }
        this.p = p;
        return this;
    }

    public MultiClassScaleFreeRewire(Graph<N, E> graph, EdgeLabeler<N, E> el) {
        super(graph, el);
    }

    protected boolean consider_similar_link(N vi, N vj, int numnodes, int numlinks) {
        int ki = this.graph.nodal_outdegree(vi);
        int kj = this.graph.nodal_outdegree(vj);
        float fr = this.r.nextFloat();
        double pi = (double)(kj * ki) / (double)(4 * numlinks * numlinks);
        debug.printf("consider_similar_link: %5d, %5d, %6d, %6d: %10d/%10d = %8f >= %8f ? %s\n", kj, ki, numlinks, numnodes, kj * ki, 4 * numlinks * numlinks, pi, Float.valueOf(fr), (double)fr <= pi ? "y" : " ");
        return (double)fr <= pi;
    }

    protected int add_like_links(int split, int numlinks) {
        int added = 0;
        int pass = 0;
        do {
            for (int i = 0; i < split && !MultiClassScaleFreeRewire.m_mode_stop(this.p_mode, this.p, added, pass); ++i) {
                for (int j = i + 1; j < split && !MultiClassScaleFreeRewire.m_mode_stop(this.p_mode, this.p, added, pass); ++j) {
                    Object n1 = this.nodes[i];
                    Object n2 = this.nodes[j];
                    if (n1 == n2 || !this.consider_similar_link(n1, n2, split, numlinks + added) || this.graph.is_linked(n1, n2)) continue;
                    this.add_link(n1, n2);
                    ++added;
                }
            }
        } while (!MultiClassScaleFreeRewire.m_mode_stop(this.p_mode, this.p, added, ++pass));
        return added;
    }

    @Override
    protected int rewire_callback(int split, int numlinks) {
        return this.add_like_links(split, numlinks);
    }
}

