/*
 * Copyright 2014 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * 	http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.nosceon.datolite.db;

import org.nosceon.datolite.Datolite;
import org.nosceon.datolite.Context;
import org.nosceon.datolite.PluginId;

import javax.sql.DataSource;
import java.sql.Connection;

/**
 * @author Johan Siebens
 */
public final class Db {

    public static final PluginId<DbPlugin> DB = new PluginId<DbPlugin>() {

        @Override
        protected DbPlugin create(Context context) {
            return new DbPluginImpl(context);
        }

    };

    public static DbPlugin plugin() {
        return Datolite.context().plugin(DB);
    }

    public static DbPlugin plugin(Context context) {
        return context.plugin(DB);
    }

    public static DataSource dataSource() {
        return plugin().dataSource();
    }

    public static DataSource dataSource(String configPath) {
        return plugin().dataSource(configPath);
    }

    public static Connection connection() {
        return plugin().connection();
    }

    public static Connection connection(boolean autoCommit) {
        return plugin().connection(autoCommit);
    }

    public static Connection connection(String configPath) {
        return plugin().connection(configPath);
    }

    public static Connection connection(String configPath, boolean autoCommit) {
        return plugin().connection(configPath, autoCommit);
    }

    public static <A> A withConnection(DbPlugin.ConnectionCallback<A> block) {
        return plugin().withConnection(block);
    }

    public static <A> A withConnection(String configPath, DbPlugin.ConnectionCallback<A> block) {
        return plugin().withConnection(configPath, block);
    }

    public static <A> A withTransaction(DbPlugin.ConnectionCallback<A> block) {
        return plugin().withTransaction(block);
    }

    public static <A> A withTransaction(String configPath, DbPlugin.ConnectionCallback<A> block) {
        return plugin().withTransaction(configPath, block);
    }

}
