/*
 * Decompiled with CFR 0.152.
 */
package org.nosceon.datolite.db;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.Statement;
import java.util.LinkedList;
import java.util.Queue;

class AutoCleanConnectionHandler
implements InvocationHandler {
    private final Connection target;
    private final Queue<Statement> statements;

    public AutoCleanConnectionHandler(Connection target) {
        this.target = target;
        this.statements = new LinkedList<Statement>();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            switch (method.getName()) {
                case "close": {
                    return this.handleClose(method, args);
                }
                case "createStatement": {
                    return this.statementMethod(method, args);
                }
                case "prepareStatement": {
                    return this.statementMethod(method, args);
                }
                case "prepareCall": {
                    return this.statementMethod(method, args);
                }
            }
            return method.invoke((Object)this.target, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private Object handleClose(Method method, Object[] args) throws Throwable {
        while (!this.statements.isEmpty()) {
            this.statements.poll().close();
        }
        return method.invoke((Object)this.target, args);
    }

    private Object statementMethod(Method method, Object[] args) throws Throwable {
        Statement statement = (Statement)method.invoke((Object)this.target, args);
        this.statements.add(statement);
        return statement;
    }
}

