/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.REngine.Rserve;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.REngine.REXPNull;
import org.rosuda.REngine.REngine;
import org.rosuda.REngine.REngineException;
import org.rosuda.REngine.Rserve.RFileInputStream;
import org.rosuda.REngine.Rserve.RFileOutputStream;
import org.rosuda.REngine.Rserve.RSession;
import org.rosuda.REngine.Rserve.RserveException;
import org.rosuda.REngine.Rserve.protocol.REXPFactory;
import org.rosuda.REngine.Rserve.protocol.RPacket;
import org.rosuda.REngine.Rserve.protocol.RTalk;
import org.rosuda.REngine.Rserve.protocol.jcrypt;

public class RConnection
extends REngine {
    String lastError = null;
    Socket s;
    boolean connected = false;
    InputStream is;
    OutputStream os;
    boolean authReq = false;
    int authType = 0;
    String Key = null;
    RTalk rt = null;
    String host;
    int port;
    public static String transferCharset = "UTF-8";
    public static final int AT_plain = 0;
    public static final int AT_crypt = 1;
    protected int rsrvVersion;

    public RConnection() throws RserveException {
        this("127.0.0.1", 6311);
    }

    public RConnection(String string) throws RserveException {
        this(string, 6311);
    }

    public RConnection(String string, int n) throws RserveException {
        this(string, n, null);
    }

    RConnection(RSession rSession) throws RserveException {
        this(null, 0, rSession);
    }

    RConnection(String string, int n, RSession rSession) throws RserveException {
        try {
            if (this.connected) {
                this.s.close();
            }
            this.s = null;
        }
        catch (Exception exception) {
            throw new RserveException(this, "Cannot connect: " + exception.getMessage());
        }
        if (rSession != null) {
            string = rSession.host;
            n = rSession.port;
        }
        this.connected = false;
        this.host = string;
        this.port = n;
        try {
            this.s = new Socket(string, n);
            this.s.setTcpNoDelay(true);
        }
        catch (Exception exception) {
            throw new RserveException(this, "Cannot connect: " + exception.getMessage());
        }
        try {
            this.is = this.s.getInputStream();
            this.os = this.s.getOutputStream();
        }
        catch (Exception exception) {
            throw new RserveException(this, "Cannot get io stream: " + exception.getMessage());
        }
        this.rt = new RTalk(this.is, this.os);
        if (rSession == null) {
            byte[] byArray = new byte[32];
            int n2 = -1;
            try {
                n2 = this.is.read(byArray);
            }
            catch (Exception exception) {
                throw new RserveException(this, "Error while receiving data: " + exception.getMessage());
            }
            try {
                if (n2 != 32) {
                    throw new RserveException(this, "Handshake failed: expected 32 bytes header, got " + n2);
                }
                String string2 = new String(byArray);
                if (string2.substring(0, 4).compareTo("Rsrv") != 0) {
                    throw new RserveException(this, "Handshake failed: Rsrv signature expected, but received \"" + string2 + "\" instead.");
                }
                try {
                    this.rsrvVersion = Integer.parseInt(string2.substring(4, 8));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.rsrvVersion > 103) {
                    throw new RserveException(this, "Handshake failed: The server uses more recent protocol than this client.");
                }
                if (string2.substring(8, 12).compareTo("QAP1") != 0) {
                    throw new RserveException(this, "Handshake failed: unupported transfer protocol (" + string2.substring(8, 12) + "), I talk only QAP1.");
                }
                for (int i = 12; i < 32; i += 4) {
                    String string3 = string2.substring(i, i + 4);
                    if (string3.compareTo("ARpt") == 0 && !this.authReq) {
                        this.authReq = true;
                        this.authType = 0;
                    }
                    if (string3.compareTo("ARuc") == 0) {
                        this.authReq = true;
                        this.authType = 1;
                    }
                    if (string3.charAt(0) != 'K') continue;
                    this.Key = string3.substring(1, 3);
                }
            }
            catch (RserveException rserveException) {
                try {
                    this.s.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.is = null;
                this.os = null;
                this.s = null;
                throw rserveException;
            }
        }
        try {
            this.os.write(rSession.key, 0, 32);
        }
        catch (Exception exception) {
            throw new RserveException(this, "Error while sending session key: " + exception.getMessage());
        }
        this.rsrvVersion = rSession.rsrvVersion;
        this.connected = true;
        this.lastError = "OK";
    }

    public void finalize() {
        this.close();
        this.is = null;
        this.is = null;
    }

    public int getServerVersion() {
        return this.rsrvVersion;
    }

    public boolean close() {
        try {
            if (this.s != null) {
                this.s.close();
            }
            this.connected = false;
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void voidEval(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(2, string + "\n");
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "voidEval failed", rPacket);
    }

    public RSession voidEvalDetach(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(49, string + "\n");
        if (rPacket == null || !rPacket.isOk()) {
            throw new RserveException(this, "detached void eval failed", rPacket);
        }
        RSession rSession = new RSession(this, rPacket);
        this.close();
        return rSession;
    }

    REXP parseEvalResponse(RPacket rPacket) throws RserveException {
        int n = 0;
        byte[] byArray = rPacket.getCont();
        if (this.rsrvVersion > 100) {
            n = 4;
            if (byArray[0] != 10 && byArray[0] != 74) {
                throw new RserveException(this, "Error while processing eval output: SEXP (type 10) expected but found result type " + byArray[0] + ".");
            }
            if (byArray[0] == 74) {
                n = 8;
            }
        }
        if (byArray.length > n) {
            try {
                REXPFactory rEXPFactory = new REXPFactory();
                rEXPFactory.parseREXP(byArray, n);
                return rEXPFactory.getREXP();
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
                throw new RserveException(this, "Error when parsing response: " + rEXPMismatchException.getMessage());
            }
        }
        return null;
    }

    public REXP eval(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(3, string + "\n");
        if (rPacket != null && rPacket.isOk()) {
            return this.parseEvalResponse(rPacket);
        }
        throw new RserveException(this, "eval failed", rPacket);
    }

    public void assign(String string, String string2) throws RserveException {
        int n;
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = string2.getBytes();
        int n2 = byArray.length + 1;
        int n3 = byArray2.length + 1;
        if ((n2 & 3) > 0) {
            n2 = (n2 & 0xFFFFFC) + 4;
        }
        if ((n3 & 3) > 0) {
            n3 = (n3 & 0xFFFFFC) + 4;
        }
        byte[] byArray3 = new byte[n2 + 4 + n3 + 4];
        for (n = 0; n < byArray.length; ++n) {
            byArray3[n + 4] = byArray[n];
        }
        while (n < n2) {
            byArray3[n + 4] = 0;
            ++n;
        }
        for (n = 0; n < byArray2.length; ++n) {
            byArray3[n + n2 + 8] = byArray2[n];
        }
        while (n < n3) {
            byArray3[n + n2 + 8] = 0;
            ++n;
        }
        RTalk.setHdr(4, n2, byArray3, 0);
        RTalk.setHdr(4, n3, byArray3, n2 + 4);
        RPacket rPacket = this.rt.request(32, byArray3);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "assign failed", rPacket);
    }

    public void assign(String string, REXP rEXP) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        try {
            int n;
            REXPFactory rEXPFactory = new REXPFactory(rEXP);
            int n2 = rEXPFactory.getBinaryLength();
            byte[] byArray = string.getBytes();
            int n3 = byArray.length + 1;
            if ((n3 & 3) > 0) {
                n3 = (n3 & 0xFFFFFC) + 4;
            }
            byte[] byArray2 = new byte[n3 + n2 + (n2 > 0xFFFFF0 ? 12 : 8)];
            for (n = 0; n < byArray.length; ++n) {
                byArray2[n + 4] = byArray[n];
            }
            while (n < n3) {
                byArray2[n + 4] = 0;
                ++n;
            }
            RTalk.setHdr(4, n3, byArray2, 0);
            RTalk.setHdr(10, n2, byArray2, n3 + 4);
            rEXPFactory.getBinaryRepresentation(byArray2, n3 + (n2 > 0xFFFFF0 ? 12 : 8));
            RPacket rPacket = this.rt.request(32, byArray2);
            if (rPacket != null && rPacket.isOk()) {
                return;
            }
            throw new RserveException(this, "assign failed", rPacket);
        }
        catch (REXPMismatchException rEXPMismatchException) {
            throw new RserveException(this, "Error creating binary representation: " + rEXPMismatchException.getMessage());
        }
    }

    public RFileInputStream openFile(String string) throws IOException {
        return new RFileInputStream(this.rt, string);
    }

    public RFileOutputStream createFile(String string) throws IOException {
        return new RFileOutputStream(this.rt, string);
    }

    public void removeFile(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(21, string);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "removeFile failed", rPacket);
    }

    public void shutdown() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(4);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "shutdown failed", rPacket);
    }

    public void setSendBufferSize(long l) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(129, (int)l);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "setSendBufferSize failed", rPacket);
    }

    public void setStringEncoding(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(130, string);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "setStringEncoding failed", rPacket);
    }

    public void login(String string, String string2) throws RserveException {
        if (!this.authReq) {
            return;
        }
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        if (this.authType == 1) {
            RPacket rPacket;
            if (this.Key == null) {
                this.Key = "rs";
            }
            if ((rPacket = this.rt.request(1, string + "\n" + jcrypt.crypt(this.Key, string2))) != null && rPacket.isOk()) {
                return;
            }
            try {
                this.s.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.is = null;
            this.os = null;
            this.s = null;
            this.connected = false;
            throw new RserveException(this, "login failed", rPacket);
        }
        RPacket rPacket = this.rt.request(1, string + "\n" + string2);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        try {
            this.s.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.is = null;
        this.os = null;
        this.s = null;
        this.connected = false;
        throw new RserveException(this, "login failed", rPacket);
    }

    public RSession detach() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(48);
        if (rPacket == null || !rPacket.isOk()) {
            throw new RserveException(this, "Cannot detach", rPacket);
        }
        RSession rSession = new RSession(this, rPacket);
        this.close();
        return rSession;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean needLogin() {
        return this.authReq;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void serverEval(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(66, string + "\n");
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "serverEval failed", rPacket);
    }

    public void serverSource(String string) throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(69, string);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "serverSource failed", rPacket);
    }

    public void serverShutdown() throws RserveException {
        if (!this.connected || this.rt == null) {
            throw new RserveException(this, "Not connected");
        }
        RPacket rPacket = this.rt.request(68);
        if (rPacket != null && rPacket.isOk()) {
            return;
        }
        throw new RserveException(this, "serverShutdown failed", rPacket);
    }

    public REXP parse(String string, boolean bl) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support separate parsing step.");
    }

    public REXP eval(REXP rEXP, REXP rEXP2, boolean bl) throws REngineException {
        return new REXPNull();
    }

    public REXP parseAndEval(String string, REXP rEXP, boolean bl) throws REngineException {
        if (rEXP != null) {
            throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
        }
        try {
            return this.eval(string);
        }
        catch (RserveException rserveException) {
            throw new REngineException((REngine)this, rserveException.getMessage());
        }
    }

    public void assign(String string, REXP rEXP, REXP rEXP2) throws REngineException {
        if (rEXP2 != null) {
            throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
        }
        try {
            this.assign(string, rEXP);
        }
        catch (RserveException rserveException) {
            throw new REngineException((REngine)this, rserveException.getMessage());
        }
    }

    public REXP get(String string, REXP rEXP, boolean bl) throws REngineException {
        if (!bl) {
            throw new REngineException((REngine)this, "Rserve doesn't support references");
        }
        try {
            return this.eval("get(\"" + string + "\")");
        }
        catch (RserveException rserveException) {
            throw new REngineException((REngine)this, rserveException.getMessage());
        }
    }

    public REXP resolveReference(REXP rEXP) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public REXP createReference(REXP rEXP) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public void finalizeReference(REXP rEXP) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support references");
    }

    public REXP getParentEnvironment(REXP rEXP, boolean bl) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
    }

    public REXP newEnvironment(REXP rEXP, boolean bl) throws REngineException {
        throw new REngineException((REngine)this, "Rserve doesn't support environments other than .GlobalEnv");
    }
}

