/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao.enhance.registrar.loader;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.nutz.dao.enhance.annotation.Dao;
import org.nutz.dao.enhance.method.holder.AutoCreateTableHolder;
import org.nutz.dao.enhance.registrar.annotation.DaoScan;
import org.nutz.dao.enhance.registrar.annotation.DaoScans;
import org.nutz.dao.enhance.registrar.factory.DaoProxyFactory;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.IocLoading;
import org.nutz.ioc.Iocs;
import org.nutz.ioc.ObjectLoadException;
import org.nutz.ioc.annotation.InjectName;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.meta.IocValue;
import org.nutz.lang.Strings;
import org.nutz.resource.Scans;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaoIocLoader
implements IocLoader {
    private static final Logger log = LoggerFactory.getLogger(DaoIocLoader.class);
    public static final String LOADER_NAME = "*org.nutz.dao.enhance.registrar.loader.DaoIocLoader";
    private final HashMap<String, IocObject> iocBeanNameObject = new HashMap();
    protected Map<String, Set<String>> dataSourcePackagesMapping = new HashMap<String, Set<String>>();

    public DaoIocLoader(String ... packages) {
        for (String pkg : packages) {
            log.info(" > scan '{}'", (Object)pkg);
            for (Class classZ : Scans.me().scanPackage(pkg)) {
                this.addDaoPackages(classZ);
            }
        }
        this.addDaoClass();
        if (this.iocBeanNameObject.isEmpty()) {
            log.warn("NONE @DaoScan  @DaoScans found!! Check your ioc configure!! packages={}", (Object)Arrays.toString(packages));
        }
    }

    public void addDaoClass() {
        this.dataSourcePackagesMapping.forEach((dataSourceName, packages) -> {
            log.info(" > scan '{}'", packages);
            AutoCreateTableHolder.addDataSourceEntityPackages((String)dataSourceName, (Set)packages);
            for (String pkg : packages) {
                for (Class classZ : Scans.me().scanPackage(pkg)) {
                    this.addClass((String)dataSourceName, classZ);
                }
            }
        });
    }

    public void addClass(String dataSourceName, Class<?> classZ) {
        if (classZ.isMemberClass() || classZ.isEnum() || classZ.isAnnotation() || classZ.isAnonymousClass()) {
            return;
        }
        Dao annotation = classZ.getAnnotation(Dao.class);
        if (classZ.isInterface() && Objects.nonNull(annotation)) {
            String beanName = annotation.name();
            if (Strings.isBlank((CharSequence)beanName)) {
                InjectName innm = classZ.getAnnotation(InjectName.class);
                beanName = null != innm && !Strings.isBlank((CharSequence)innm.value()) ? innm.value() : Strings.lowerFirst((CharSequence)classZ.getSimpleName());
            }
            if (this.iocBeanNameObject.containsKey(beanName)) {
                throw new IocException(beanName, "Duplicate beanName=%s, by %s !!  Have been define by %s !!", new Object[]{beanName, classZ.getName(), this.iocBeanNameObject.get(beanName).getType().getName()});
            }
            IocObject iocObject = new IocObject();
            iocObject.setType(classZ);
            iocObject.addArg(new IocValue("normal", classZ));
            iocObject.addArg(Iocs.convert((String)"daoFactory", (boolean)true));
            iocObject.addArg(new IocValue("normal", (Object)dataSourceName));
            iocObject.setFactory(DaoProxyFactory.class.getName() + "#getObject");
            this.iocBeanNameObject.put(beanName, iocObject);
            log.info("   > add '{}' - {}", (Object)beanName, (Object)classZ.getName());
        }
    }

    public void addDaoPackages(Class<?> classZ) {
        DaoScan daoScan;
        if (classZ.isInterface() || classZ.isMemberClass() || classZ.isEnum() || classZ.isAnnotation() || classZ.isAnonymousClass()) {
            return;
        }
        int modify = classZ.getModifiers();
        if (Modifier.isAbstract(modify) || !Modifier.isPublic(modify)) {
            return;
        }
        DaoScans daoScans = classZ.getAnnotation(DaoScans.class);
        if (Objects.nonNull(daoScans)) {
            Arrays.stream(daoScans.value()).forEach(this::addToMapping);
        }
        if (Objects.nonNull(daoScan = classZ.getAnnotation(DaoScan.class))) {
            this.addToMapping(daoScan);
        }
    }

    private void addToMapping(DaoScan daoScan) {
        Set list = this.dataSourcePackagesMapping.getOrDefault(daoScan.dataSource(), new HashSet());
        Arrays.stream(daoScan.value()).forEach(list::add);
        Arrays.stream(daoScan.basePackages()).forEach(list::add);
        Arrays.stream(daoScan.basePackageClasses()).forEach(klass -> list.add(klass.getPackage().getName()));
        this.dataSourcePackagesMapping.put(daoScan.dataSource(), list);
    }

    public String[] getName() {
        return this.iocBeanNameObject.keySet().toArray(new String[0]);
    }

    public IocObject load(IocLoading loading, String name) throws ObjectLoadException {
        if (this.has(name)) {
            return this.iocBeanNameObject.get(name);
        }
        throw new ObjectLoadException("Object '" + name + "' without define! Pls check your ioc configure");
    }

    public boolean has(String name) {
        return this.iocBeanNameObject.containsKey(name);
    }
}

