/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.mvc.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpSession;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.nutz.json.Json;
import org.nutz.json.JsonFormat;
import org.nutz.lang.ContinueLoop;
import org.nutz.lang.Each;
import org.nutz.lang.ExitLoop;
import org.nutz.lang.Lang;
import org.nutz.lang.LoopException;
import org.nutz.lang.Streams;
import org.nutz.lang.random.R;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.mvc.websocket.WsHandler;
import org.nutz.plugins.mvc.websocket.WsRoomProvider;
import org.nutz.plugins.mvc.websocket.handler.SimpleWsHandler;
import org.nutz.plugins.mvc.websocket.room.MemoryRoomProvider;

public abstract class AbstractWsEndpoint {
    protected ConcurrentHashMap<String, WsHandler> handlers = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    protected WsRoomProvider roomProvider = new MemoryRoomProvider();
    protected Field idField;
    private static final Log log = Logs.get();
    protected String roomPrefix = "wsroom:";

    public void onOpen(Session session, EndpointConfig config) {
        this.changeSessionId(session);
        String wsid = session.getId();
        WsHandler handler = this.createHandler(session, config);
        handler.setRoomProvider(this.roomProvider);
        handler.setSession(session);
        handler.setHttpSession((HttpSession)config.getUserProperties().get("HttpSession"));
        handler.setEndpoint(this);
        handler.init();
        if (!this.isUndertowSession(session)) {
            try {
                session.addMessageHandler((MessageHandler)handler);
            }
            catch (Exception e) {
                log.debug((Object)"skip addMessageHandler");
            }
        }
        this.sessions.put(wsid, session);
        this.handlers.put(wsid, handler);
    }

    @OnOpen
    public void _onOpen(Session session, EndpointConfig config) {
        this.onOpen(session, config);
    }

    public void onClose(Session session, CloseReason closeReason) {
        this.sessions.remove(session.getId());
        WsHandler handler = this.handlers.remove(session.getId());
        if (handler != null) {
            handler.depose();
        }
    }

    @OnClose
    public void _onClose(Session session, CloseReason closeReason) {
        this.onClose(session, closeReason);
    }

    public void onError(Session session, Throwable throwable) {
        this.onClose(session, null);
    }

    @OnError
    public void _onError(Session session, Throwable throwable) {
        this.onError(session, throwable);
    }

    public void onMesssageString(Session session, String msg) {
        WsHandler handler = this.getHandler(session.getId());
        if (handler != null) {
            handler.onMessage(msg);
        }
    }

    @OnMessage
    public void _onMesssageString(Session session, String msg) {
        this.onMesssageString(session, msg);
    }

    protected void changeSessionId(Session session) {
        try {
            if (this.isUndertowSession(session)) {
                return;
            }
            if (this.idField == null) {
                this.idField = session.getClass().getDeclaredField("id");
                this.idField.setAccessible(true);
            }
            this.idField.set(session, R.UU32());
        }
        catch (Exception e) {
            log.debug((Object)("change session id fail. " + e.getMessage()));
        }
    }

    public WsHandler createHandler(Session session, EndpointConfig config) {
        return new SimpleWsHandler(this.roomPrefix);
    }

    public Session getSession(String wsid) {
        return this.getSession(wsid, true);
    }

    public Session getSession(String wsid, boolean opened) {
        Session session = this.sessions.get(wsid);
        if (session == null) {
            return null;
        }
        if (opened && !session.isOpen()) {
            return null;
        }
        return session;
    }

    public WsHandler getHandler(String wsid) {
        return this.handlers.get(wsid);
    }

    public boolean sendText(String wsid, CharSequence text) {
        Session session = this.getSession(wsid);
        if (session == null) {
            return false;
        }
        session.getAsyncRemote().sendText(text.toString());
        return true;
    }

    public boolean sendTextSync(String wsid, CharSequence text) {
        Session session = this.getSession(wsid, true);
        if (session == null) {
            return false;
        }
        try {
            session.getBasicRemote().sendText(text.toString());
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public boolean sendJson(String wsid, Object msg) {
        Session session = this.getSession(wsid);
        if (session == null) {
            return false;
        }
        session.getAsyncRemote().sendText(Json.toJson((Object)msg, (JsonFormat)JsonFormat.full()));
        return true;
    }

    public boolean sendJsonSync(String wsid, Object msg) {
        Session session = this.getSession(wsid, true);
        if (session == null) {
            return false;
        }
        try {
            session.getBasicRemote().sendText(Json.toJson((Object)msg, (JsonFormat)JsonFormat.full()));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public ByteBuffer toByteBuffer(Object msg) {
        if (msg == null) {
            return null;
        }
        ByteBuffer buf = msg instanceof ByteBuffer ? (ByteBuffer)msg : (msg instanceof byte[] ? ByteBuffer.wrap((byte[])msg) : (msg instanceof InputStream ? ByteBuffer.wrap(Streams.readBytesAndClose((InputStream)((InputStream)msg))) : ByteBuffer.wrap(msg.toString().getBytes())));
        return buf;
    }

    public boolean sendBinary(String wsid, Object msg) {
        Session session = this.getSession(wsid);
        if (session == null || msg == null) {
            return false;
        }
        ByteBuffer buf = this.toByteBuffer(msg);
        if (buf == null) {
            return false;
        }
        session.getAsyncRemote().sendBinary(buf);
        return true;
    }

    public boolean sendBinarySync(String wsid, Object msg) {
        Session session = this.getSession(wsid);
        if (session == null || msg == null) {
            return false;
        }
        ByteBuffer buf = this.toByteBuffer(msg);
        if (buf == null) {
            return false;
        }
        try {
            session.getBasicRemote().sendBinary(buf);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public void each(String room, final Each<Session> callback) {
        Set<String> wsids = this.roomProvider.wsids(room);
        if (wsids == null || wsids.isEmpty()) {
            return;
        }
        String[] tmp = wsids.toArray(new String[wsids.size()]);
        Lang.each((Object)tmp, (Each)new Each<String>(){

            public void invoke(int index, String ele, int length) throws ExitLoop, ContinueLoop, LoopException {
                Session session = AbstractWsEndpoint.this.getSession(ele);
                if (session != null) {
                    callback.invoke(index, (Object)session, length);
                }
            }
        });
    }

    public WsRoomProvider getRoomProvider() {
        return this.roomProvider;
    }

    public void setRoomProvider(WsRoomProvider roomProvider) {
        this.roomProvider = roomProvider;
    }

    public String getRoomPrefix() {
        return this.roomPrefix;
    }

    public void setRoomPrefix(String roomPrefix) {
        this.roomPrefix = roomPrefix;
    }

    public boolean isUndertowSession(Session session) {
        return session.getClass().getName().equals("io.undertow.websockets.jsr.UndertowSession");
    }
}

