/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.mvc.websocket.handler;

import javax.websocket.MessageHandler;
import javax.websocket.Session;
import org.nutz.lang.Each;
import org.nutz.lang.Strings;
import org.nutz.lang.util.NutMap;
import org.nutz.plugins.mvc.websocket.handler.AbstractWsHandler;

public class SimpleWsHandler
extends AbstractWsHandler
implements MessageHandler.Whole<String> {
    protected String nickname;

    public SimpleWsHandler() {
        this("wsroom:");
    }

    public SimpleWsHandler(String prefix) {
        super(prefix);
    }

    public void join(NutMap req) {
        this.join(req.getString("room"));
    }

    public void left(NutMap req) {
        this.left(req.getString("room"));
    }

    public void nickname(NutMap req) {
        String nickname = req.getString("nickname");
        if (!Strings.isBlank((CharSequence)nickname)) {
            this.nickname = nickname;
        }
    }

    public void msg2room(final NutMap req) {
        final String room = req.getString("room");
        if (room == null) {
            return;
        }
        String _room = room;
        if (this.prefix.length() > 0 && !room.startsWith(this.prefix)) {
            _room = this.prefix + room;
        }
        this.endpoint.each(_room, new Each<Session>(){

            public void invoke(int index, Session ele, int length) {
                if (ele.getId().equals(SimpleWsHandler.this.session.getId())) {
                    return;
                }
                NutMap resp = new NutMap("action", (Object)"msg");
                resp.setv("room", (Object)room);
                resp.setv("from", (Object)SimpleWsHandler.this.session.getId());
                resp.setv("msg", req.get((Object)"msg"));
                if (SimpleWsHandler.this.nickname != null) {
                    resp.setv("nickname", (Object)SimpleWsHandler.this.nickname);
                }
                SimpleWsHandler.this.endpoint.sendJson(ele.getId(), resp);
            }
        });
    }
}

