/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.mvc.websocket.room;

import java.util.Set;
import org.nutz.integration.jedis.JedisAgent;
import org.nutz.plugins.mvc.websocket.WsRoomProvider;
import redis.clients.jedis.Jedis;

public class JedisRoomProvider
implements WsRoomProvider {
    protected JedisAgent jedisAgent;

    public JedisRoomProvider(JedisAgent jedisAgent) {
        this.jedisAgent = jedisAgent;
    }

    @Override
    public Set<String> wsids(String room) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            Set set = jedis.smembers(room);
            return set;
        }
    }

    @Override
    public void join(String room, String wsid) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            jedis.sadd(room, new String[]{wsid});
        }
    }

    @Override
    public void left(String room, String wsid) {
        try (Jedis jedis = this.jedisAgent.getResource();){
            jedis.srem(room, new String[]{wsid});
        }
    }
}

