/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.plugins.zdoc.html;

import java.util.List;
import java.util.Map;
import org.nutz.json.Json;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.lang.Strings;
import org.nutz.lang.tmpl.Tmpl;
import org.nutz.lang.util.Node;
import org.nutz.lang.util.NutBean;
import org.nutz.lang.util.NutMap;
import org.nutz.lang.util.Tag;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.plugins.zdoc.NutD;
import org.nutz.plugins.zdoc.NutDSet;
import org.nutz.plugins.zdoc.NutDSetRender;
import org.nutz.plugins.zdoc.NutDoc;

public abstract class AbstractHtmlDSetRender
implements NutDSetRender {
    private static final Log log = Logs.get();
    private NutMap meta;
    private Tmpl docTmpl;
    private Tmpl indexTmpl;
    private String copySetRs;

    @Override
    public void render(NutDSet ds, String target) {
        log.info((Object)("HtmlDSetRender: " + target));
        this.checkTarget(target);
        this.meta = ds.getMeta();
        log.info((Object)Json.toJson((Object)this.meta));
        this.checkPrimerObj(ds);
        log.info((Object)"PrimerObj Checked");
        String tmplDirName = this.meta.getString("tmpl-dir", "_tmpl");
        this.docTmpl = this.loadTmpl(tmplDirName, "doc.html", "dft_tmpl_doc.html");
        this.indexTmpl = this.loadTmpl(tmplDirName, "index.html", "dft_tmpl_index.html");
        log.info((Object)"Template Loaded");
        this.copySetRs = this.meta.getString("copy-set-rs", "^.+[.](png|jpe?g|gif)$");
        String copyRss = this.meta.getString("copy-paths");
        if (!Strings.isBlank((CharSequence)copyRss)) {
            String[] rsPaths = Strings.splitIgnoreBlank((String)copyRss, (String)"[\n,:]");
            log.infof("Will copy %d resources:", new Object[]{rsPaths.length});
            int i = 0;
            while (i < rsPaths.length) {
                String rsph = rsPaths[i];
                log.infof(" + %d + : %s", new Object[]{i, rsph});
                this.copyResource(rsph);
                ++i;
            }
        } else {
            log.info((Object)"No resource need to be copied.");
        }
        this.__do_render(ds);
        String indexName = this.meta.getString("index-name", "tree.html");
        if (!"none".equals(indexName)) {
            Tag index = this.__gen_indexes(ds);
            NutMap c = new NutMap().attach((Map)this.meta);
            c.put((Object)"indexes", (Object)index.toOuterHtml(true));
            String html = this.indexTmpl.render((NutBean)c, false);
            this.writeToTarget(indexName, html);
            log.infof("Index '%s' generated.", new Object[]{indexName});
        } else {
            log.info((Object)"No index need to be generated.");
        }
    }

    private Tag __gen_indexes(NutDSet ds) {
        Tag ul = Tag.tag((String)"ul", (String[])new String[]{".ds-index"});
        for (NutD d : ds.getChildren()) {
            Tag li = ul.add("li", new String[0]);
            if (d.isSet()) {
                li.add("b", new String[0]).setText(d.getTitle(d.getName()));
                Tag ul2 = this.__gen_indexes((NutDSet)d);
                li.add(new Node[]{ul2});
                continue;
            }
            if (d.isDoc()) {
                String rph = d.getPath();
                rph = Files.renameSuffix((String)rph, (String)".html");
                li.add("a", new String[0]).attr("href", rph).setText(d.getTitle(d.getName()));
                continue;
            }
            throw Lang.impossible();
        }
        return ul;
    }

    private void __do_render(NutDSet ds) {
        this.copyToTarget(ds.getPath(), this.copySetRs);
        for (NutD d : ds.getChildren()) {
            if (d.isSet()) {
                this.__do_render((NutDSet)d);
                continue;
            }
            if (d.isDoc()) {
                NutDoc doc = (NutDoc)d;
                String ph = doc.getPath();
                String taph = Files.renameSuffix((String)ph, (String)".html");
                log.info((Object)(" -> " + taph));
                NutMap c = new NutMap().attach((Map)doc.getMeta());
                c.put((Object)"main", (Object)doc.getRootTag().toInnerHtml(false));
                c.put((Object)"tags", (Object)this.__gen_meta_list(doc.getTags(), ".doc-tags"));
                c.put((Object)"authors", (Object)this.__gen_meta_list(doc.getAuthors(), ".doc-authors"));
                c.put((Object)"path", (Object)taph);
                c.put((Object)"title", (Object)Files.getMajorName((String)doc.getName()));
                String html = this.docTmpl.render((NutBean)c, false);
                this.writeToTarget(taph, html);
                continue;
            }
            throw Lang.impossible();
        }
    }

    private String __gen_meta_list(List<String> list, String selector) {
        Tag div = Tag.tag((String)"div", (String[])new String[]{selector});
        Tag ul = div.add("ul", new String[0]);
        for (String str : list) {
            ul.add("li", new String[0]).setText(str);
        }
        return div.toOuterHtml(true);
    }

    protected abstract Tmpl loadTmpl(String var1, String var2, String var3);

    protected abstract void copyToTarget(String var1, String var2);

    protected abstract void writeToTarget(String var1, String var2);

    protected abstract void copyResource(String var1);

    protected abstract void checkTarget(String var1);

    protected abstract Tmpl loadTmpl(String var1);

    protected abstract void checkPrimerObj(NutDSet var1);
}

